//#preprocess
/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbweather;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.Manager;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.BitmapField;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.container.HorizontalFieldManager;
import net.rim.device.api.ui.container.VerticalFieldManager;

import org.bbweather.data.CurrentConditionsData;

import org.bbutils.ColorLabelField;

//#ifdef OS_COMPILE_ATLEAST_4_10
import net.rim.blackberry.api.homescreen.HomeScreen;
//#endif

import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.DrawStyle;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.FontFamily;
import net.rim.device.api.ui.Ui;
import net.rim.device.api.ui.Graphics;

import java.util.Date;
import net.rim.device.api.i18n.SimpleDateFormat;

import net.rim.device.api.system.Display;
import net.rim.device.api.system.Characters;

//#ifdef OS_COMPILE_ATLEAST_4_70
import net.rim.device.api.ui.FieldChangeListener;
//#endif

public class CurrentConditionsScreen extends AbstractWeatherScreen {

    private static CurrentConditionsScreen screen = null;

    private BitmapField bitmapField = null;

    private RichTextField descriptionField = null;

    private ColorLabelField temperatureField = null;

    private LabelField feelsLikeStaticField = null;

    private LabelField feelsLikeField = null;

    private LabelField uvIndexLabelField = null;

    private LabelField windLabelField = null;

    private LabelField humidityLabelField = null;

    private LabelField pressureLabelField = null;

    private LabelField dewPointLabelField = null;

    private LabelField visibilityLabelField = null;

    private LabelField moonLabelField = null;

    private LabelField sunrsLabelField = null;

    private LabelField uvIndexValueField = null;

    private LabelField windValueField = null;

    private LabelField humidityValueField = null;

    private LabelField pressureValueField = null;

    private LabelField dewPointValueField = null;

    private LabelField visibilityValueField = null;

    private LabelField sunrsValueField = null;

    private LabelField moonValueField = null;

    private LabelField spacerField1 = null;

    private LabelField spacerField2 = null;

    private LabelField spacerField3 = null;

    private LabelField spacerField4 = null;

    public static CurrentConditionsScreen getInstance() {

        if (screen == null)
            screen = new CurrentConditionsScreen();

        return screen;
    }

//#ifdef OS_COMPILE_ATLEAST_4_70
    protected FieldChangeListener button1Press = new FieldChangeListener() {
        public void fieldChanged(Field field, int context) {
            displayScreen(1); //Daily
        }
    };
    protected FieldChangeListener button2Press = new FieldChangeListener() {
        public void fieldChanged(Field field, int context) {
            displayScreen(2); //Hourly
        }
    };

    private CurrentConditionsScreen() {
        super();

        setTitle("BBWeather Current Conditions");

        screenID = 0;

        button1.setLabel("Daily");
        button2.setLabel("Hourly");
        button1.setChangeListener(button1Press);
        button2.setChangeListener(button2Press);
    }
//#else
    private CurrentConditionsScreen() {
        super();

        setTitle("BBWeather Current Conditions");

        screenID = 0;
    }
//#endif

    public void cleanup() {
        synchronized (UiApplication.getEventLock()) {
            if (managerRoot != null)
                removeManagerRoot();
            //locationNameField.setFont(defaultFontLess4);
        }
    }

    public void updateData() {
        //System.out.println("*** Updating Current Conditions display data...");

        CurrentConditionsData ccData = null;

        BBWeatherOptions options = BBWeatherOptions.load(false);
        String locationId = options.getCurrentLocationId();
        if (locationId != null)
            ccData = WeatherDataManager.getInstance().getCurrentConditionsByLocationId(locationId);
        //System.out.println("*** locationId=" + locationId + " ccData=" + ccData);

        if (ccData != null) {
            synchronized (UiApplication.getEventLock()) {

                if (!initFonts()) {
                    if (managerRoot != null)
                        removeManagerRoot();
                    locationNameField.setText("Severe Error getting fonts for: " + options.mainFont);
                    return;
                }

                if (managerRoot == null)
                    createManagerRoot();

                hideManagerRoot();

                locationNameField.setText(ccData.locationData.name);
                locationNameField.setFont(defaultFontBold);
                lastUpdateField.setText("Updated " + ccData.lastUpdate);
                lastUpdateField.setFont(defaultFontLess4);

                // Set Summary info
                bitmapField.setBitmap(ccData.bitmap);
                descriptionField.setText(stackString(ccData.description));
                descriptionField.setFont(defaultFontLess4Bold);
                temperatureField.setText(ccData.temperature
                        + ccData.unitData.temperature);
                temperatureField.setFont(defaultFontMore6Bold);
                temperatureField.setColor(options.currentTempColor);
                feelsLikeStaticField.setFont(defaultFontLess4Bold);
                feelsLikeField.setText(ccData.feelsLikeTemperature
                        + ccData.unitData.temperature);
                feelsLikeField.setFont(defaultFontLess4Bold);

                // Set Detail info
                uvIndexLabelField.setFont(defaultFontLess4Bold);
                uvIndexValueField.setText(ccData.uvIndexData.value + " "
                        + ccData.uvIndexData.description);
                uvIndexValueField.setFont(defaultFontLess4);
                windLabelField.setFont(defaultFontLess4Bold);
                if (ccData.windData.speed.equalsIgnoreCase("calm")) {
                    windValueField.setText(ccData.windData.description);
                } else {
                    windValueField.setText(ccData.windData.description + " at "
                            + ccData.windData.speed + ccData.unitData.speed);
                }
                windValueField.setFont(defaultFontLess4);
                humidityLabelField.setFont(defaultFontLess4Bold);
                humidityValueField.setText(ccData.humidity + "%");
                humidityValueField.setFont(defaultFontLess4);
                pressureLabelField.setFont(defaultFontLess4Bold);
                pressureValueField.setText(ccData.barometricData.currentPressure
                        + ccData.unitData.pressure
                        + " "
                        + ccData.barometricData.description);
                pressureValueField.setFont(defaultFontLess4);
                dewPointLabelField.setFont(defaultFontLess4Bold);
                dewPointValueField.setText(ccData.dewPoint
                        + ccData.unitData.temperature);
                dewPointValueField.setFont(defaultFontLess4);
                visibilityLabelField.setFont(defaultFontLess4Bold);
                visibilityValueField.setText(ccData.visibility
                        + ccData.unitData.distance);
                visibilityValueField.setFont(defaultFontLess4);
                sunrsLabelField.setFont(defaultFontLess4Bold);
                sunrsValueField.setText(ccData.locationData.sunrise + "/"
                        + ccData.locationData.sunset);
                sunrsValueField.setFont(defaultFontLess4);
                moonLabelField.setFont(defaultFontLess4Bold);
                moonValueField.setText(ccData.moonData.description);
                moonValueField.setFont(defaultFontLess4);

                spacerField1.setFont(defaultFontLess4);
                spacerField2.setFont(defaultFontLess4);
                spacerField3.setFont(defaultFontLess4);
                spacerField4.setFont(defaultFontLess4);
                attributionField.setFont(defaultFontLess4);

                displayManagerRoot();
//#ifdef OS_COMPILE_ATLEAST_4_10
                try {
                    if (options.enableHomeScreen && (options.homeScreenIcon != 0 || options.homeScreenRollover != 0)) {
                        String shortCutKey = options.getLocationShortcutKey(locationId);
                        //SimpleDateFormat sdFormat = new SimpleDateFormat("h:mma M/dd/yy");
                        //String theTime = sdFormat.formatLocal(new Date().getTime());
                        /*String theDate = "";
                        String theTime = "";
                        int firstBreak = 0;
                        int nextBreak = 0;
                        firstBreak = ccData.lastUpdate.indexOf(" ", nextBreak);
                        if (firstBreak != 0) {
                            theDate = ccData.lastUpdate.substring(0, firstBreak);
                            nextBreak = ccData.lastUpdate.indexOf(" ", firstBreak + 1);
                            theTime = ccData.lastUpdate.substring(firstBreak + 1, nextBreak);

                            firstBreak = nextBreak; //ccData.lastUpdate.indexOf(" ", nextBreak + 1);
                            nextBreak = ccData.lastUpdate.indexOf(" ", firstBreak + 1);
                            if (firstBreak != 0) {
                                //nextBreak = ccData.lastUpdate.indexOf(" ", nextBreak + 1);
                                theTime += ccData.lastUpdate.substring(firstBreak, nextBreak);
                            }
                        }*/
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_20
                        SimpleDateFormat sdFormat;
                        String theTime;
                        String appName;
                        /*String appName = ccData.temperature + "" + ccData.unitData.temperature
                            + " " + ccData.description
                            + (shortCutKey == null ? "" : ", " + shortCutKey)
                            + ", " + theTime;*/
                        /*String appName = ccData.temperature + "" + ccData.unitData.temperature
                                    + " " + ccData.description
                                    + (shortCutKey == null ? "" : ", " + shortCutKey)
                                    //+ ", " + ccData.locationData.name
                                    + ", " + ccData.lastUpdate;*/

                        String theTemp = ccData.temperature;
                        if (options.useFeelsLike) {
                            theTemp = ccData.feelsLikeTemperature;
                        }

                        if (options.homeScreenText == 0) {
                            appName = "BBWeather";
                        } else if (options.homeScreenText == 1) { //Conditions
                            appName = ccData.description
                                + (shortCutKey == null ? "" : ", " + shortCutKey);
                        } else if (options.homeScreenText == 2) { //Full
                            appName = theTemp + "" + ccData.unitData.temperature
                                + " " + ccData.description
                                + (shortCutKey == null ? "" : ", " + shortCutKey);
                        } else if (options.homeScreenText == 3) { //Conditions + Time
                            sdFormat = new SimpleDateFormat("h:mma");
                            theTime = sdFormat.formatLocal(new Date().getTime());
                            appName = ccData.description
                                + (shortCutKey == null ? "" : ", " + shortCutKey)
                                + ", " + theTime;
                        } else if (options.homeScreenText == 4) { //Full + Time
                            sdFormat = new SimpleDateFormat("h:mma M/dd/yy");
                            theTime = sdFormat.formatLocal(new Date().getTime());
                            appName = theTemp + "" + ccData.unitData.temperature
                                + " " + ccData.description
                                + (shortCutKey == null ? "" : ", " + shortCutKey)
                                + ", " + theTime;
                        } else { //UpDate/Time
                            sdFormat = new SimpleDateFormat("h:mma M/dd/yy");
                            theTime = sdFormat.formatLocal(new Date().getTime());
                            appName = theTime;
                        }

                        HomeScreen.setName(appName);
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_10
                        if (options.homeScreenIcon == 1)
                            HomeScreen.updateIcon(ccData.bitmap);
                        if (options.homeScreenRollover == 1)
                            HomeScreen.setRolloverIcon(ccData.bitmap);

                        if (options.homeScreenIcon > 1 || options.homeScreenRollover > 1) {
                            int[] bgData = new int[32 * 32 + 1];
                            int[] rlData = new int[32 * 32 + 1];
                            int[] textData = new int[32 * 32 + 1];
                            int[] newDataIcon = new int[32 * 32 + 1];
                            int[] newDataRL = new int[32 * 32 + 1];

                            Bitmap bgIcon = null;
                            Bitmap rlIcon = null;

                            if (options.homeScreenIcon == 2)
                                bgIcon = ccData.bitmap;
                            else
                                bgIcon = Bitmap.getBitmapResource("images/blank.png");

                            if (options.homeScreenRollover == 2)
                                rlIcon = ccData.bitmap;
                            else
                                rlIcon = Bitmap.getBitmapResource("images/blank.png");

                            bgIcon.getARGB(bgData, 0, 32, 0, 0, 32, 32);
                            rlIcon.getARGB(rlData, 0, 32, 0, 0, 32, 32);

                            Bitmap textIcon = new Bitmap(32, 32);
                            Graphics g = new Graphics(textIcon);
                            g.setDrawingStyle(Graphics.DRAWSTYLE_AALINES, true);
                            FontFamily fontFamily = FontFamily.forName(options.iconFont); //user option
                            int pointSZ = 12;
                            Font theFont = fontFamily.getFont(Font.BOLD, pointSZ, Ui.UNITS_pt);

                            int width = theFont.getAdvance(theTemp + "");
                            while (width > 30 && pointSZ > 0) {
                                pointSZ -= 1;
                                theFont = fontFamily.getFont(Font.BOLD, pointSZ, Ui.UNITS_pt);
                                width = theFont.getAdvance(theTemp + "");
                            }

                            int height = theFont.getHeight();
                            width = (32 - width) / 2;
                            height = (32 - height) / 2;

                            g.setFont(theFont);
                            g.setColor(options.homeScreenTextColor);
                            g.drawText(theTemp + "", width, height, DrawStyle.TOP | DrawStyle.LEFT);
                            textIcon.getARGB(textData, 0, 32, 0, 0, 32, 32);

                            for (int i = 0; i < bgData.length - 1; i++) {
                                //if ((textData[i] & 0x00FFFFFF) != 0x00FFFFFF)
                                if (textData[i] == 0xFFFFFFFF) {
                                    newDataIcon[i] = bgData[i];
                                    newDataRL[i] = rlData[i];
                                } else {
                                    newDataIcon[i] = textData[i];
                                    newDataRL[i] = textData[i];
                                }
                            }

                            if (options.homeScreenIcon > 1) {
                                Bitmap newIcon = new Bitmap(32, 32);
                                newIcon.setARGB(newDataIcon, 0, 32, 0, 0, 32, 32);
                                HomeScreen.updateIcon(newIcon);
                            }

                            if (options.homeScreenRollover > 1) {
                                Bitmap newIcon = new Bitmap(32, 32);
                                newIcon.setARGB(newDataRL, 0, 32, 0, 0, 32, 32);
                                HomeScreen.setRolloverIcon(newIcon);
                            }

                            g = null;
                        }
                        //System.out.println("*** BBWeather: HomeScreen " + locationId);
                    }
                } catch (Exception e) {
                    Bitmap homeIcon = null;
                    if (locationId == null)
                        homeIcon = Bitmap.getBitmapResource("images/main.png");
                    else
                        homeIcon = Bitmap.getBitmapResource("images/weather/na.png");
                    SimpleDateFormat sdFormat = new SimpleDateFormat("h:mma M/dd/yy");
                    String theTime = sdFormat.formatLocal(new Date().getTime());
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_20
                    HomeScreen.setName("BBWeather, " + theTime);
//#endif
//#ifdef OS_COMPILE_ATLEAST_4_10
                    HomeScreen.updateIcon(homeIcon);
                    HomeScreen.setRolloverIcon(null);

                    //System.out.println("*** Error current conditions thread: " + e.getMessage());
                }
//#endif
            }

        } else {
            synchronized (UiApplication.getEventLock()) {
                if (managerRoot != null)
                    removeManagerRoot();
                locationNameField.setText("Retrieving Weather, please wait...");
                if (defaultFont != null)
                    locationNameField.setFont(defaultFont);
            }
            WeatherThreadManager.getInstance().currentConditionsForceUpdate();
        }
    }

    /*protected void makeMenu(Menu menu, int instance) {

        super.makeMenu(menu, instance);

        MenuItem item = new MenuItem("Forecast", 800000000, 100) {

            public void run() {

            }
        };
        menu.add(item);
        item = new MenuItem("Hourly Conditions", 800000000, 100) {

            public void run() {
                displayHourlyScreen();
            }
        };
        menu.add(item);
        item = new MenuItem("Update Now", 900000000, 100) {

            public void run() {
                WeatherThreadManager.getInstance().currentConditionsForceUpdate();
            }
        };
        menu.add(item);
    }*/

    //reorganize function and add shortcut to open hourly screen
    protected boolean keyDown(int keycode, int time) {
        if (!isProcessingKey) {
            int iStatus = Keypad.status(keycode);
            char keyChar = Keypad.map(keycode);

            switch (keyChar) {
                case Characters.SPACE:
                    isProcessingKey = true;
                    if (iStatus == 1) {
                        WeatherThreadManager.getInstance().currentConditionsForceUpdate();
                    /*} else if (iStatus == 34) { //34 = left_shift, 66 = right shift STATUS_SHIFT Keypad.KEY_SHIFT_LEFT
                        displayForecastScreenQuick();*/
                    } else {
                        displayScreen(1);
                    }
                    isProcessingKey = false;
                    return true;
                case Characters.COLON:
                    isProcessingKey = true;
                    if (iStatus == 1) {
                        displayScreen(2);
                    }/* else {
                    }*/
                    isProcessingKey = false;
                    return true;
                case Characters.DIGIT_SIX:
                    isProcessingKey = true;
                    if (iStatus == 1) {
                        displayScreen(1);
                    }/* else {
                    }*/
                    isProcessingKey = false;
                    return true;
                default:
                    break;
            }
        }

        return super.keyDown(keycode, time);
    }

    /*private void displayForecastScreen() {
        UiApplication.getUiApplication().invokeLater(new Runnable() {

            public void run() {
                UiApplication.getUiApplication().popScreen(CurrentConditionsScreen.this);
                UiApplication.getUiApplication().pushScreen(ForecastScreen.getInstance());
                isProcessingKey = false;
            }
        });
    }

    private void displayHourlyScreen() {
        UiApplication.getUiApplication().invokeLater(new Runnable() {

            public void run() {
                UiApplication.getUiApplication().popScreen(CurrentConditionsScreen.this);
                //2009-02-20 for some reason, if you are on hourly screen, switch to another app, then switch back to BBWeather
                // it would be on the CurrentConditions Screen or the Forecast Screen and would crash trying to go back to the hourly screen
                if (!HourlyScreen.getInstance().isDisplayed())
                    UiApplication.getUiApplication().pushScreen(HourlyScreen.getInstance());
                isProcessingKey = false;
            }
        });
    }*/

    /*private void displayForecastScreenQuick() {
        UiApplication.getUiApplication().invokeLater(new Runnable() {

            public void run() {
                UiApplication.getUiApplication().popScreen(CurrentConditionsScreen.this);
                UiApplication.getUiApplication().pushScreen(ForecastScreenQuick.getInstance());
                isProcessingKey = false;
            }
        });
    }*/

    private void createManagerRoot() {

        managerRoot = new VerticalFieldManager(VerticalFieldManager.VERTICAL_SCROLL
            | VerticalFieldManager.VERTICAL_SCROLLBAR | VerticalFieldManager.HORIZONTAL_SCROLL);  //added Manager.HORIZONTAL_SCROLL to fix a bug with the Storm that allowed horizontal scroll past edge of page

        lastUpdateField = new LabelField(null, Field.FOCUSABLE) {
            protected void layout(int width, int height)  {
                super.layout(Display.getWidth(), defaultFontLess4Bold.getHeight());
                setExtent(Display.getWidth(), defaultFontLess4Bold.getHeight());
            }
        };
        managerRoot.add(lastUpdateField);
        // Just used for spacing
        spacerField1 = new LabelField(" ");
        managerRoot.add(spacerField1);

        HorizontalFieldManager manager = new HorizontalFieldManager(Field.FIELD_LEFT);
        manager.add(getSummaryInfo());
        spacerField2 = new LabelField("  ");
        manager.add(spacerField2);
        manager.add(getDetailInfo());
        managerRoot.add(manager);

        // Just used for spacing
        spacerField3 = new LabelField(" ");
        managerRoot.add(spacerField3);

        managerRoot.add(getAttributionInfo());
    }

    /*private void doClose() {
        UiApplication.getUiApplication().popScreen(CurrentConditionsScreen.this);
        UiApplication.getUiApplication().requestBackground();
    }*/

    private Manager getSummaryInfo() {

        HorizontalFieldManager managerRoot = new HorizontalFieldManager(Field.FIELD_HCENTER
                | Field.FIELD_VCENTER);

        VerticalFieldManager manager1 = new VerticalFieldManager();
        bitmapField = new BitmapField(null, Field.FIELD_HCENTER);
        manager1.add(bitmapField);
        descriptionField = new RichTextField(null, RichTextField.USE_TEXT_WIDTH
                | RichTextField.TEXT_ALIGN_HCENTER | Field.FIELD_HCENTER);
        manager1.add(descriptionField);

        //VerticalFieldManager manager2 = new VerticalFieldManager();
        temperatureField = new ColorLabelField(null, Field.FIELD_HCENTER
                | Field.FOCUSABLE);
        manager1.add(temperatureField);
        feelsLikeStaticField = new LabelField("Feels Like", Field.FIELD_HCENTER);
        manager1.add(feelsLikeStaticField);
        feelsLikeField = new LabelField(null, Field.FIELD_HCENTER
                | Field.FOCUSABLE);
        manager1.add(feelsLikeField);

        managerRoot.add(manager1);
        // Spacer
        spacerField4 = new LabelField(" ");
        //managerRoot.add(spacerField4);
        //managerRoot.add(manager2);

        return managerRoot;
    }

    private Manager getDetailInfo() {

        HorizontalFieldManager managerRoot = new HorizontalFieldManager(Field.FIELD_HCENTER);

        VerticalFieldManager manager1 = new VerticalFieldManager();
        uvIndexLabelField = new LabelField("UV Index: ", Field.FIELD_LEFT);
        manager1.add(uvIndexLabelField);
        windLabelField = new LabelField("Wind: ", Field.FIELD_LEFT);
        manager1.add(windLabelField);
        humidityLabelField = new LabelField("Humidity: ", Field.FIELD_LEFT);
        manager1.add(humidityLabelField);
        pressureLabelField = new LabelField("Pressure: ", Field.FIELD_LEFT);
        manager1.add(pressureLabelField);
        dewPointLabelField = new LabelField("Dew Point: ", Field.FIELD_LEFT);
        manager1.add(dewPointLabelField);
        visibilityLabelField = new LabelField("Visibility: ", Field.FIELD_LEFT);
        manager1.add(visibilityLabelField);
        sunrsLabelField = new LabelField("Rise/Set: ", Field.FIELD_LEFT);
        manager1.add(sunrsLabelField);
        moonLabelField = new LabelField("Moon: ", Field.FIELD_LEFT);
        manager1.add(moonLabelField);

        VerticalFieldManager manager2 = new VerticalFieldManager();
        uvIndexValueField = new LabelField(null, Field.FIELD_LEFT
                | Field.FOCUSABLE);
        manager2.add(uvIndexValueField);
        windValueField = new LabelField(null, Field.FIELD_LEFT
                | Field.FOCUSABLE);
        manager2.add(windValueField);
        humidityValueField = new LabelField(null, Field.FIELD_LEFT
                | Field.FOCUSABLE);
        manager2.add(humidityValueField);
        pressureValueField = new LabelField(null, Field.FIELD_LEFT
                | Field.FOCUSABLE);
        manager2.add(pressureValueField);
        dewPointValueField = new LabelField(null, Field.FIELD_LEFT
                | Field.FOCUSABLE);
        manager2.add(dewPointValueField);
        visibilityValueField = new LabelField(null, Field.FIELD_LEFT
                | Field.FOCUSABLE);
        manager2.add(visibilityValueField);
        sunrsValueField = new LabelField(null, Field.FIELD_LEFT
                | Field.FOCUSABLE);
        manager2.add(sunrsValueField);
        moonValueField = new LabelField(null, Field.FIELD_LEFT
                | Field.FOCUSABLE);
        manager2.add(moonValueField);

        managerRoot.add(manager1);
        managerRoot.add(manager2);

        return managerRoot;
    }
}
