//#preprocess
/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbweather;

import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.Manager;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.BitmapField;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.container.HorizontalFieldManager;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.ui.container.FlowFieldManager;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.Color;

import org.bbweather.data.ForecastData;
import org.bbweather.data.WindData;

import org.bbutils.ColorLabelField;

import net.rim.device.api.system.Display;
import net.rim.device.api.system.Characters;

//#ifdef OS_COMPILE_ATLEAST_4_70
import net.rim.device.api.ui.FieldChangeListener;
//#endif

public class HourlyScreen extends AbstractWeatherScreen {

    private static final int MAX_HOURLY_DAYS = 24;

    private static HourlyScreen screen = null;

    private VerticalFieldManager hourlyFieldManager = new VerticalFieldManager();

    private HourlyFieldHolder[] hourlyFieldHolder = new HourlyFieldHolder[MAX_HOURLY_DAYS];

    private LabelField spacerField1 = null;

    //private LabelField spacerField2 = null;

    public static HourlyScreen getInstance() {

        if (screen == null)
            screen = new HourlyScreen();

        return screen;
    }

//#ifdef OS_COMPILE_ATLEAST_4_70
    protected FieldChangeListener button1Press = new FieldChangeListener() {
        public void fieldChanged(Field field, int context) {
            displayScreen(0); //Current
        }
    };
    protected FieldChangeListener button2Press = new FieldChangeListener() {
        public void fieldChanged(Field field, int context) {
            displayScreen(1); //Daily
        }
    };
//#endif

    private HourlyScreen() {
        super();

        setTitle("BBWeather Hourly Forecast");

        screenID = 2;

//#ifdef OS_COMPILE_ATLEAST_4_70
        button1.setLabel("Current");
        button2.setLabel("Daily");
        button1.setChangeListener(button1Press);
        button2.setChangeListener(button2Press);
//#endif

        //BBWeatherOptions options = BBWeatherOptions.load(false);
        //BBWeatherOptionsLocationData data = options.getLocationData(options.getCurrentLocationId());

        for (int i = 0; i < MAX_HOURLY_DAYS; i++) {
        //for (int i = 0; i < data.hourlyCount; i++) {
            hourlyFieldHolder[i] = getHourlyFieldHolder(i % 2 == 0);
        }
    }

    public void cleanup() {
        synchronized (UiApplication.getEventLock()) {
            if (managerRoot != null)
                removeManagerRoot();
            if (defaultFontLess4 != null)
                locationNameField.setFont(defaultFontLess4);
        }
    }

    public void updateData() {
        //System.out.println("*** Updating Hourly display data...");
        ForecastData hourlyData = null;

        BBWeatherOptions options = BBWeatherOptions.load(false);
        String locationId = options.getCurrentLocationId();
        if (locationId != null)
            hourlyData = WeatherDataManager.getInstance().getHourlyByLocationId(locationId);
        //System.out.println("*** locationId=" + locationId + " forcastData=" + hourlyData);

        if (hourlyData != null) {

            synchronized (UiApplication.getEventLock()) {

                if (!initFonts()) {
                    if (managerRoot != null)
                        removeManagerRoot();
                    locationNameField.setText("Severe Error getting fonts for: " + options.mainFont);
                    return;
                }

                if (managerRoot == null)
                    createManagerRoot(hourlyData);

                hideManagerRoot();

                locationNameField.setText(hourlyData.locationData.name);
                locationNameField.setFont(defaultFontBold);
                lastUpdateField.setText("Updated " + hourlyData.lastUpdate);
                lastUpdateField.setFont(defaultFontLess4);

                // Initialize the hourly day fields
                initHourlyManager(hourlyData);

                spacerField1.setFont(defaultFontLess4);
                if (attributionField != null) //2009-02-20
                    attributionField.setFont(defaultFontLess4);

                displayManagerRoot();
            }

        } else {
            synchronized (UiApplication.getEventLock()) {
                if (managerRoot != null)
                    removeManagerRoot();
                locationNameField.setText("Retrieving Weather, please wait...");
                if (defaultFont != null)
                    locationNameField.setFont(defaultFont);
            }
            WeatherThreadManager.getInstance().hourlyForceUpdate();
        }
    }

    /*protected void makeMenu(Menu menu, int instance) {
        super.makeMenu(menu, instance);

        MenuItem item = new MenuItem("Current Conditions", 800000000, 100) {

            public void run() {
                displayScreen(0);
            }
        };
        menu.add(item);
        item = new MenuItem("Forecast", 800000000, 100) {

            public void run() {
                displayScreen(1);
            }
        };
        menu.add(item);
        item = new MenuItem("Update Now", 900000000, 100) {

            public void run() {
                WeatherThreadManager.getInstance().hourlyForceUpdate();
            }
        };
        menu.add(item);
    }*/

    //reorganize function and add shortcut to open hourly screen
    protected boolean keyDown(int keycode, int time) {
        if (!isProcessingKey) {
            int iStatus = Keypad.status(keycode);
            char keyChar = Keypad.map(keycode);

            switch (keyChar) {
                case Characters.SPACE:
                    isProcessingKey = true;
                    if (iStatus == 1) {
                        WeatherThreadManager.getInstance().hourlyForceUpdate();
                    /*} else if (iStatus == 34) { //34 = left_shift, 66 = right shift STATUS_SHIFT Keypad.KEY_SHIFT_LEFT
                        displayForecastScreenQuick();*/
                    } else {
                        displayScreen(0);
                    }
                    isProcessingKey = false;
                    return true;
                case Characters.DIGIT_NINE:
                    isProcessingKey = true;
                    if (iStatus == 1) {
                        displayScreen(0);
                    }/* else {
                    }*/
                    isProcessingKey = false;
                    return true;
                case Characters.DIGIT_SIX:
                    isProcessingKey = true;
                    if (iStatus == 1) {
                        displayScreen(1);
                    }/* else {
                    }*/
                    isProcessingKey = false;
                    return true;
                default:
                    break;
            }
        }

        return super.keyDown(keycode, time);
    }

    /*private void displayCurrentConditionsScreen() {
        UiApplication.getUiApplication().invokeLater(new Runnable() {

            public void run() {
                UiApplication.getUiApplication().popScreen(HourlyScreen.this);
                UiApplication.getUiApplication().pushScreen(CurrentConditionsScreen.getInstance());
                isProcessingKey = false;
            }
        });
    }

    private void displayForecastScreen() {
        UiApplication.getUiApplication().invokeLater(new Runnable() {

            public void run() {
                UiApplication.getUiApplication().popScreen(HourlyScreen.this);
                UiApplication.getUiApplication().pushScreen(ForecastScreen.getInstance());
                isProcessingKey = false;
            }
        });
    }*/

    private void createManagerRoot(ForecastData hourlyData) {

        managerRoot = new VerticalFieldManager(VerticalFieldManager.VERTICAL_SCROLL
            | VerticalFieldManager.VERTICAL_SCROLLBAR | VerticalFieldManager.HORIZONTAL_SCROLL); //added Manager.HORIZONTAL_SCROLL to fix a bug with the Storm that allowed horizontal scroll past edge of page

        lastUpdateField = new LabelField(null, Field.NON_FOCUSABLE); // Field.FOCUSABLE
        managerRoot.add(lastUpdateField);
        // Just used for spacing
        spacerField1 = new LabelField(" ");
        managerRoot.add(spacerField1);

        // The manager that dynamically handles part info
        managerRoot.add(hourlyFieldManager);

        // Just used for spacing
        //spacerField2 = new LabelField(" ");
        //managerRoot.add(spacerField2);

        managerRoot.add(new LabelField(" ")); //2009-02-20

        managerRoot.add(getAttributionInfo());
    }

    private HourlyFieldHolder getHourlyFieldHolder(boolean changeBG) {
        BBWeatherOptions options = BBWeatherOptions.load(false);

        HourlyFieldHolder holder = new HourlyFieldHolder();

        final int hourlyScreenType = options.hourlyScreenType;

        if (changeBG) {
            holder.manager = new HorizontalFieldManager(Field.FIELD_LEFT | Field.FIELD_TOP) { //FlowFieldManager
                protected void sublayout(int width, int height)  {
                    //int newHeight = defaultFontLess4Bold.getHeight() * 2;
                    int newHeight;
                    if (hourlyScreenType == 2) {
                        newHeight = defaultFontLess4Bold.getHeight() * 3;
                    } else if (hourlyScreenType == 1) {
                        newHeight = defaultFontLess4Bold.getHeight() * 2;
                    } else {
                        newHeight = defaultFontLess4Bold.getHeight();
                    }

                    newHeight += 2;

                    if (hourlyScreenType > 0) {
                        if (newHeight < 36)
                            newHeight = 36;
                    }
                    super.sublayout(Display.getWidth(), newHeight);
                    setExtent(Display.getWidth(), newHeight);
                }

                public void paint(Graphics graphics) {
                    // Sets the BackgroundColor
                    graphics.setBackgroundColor(0x00ECECEC);
                    // Clears the entire graphic area to the current background
                    graphics.clear();
                    super.paint(graphics);
                }
            };

            holder.headerField = new ColorLabelField(null, Field.FIELD_RIGHT | Field.FOCUSABLE) {
                protected void layout(int width, int height)  {
                    super.layout(width, height);
                    setExtent(defaultFontLess4Bold.getAdvance("12pm") + 4, defaultFontLess4Bold.getHeight()); //36
                }

                protected void onUnfocus() {
                    invalidate();
                }

                public void paint(Graphics graphics) {
                    if (!isFocus()) {
                        // Sets the BackgroundColor
                        graphics.setBackgroundColor(0x00ECECEC); //0x00F0F0F0
                        // Clears the entire graphic area to the current background
                        graphics.clear();
                    }

                    super.paint(graphics);
                }
            };
        } else {
            holder.manager = new HorizontalFieldManager(Field.FIELD_LEFT | Field.FIELD_TOP) {
                protected void sublayout(int width, int height)  {
                    //int newHeight = defaultFontLess4Bold.getHeight() * 2;
                    int newHeight;
                    if (hourlyScreenType == 2) {
                        newHeight = defaultFontLess4Bold.getHeight() * 3;
                    } else if (hourlyScreenType == 1) {
                        newHeight = defaultFontLess4Bold.getHeight() * 2;
                    } else {
                        newHeight = defaultFontLess4Bold.getHeight();
                    }

                    newHeight += 2;

                    if (hourlyScreenType > 0) {
                        if (newHeight < 36)
                            newHeight = 36;
                    }
                    super.sublayout(Display.getWidth(), newHeight);
                    setExtent(Display.getWidth(), newHeight);
                }
            }; //HorizontalFieldManager

            holder.headerField = new ColorLabelField(null, Field.FIELD_RIGHT | Field.FOCUSABLE) {
                protected void layout(int width, int height)  {
                    super.layout(width, height);
                    setExtent(defaultFontLess4Bold.getAdvance("12pm") + 4, defaultFontLess4Bold.getHeight()); //36
                }
            };
        }

        if (options.hourlyScreenType == 1 || options.hourlyScreenType == 2) {
            holder.temperatureField = new LabelField(null, Field.FIELD_RIGHT | Field.NON_FOCUSABLE);
            holder.descriptionField = new LabelField(null, Field.FIELD_LEFT | Field.NON_FOCUSABLE | Field.FIELD_TOP);
            holder.humidityField = new LabelField(null, Field.FIELD_RIGHT | Field.NON_FOCUSABLE);
            holder.precipField = new LabelField(null, Field.FIELD_RIGHT | Field.NON_FOCUSABLE);
            holder.windField = new LabelField(null, Field.FIELD_LEFT | Field.NON_FOCUSABLE);
            holder.bitmapField = new BitmapField(null, Field.FIELD_HCENTER);

            holder.dateField = new LabelField(null, Field.FIELD_LEFT | Field.NON_FOCUSABLE);
            VerticalFieldManager headerMgr = new VerticalFieldManager();
            headerMgr.add(holder.headerField);
            headerMgr.add(holder.dateField);

            holder.manager.add(headerMgr);
            //holder.manager.add(holder.headerField);

            holder.manager.add(holder.bitmapField);
            holder.manager.add(new LabelField(" "));

            VerticalFieldManager lineManager = new VerticalFieldManager(Field.FIELD_LEFT | Field.FIELD_VCENTER);
            HorizontalFieldManager lineOne = new HorizontalFieldManager(Field.FIELD_LEFT | Field.FIELD_VCENTER);
            HorizontalFieldManager lineTwo = new HorizontalFieldManager(Field.FIELD_LEFT | Field.FIELD_VCENTER);

            if (options.hourlyScreenType == 1) {
                lineOne.add(holder.temperatureField);
                lineOne.add(holder.windField);
                lineOne.add(holder.precipField);

                lineTwo.add(holder.descriptionField);
                lineTwo.add(holder.humidityField);

                lineManager.add(lineOne);
                lineManager.add(lineTwo);
            } else {
                HorizontalFieldManager lineThree = new HorizontalFieldManager(Field.FIELD_LEFT | Field.FIELD_VCENTER);

                lineOne.add(holder.temperatureField);
                lineOne.add(holder.windField);

                lineTwo.add(holder.descriptionField);

                lineThree.add(holder.humidityField);
                lineThree.add(holder.precipField);

                lineManager.add(lineOne);
                lineManager.add(lineTwo);
                lineManager.add(lineThree);
            }

            holder.manager.add(lineManager);
        } else {
            //Not used in mode = 0 or 1, but needs to be there anwyay
            // in case Hourly screen is already displayed in mode 0 or 1 and user goes to options and switches to mode = 2
            holder.bitmapField = new BitmapField(null, Field.FIELD_HCENTER);

            holder.dateField = new LabelField(null, Field.FIELD_LEFT | Field.NON_FOCUSABLE);

            holder.temperatureField = new LabelField(null, Field.FIELD_RIGHT | Field.NON_FOCUSABLE) {
                protected void layout(int width, int height)  {
                    super.layout(width, height);
                    setExtent(defaultFontLess4.getAdvance("105F/105F") + 4, defaultFontLess4Bold.getHeight()); //50
                }
            };
            holder.descriptionField = new LabelField(null, Field.FIELD_LEFT | Field.NON_FOCUSABLE | Field.FIELD_TOP) {
                protected void layout(int width, int height)  {
                    super.layout(width, height);
                    setExtent(defaultFontLess4.getAdvance("Mostly Sunny") + 4, defaultFontLess4Bold.getHeight()); //100
                }
            };
            holder.humidityField = new LabelField(null, Field.FIELD_RIGHT | Field.NON_FOCUSABLE) {
                protected void layout(int width, int height)  {
                    super.layout(width, height);
                    setExtent(defaultFontLess4.getAdvance("100%") + 4, defaultFontLess4Bold.getHeight()); //30
                }
            };
            holder.precipField = new LabelField(null, Field.FIELD_RIGHT | Field.NON_FOCUSABLE) {
                protected void layout(int width, int height)  {
                    super.layout(width, height);
                    setExtent(defaultFontLess4.getAdvance("100%") + 4, defaultFontLess4Bold.getHeight()); // 30
                }
            };
            holder.windField = new LabelField(null, Field.FIELD_LEFT | Field.NON_FOCUSABLE) {
                protected void layout(int width, int height)  {
                    super.layout(width, height);
                    setExtent(defaultFontLess4.getAdvance("WSW at 100mph") + 4, defaultFontLess4Bold.getHeight()); //80
                }
            };

            //spacerField.setFont(defaultFontLess4);

            holder.manager.add(holder.headerField);
                //holder.manager.add(new LabelField(" -- "));

            holder.manager.add(holder.temperatureField);
                //holder.manager.add(new LabelField(" "));
            holder.manager.add(holder.descriptionField);
                //holder.manager.add(new LabelField(" "));
            holder.manager.add(holder.humidityField);
                //holder.manager.add(new LabelField(" "));
            holder.manager.add(holder.precipField);
                //holder.manager.add(new LabelField(" "));
            holder.manager.add(holder.windField);
        }

        return holder;
    }

    private void initHourlyManager(ForecastData hourlyData) {

        // Remove previous entries
        if (hourlyFieldManager.getFieldCount() > 0)
            ((Manager) hourlyFieldManager.getField(0)).deleteAll();
        hourlyFieldManager.deleteAll();

        BBWeatherOptions options = BBWeatherOptions.load(false);

        // Create new entries
        VerticalFieldManager manager = new VerticalFieldManager();

        for (int i = 0; i < hourlyData.numberDays; i++) {
            HourlyFieldHolder holder = hourlyFieldHolder[i];

            manager.add(holder.manager);

            holder.headerField.setText(hourlyData.dayData[i].dayName); // the hour
            holder.headerField.setFont(defaultFontLess4Bold);
            if (i % 2 == 0)
                holder.headerField.setColor(options.highTempColor);
            else
                holder.headerField.setColor(options.lowTempColor);

            if (options.hourlyScreenType > 0) {
                holder.dateField.setText(hourlyData.dayData[i].date); // the date
                holder.dateField.setFont(defaultFontLess4);
            }

            if (options.hourlyScreenType == 1 || options.hourlyScreenType == 2) {
                holder.bitmapField.setBitmap(hourlyData.dayData[i].dayPartData.bitmap);

                holder.temperatureField.setText(hourlyData.dayData[i].hiTemp
                        + hourlyData.unitData.temperature + "/" +
                        hourlyData.dayData[i].lowTemp
                        + hourlyData.unitData.temperature + ", "); // temp and fells like temp

                WindData windData = hourlyData.dayData[i].dayPartData.windData;

                if (options.hourlyScreenType == 1) {
                    holder.descriptionField.setText(hourlyData.dayData[i].dayPartData.description + ", "); //stackString(hourlyData.dayData[i].dayPartData.description)
                    holder.humidityField.setText("Hum: " + hourlyData.dayData[i].dayPartData.humidity + "%");

                    if (windData.speed.equalsIgnoreCase("calm")) {
                        holder.windField.setText(windData.description + ", ");
                    } else {
                        holder.windField.setText(windData.description + " at " + windData.speed + hourlyData.unitData.speed + ", ");
                    }
                } else {
                    holder.descriptionField.setText(hourlyData.dayData[i].dayPartData.description);
                    holder.humidityField.setText("Hum: " + hourlyData.dayData[i].dayPartData.humidity + "%, ");

                    if (windData.speed.equalsIgnoreCase("calm")) {
                        holder.windField.setText(windData.description);
                    } else {
                        holder.windField.setText(windData.description + " at " + windData.speed + hourlyData.unitData.speed);
                    }
                }

                holder.precipField.setText("Precip: " + hourlyData.dayData[i].dayPartData.precipitation + "%");

                holder.temperatureField.setFont(defaultFontLess4);
                holder.descriptionField.setFont(defaultFontLess4);
                holder.humidityField.setFont(defaultFontLess4);
                holder.precipField.setFont(defaultFontLess4);
                holder.windField.setFont(defaultFontLess4);
            } else {
                holder.descriptionField.setText(hourlyData.dayData[i].dayPartData.description); //stackString(hourlyData.dayData[i].dayPartData.description)
                holder.descriptionField.setFont(defaultFontLess4);

                holder.temperatureField.setText(hourlyData.dayData[i].hiTemp
                        + hourlyData.unitData.temperature + "/" +
                        hourlyData.dayData[i].lowTemp
                        + hourlyData.unitData.temperature); // temp and fells like temp
                holder.temperatureField.setFont(defaultFontLess4);

                //2009-02-20
                holder.humidityField.setText(hourlyData.dayData[i].dayPartData.humidity + "%");
                holder.humidityField.setFont(defaultFontLess4);

                holder.precipField.setText(hourlyData.dayData[i].dayPartData.precipitation + "%");
                holder.precipField.setFont(defaultFontLess4);

                //holder.windLabelField.setFont(defaultFontLess4Bold);
                WindData windData = hourlyData.dayData[i].dayPartData.windData;
                if (windData.speed.equalsIgnoreCase("calm")) {
                    holder.windField.setText(windData.description);
                } else {
                    holder.windField.setText(windData.description + " at " + windData.speed + hourlyData.unitData.speed);
                }

                holder.windField.setFont(defaultFontLess4);
            }
        }

        hourlyFieldManager.add(manager);
    }


    private static class HourlyFieldHolder {
        //2009-02-20 public LabelField headerField = null;
        public Manager manager = null;
        public LabelField descriptionField = null;
        public LabelField temperatureField = null;
        public LabelField humidityField = null;
        public LabelField precipField = null;
        public LabelField windField = null;

        //2009-02-20
        public ColorLabelField headerField = null;
        public BitmapField bitmapField = null;

        public LabelField dateField = null;
    }
}
