/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbweather.utils;

import java.io.InputStream;

import net.rim.device.api.system.Bitmap;

/*
 * 
 * @author Chris Miles
 *  
 */
public class IconUtils {

    // 64K max size for bitmap
    protected static int MAX_BITMAP_SIZE = 65536;

    private static IconUtils util = new IconUtils();

    public static Bitmap getBitmap(String path) {

        Bitmap bitmap = null;
        try {
            //System.out.println("Load bitmap " + path);
            InputStream in = util.getClass().getResourceAsStream(path);
            byte[] data = new byte[MAX_BITMAP_SIZE];
            in.read(data);
            bitmap = Bitmap.createBitmapFromPNG(data, 0, data.length);
            in.close();
        } catch (Exception e) {
            //System.out.println("*** Exception in getBitmap: " + e.getMessage());
        }

        return bitmap;
    }
}
