/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbweather;

import net.rim.device.api.system.ApplicationManager;
import net.rim.device.api.ui.UiApplication;

import net.rim.device.api.system.ApplicationDescriptor;

/**
 * @author Chris Miles
 *
 */
public class BBWeather extends UiApplication {

    private static boolean cancelHomescreenMode = false;
    private static boolean homescreenModeAndNotStartup = false;

    private BBWeather(String[] args) {
        BBWeatherOptions options = BBWeatherOptions.load(false);
        String locationId = options.getCurrentLocationId();

        if (ApplicationManager.getApplicationManager().inStartup()) {
            if (options.activeOnStartup && options.enableHomeScreen && (options.homeScreenIcon != 0 || options.homeScreenRollover != 0) && locationId != null) {
                //homescreenThread _homescreenThread = BBWeatherThreadManager.getHomeScreenThread();
                //_homescreenThread.start();

                // Set this here, so if someone manually starts the app while homescreen mode is running, the doExit mode will be set to false
                cancelHomescreenMode = true;
                homescreenModeAndNotStartup = false;
                WeatherThreadManager.getInstance().setExit(true);
                WeatherThreadManager.getInstance().setIsStartup(true);
                WeatherThreadManager.getInstance().start();
            } else {
                options.cancelExit = false; options.save(); //always make sure options.CancelExit = false
                System.exit(0);
            }
        } else {
            if (args.length > 0) {
                if (args[0] == "homeScreen") {
                    if (locationId != null) {
                        cancelHomescreenMode = true;
                        homescreenModeAndNotStartup = true;
                        WeatherThreadManager.getInstance().setExit(true);
                        WeatherThreadManager.getInstance().start();
                    }
                    else {
                        options.cancelExit = false; //always make sure options.CancelExit = false
                        options.save();
                        System.exit(0);
                    }
                }
            } else {
                // app was manually started by user so remove any scheduled homescreen updates
                //cancelHomescreenMode = true;
                //BBWeatherThreadManager.setExit(false);
                homescreenModeAndNotStartup = false;

                ApplicationDescriptor template = ApplicationDescriptor.currentApplicationDescriptor();
                String[] newArgs = {"homeScreen"};
                ApplicationDescriptor newdescriptor = new ApplicationDescriptor(template, newArgs);

                ApplicationManager.getApplicationManager().scheduleApplication(newdescriptor, -1, true);

                // Start the current conditions and forecast threads and the current conditions screen
                WeatherThreadManager.getInstance().start();
                
                // Used so that if no profiles are created, it only opens the Add Location screen on first open
                WeatherThreadManager.getInstance().setFirstOpen(true);
                
                if (options.defaultScreen == 0) {
                    pushScreen(CurrentConditionsScreen.getInstance());
                } else if (options.defaultScreen == 1) {
                    pushScreen(ForecastScreen.getInstance());
                } else {
                    pushScreen(HourlyScreen.getInstance());
                }
            }
        }
    }

    public void activate() {
        //added !bHomeScreenStart to keep the gui from opening when updating in homescreen mode
        if (homescreenModeAndNotStartup) {
            this.getApplication().requestBackground();
            homescreenModeAndNotStartup = false; //Set this to false now, so if user requests bbweather while homescreenupdate is running, it will load the gui
            return;
        }

        BBWeatherOptions options = BBWeatherOptions.load(true);
        if (cancelHomescreenMode) {
            // If options.cancelExit == true, then do not need to set this
            if (!options.cancelExit)
                WeatherThreadManager.getInstance().setExit(false);
        }

        super.activate();

        if (!CurrentConditionsScreen.getInstance().isDisplayed() && !ForecastScreen.getInstance().isDisplayed() && !HourlyScreen.getInstance().isDisplayed()) {
        if (options.defaultScreen == 0) {
                pushScreen(CurrentConditionsScreen.getInstance());
            } else if (options.defaultScreen == 1) {
                pushScreen(ForecastScreen.getInstance());
            } else {
                pushScreen(HourlyScreen.getInstance());
            }
        }
    }

    public static void main(String[] args) {
        try {
            // Check to make sure the app is not already running
            ApplicationDescriptor descriptor = ApplicationDescriptor.currentApplicationDescriptor();
            //String currentApplicationName = descriptor.getName();
            String currentModuleName = descriptor.getModuleName();

            ApplicationManager manager = ApplicationManager.getApplicationManager();
            ApplicationDescriptor descriptors[] = manager.getVisibleApplications();

            for (int i = 0; i < descriptors.length; i++) {
                //String appName = descriptors[i].getName();
                //if (currentApplicationName.equals(descriptors[i].getName()))
                if (currentModuleName.equals(descriptors[i].getModuleName())) {
                    BBWeatherOptions options = BBWeatherOptions.load(false);
                    options.cancelExit = true;
                    options.save();
                    // Get the already running app, make sure the current conditions thread, forecast thread and the current conditions screen are running
                    // cancel the homescreen thread
                    manager.requestForeground(manager.getProcessId(descriptors[i]));
                    //manager.runApplication(descriptors[i], true);
                    return;
                }
            }
        } catch (Exception e) {
            System.out.println("BBWeather main() Error: " + e.toString());
        }

        BBWeather bbweather = new BBWeather(args);
        bbweather.enterEventDispatcher();
    }
}
