/***************************************************************
 * Name:      OTFBrutusMain.cpp
 * Author:    Josh Harris (tateu@tateu.net)
 * Created:   2010-12-01
 * Copyright: Josh Harris (www.tateu.net)
 * License:
 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation and/or
     other materials provided with the distribution.
  3. The name of the author may not be used to endorse or promote products derived
     from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **************************************************************/

#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif

#ifdef __BORLANDC__
#pragma hdrstop
#endif //__BORLANDC__

#include <process.h>
#include <vector>
#include <string>
#include <algorithm>

#include "version.h"
#include "OTFBrutus.h"
#include "OTFBrutusMain.h"
#include "DragDrop.h"
#include "KeyFilesDlg.h"
#include "DevicesDlg.h"

using namespace std;

extern char *OTFFile;
extern bool isRunning;

extern vector<int> user_cipher, user_hash, user_mode;
extern vector<string> keyFiles;
extern bool useKeyFiles;
extern int externalPKCS;

extern string found_pwd;
//INT64 actual_pwds_tried = 0;

extern INT64 idxStart;
extern INT64 idxEnd;

//DWORD dwEvent = 0;
extern int iVolType;
extern BOOL bSuccess;
extern char *pwd_pattern, *dictionary;
//size_t pwd_pattern_len = 0;
//INT64 pwd_count = 0, pwd_count_dict = 0, print_count = 0;
//INT64 pwd_idx = 0, pwd_idx_dict = 0;
//INT64 counter = 0;

//string pwd;
//vector<PWD_PARTS> m_vpwdParts;
//PWD_PARTS pwdParts;
//CHAR_SET charSet;

//DWORD size_MB;

//BOOL bVerbose = FALSE;
extern BOOL bSaveWordList;
extern BOOL bOverwrite;
extern wxString wordListFile;
extern BOOL bComplete;
extern int threads;

extern HANDLE hRunEvent;
extern HANDLE hRunThread;

extern wxString err, logString, status;

HWND hwndMain;

//helper functions
enum wxbuildinfoformat {
    short_f, long_f };

wxString wxbuildinfo(wxbuildinfoformat format)
{
    wxString wxbuild(wxVERSION_STRING);

    if (format == long_f )
    {
#if defined(__WXMSW__)
        wxbuild << _T("-Windows");
#elif defined(__WXMAC__)
        wxbuild << _T("-Mac");
#elif defined(__UNIX__)
        wxbuild << _T("-Linux");
#endif

#if wxUSE_UNICODE
        wxbuild << _T("-Unicode build");
#else
        wxbuild << _T("-ANSI build");
#endif // wxUSE_UNICODE
    }

    return wxbuild;
}

OTFBrutusFrame::OTFBrutusFrame(wxWindow* parent)
    : GUIFrame(parent)
{
#if wxUSE_STATUSBAR
    //statusBar->SetStatusText(_(""), 0);
    //statusBar->SetStatusText(wxbuildinfo(short_f), 1);
#endif
}

WXLRESULT OTFBrutusFrame::MSWWindowProc(WXUINT nMsg, WXWPARAM wParam, WXLPARAM lParam)
{
	wxString s;

	switch (nMsg) {
		case OTF_ERROR:
			isRunning = false;
			wxMessageBox(err);

			runBtn->Disable();
			WaitForSingleObject(hRunEvent, 1000);
			runBtn->SetLabel(wxT("Start"));
			genWordListBtn->SetLabel(wxT("Save Word List"));
			genWordListBtn->Enable(true);
			statusBar->SetStatusText(wxT(""));
			menuFile->Enable(idMenuLoad, true);

			if (OTFFile) {
				delete OTFFile;
				OTFFile = NULL;
			}
			if (pwd_pattern) {
				delete pwd_pattern;
				pwd_pattern = NULL;
			}
			if (dictionary) {
				delete dictionary;
				dictionary = NULL;
			}

			if (hRunEvent) {
				CloseHandle(hRunEvent);
				hRunEvent = NULL;
			}
			//if (hRunThread) {
			//	CloseHandle(hRunThread);
			//	hRunThread = NULL;
			//}

			SetCursor(wxCURSOR_DEFAULT);
			runBtn->Enable();
			break;
		case OTF_LOG:
			//s = statusCtrl->GetValue();
			//s.append(logString);
			//statusCtrl->SetValue(s);
			statusCtrl->AppendText(logString);

			if (bComplete) {
				isRunning = false;
				runBtn->Disable();
				WaitForSingleObject(hRunEvent, 1000);
				runBtn->SetLabel(wxT("Start"));
				genWordListBtn->SetLabel(wxT("Save Word List"));
				genWordListBtn->Enable(true);
				statusBar->SetStatusText(wxT(""));
				menuFile->Enable(idMenuLoad, true);
				
				if (OTFFile) {
					delete OTFFile;
					OTFFile = NULL;
				}
				if (pwd_pattern) {
					delete pwd_pattern;
					pwd_pattern = NULL;
				}
				if (dictionary) {
					delete dictionary;
					dictionary = NULL;
				}

				if (hRunEvent) {
					CloseHandle(hRunEvent);
					hRunEvent = NULL;
				}
				//if (hRunThread) {
				//	CloseHandle(hRunThread);
				//	hRunThread = NULL;
				//}

				SetCursor(wxCURSOR_DEFAULT);
				runBtn->Enable();				
			}
			break;
		case OTF_STATUS:
			statusBar->SetStatusText(status);
			break;
		default:
			break;
	}

	return wxFrame::MSWWindowProc(nMsg, wParam, lParam);
}

bool OTFBrutusFrame::init()
{
	SYSTEM_INFO sysinfo;
	GetSystemInfo(&sysinfo);

    //this->SetDropTarget(new DndDialog(this));
    fileNameCtrl->SetDropTarget(new DndDialog(fileNameCtrl));
    passwordCtrl->SetDropTarget(new DndDialog(passwordCtrl));
	passwordCtrl->SetToolTip( wxT("Precomputed word list (This is a plaintext file with one password per line)"));

	/*passwordCtrl->GetToolTip()->SetDelay(100);
	passwordCtrl->GetToolTip()->SetReshow(2500);
	passwordCtrl->GetToolTip()->SetAutoPop(20000);*/

	if (sysinfo.dwNumberOfProcessors <= MAX_THREADS) {
		comboThreads->SetSelection(sysinfo.dwNumberOfProcessors - 1);
	} else {
		comboThreads->SetSelection(MAX_THREADS - 1);
	}

	isRunning = false;
	hwndMain = (HWND)this->GetHandle();

	sysFixedFont = wxSystemSettings::GetFont(wxSYS_ANSI_FIXED_FONT);
	statusCtrl->SetFont(sysFixedFont);
	statusBar->SetFont(sysFixedFont);

	wxToolTip *t = passwordCtrl->GetToolTip();
	if (t) {
		HANDLE hwnd = t->GetWindow()->GetHWND();//passwordCtrl->GetHWND();
		::SendMessage((HWND)hwnd, WM_USER + 3, 1, 10);
		::SendMessage((HWND)hwnd, WM_USER + 3, 2, 50000);
		::SendMessage((HWND)hwnd, WM_USER + 3, 3, 10);
	}

	LoadSettings();

	return true;
}

OTFBrutusFrame::~OTFBrutusFrame()
{
}

void OTFBrutusFrame::OnClose(wxCloseEvent &event)
{
    Destroy();
}

void OTFBrutusFrame::OnQuit(wxCommandEvent &event)
{
    Destroy();
}

void OTFBrutusFrame::OnLoad(wxCommandEvent &event)
{
    LoadSettings();
}

void OTFBrutusFrame::LoadSettings()
{
	wxString iniStr;
	long iniVal;
    wxIniConfig *config = new wxIniConfig(wxT("OTFBrutusGUI"), wxT(""), wxT("./OTFBrutusGUI.ini"), wxT(""), wxCONFIG_USE_LOCAL_FILE | wxCONFIG_USE_RELATIVE_PATH); //wxIniConfig
    config->SetPath("GUI");

	//if (config->Read("PasswordMethod", &strIni)) {}
	config->Read("PasswordMethod", &iniVal, 0)          ; dictionarySelect->Select(iniVal);
	genWordListBtn->Enable(iniVal)                      ; openDictBtn->Enable(!iniVal);

	config->Read("HashSelect", &iniVal, 0)              ; hashVSelect->Select(iniVal);
	config->Read("HashRipeMD160", &iniVal, 1)           ; checkRipeMD->SetValue(iniVal);
	config->Read("HashSHA512", &iniVal, 1)              ; checkSHA512->SetValue(iniVal);
	config->Read("HashWhirlpool", &iniVal, 1)           ; checkWhirlpool->SetValue(iniVal);
	config->Read("HashSHA1", &iniVal, 0)                ; checkSHA1->SetValue(iniVal);

	config->Read("HashRipeMD160Mode", &iniVal, 1)       ; menuHashRMD->Check(idMenuHashTC1, iniVal)       ; menuHashRMD->Check(idMenuHashCC1, !iniVal);
	config->Read("HashSHA512Mode", &iniVal, 1)          ; menuHashSHA512->Check(idMenuHashTC2, iniVal)    ; menuHashSHA512->Check(idMenuHashCC2, !iniVal);
	config->Read("HashWhirlpoolMode", &iniVal, 1)       ; menuHashWhirlpool->Check(idMenuHashTC3, iniVal) ; menuHashWhirlpool->Check(idMenuHashCC3, !iniVal);
	config->Read("HashSHA1Mode", &iniVal, 1)            ; menuHashSHA1->Check(idMenuHashTC4, iniVal)      ; menuHashSHA1->Check(idMenuHashCC4, !iniVal);

	config->Read("ModeSelect", &iniVal, 0)              ; modeVSelect->Select(iniVal);
	config->Read("ModeXTS", &iniVal, 1)                 ; checkXTS->SetValue(iniVal);
	config->Read("ModeLRW", &iniVal, 0)                 ; checkLRW->SetValue(iniVal);
	config->Read("ModeCBC", &iniVal, 0)                 ; checkCBC->SetValue(iniVal);

	config->Read("EncryptionSelect", &iniVal, 0)        ; encVSelect->Select(iniVal);
	config->Read("EncAES", &iniVal, 1)                  ; checkAES->SetValue(iniVal);
	config->Read("EncSerpent", &iniVal, 1)              ; checkSerpent->SetValue(iniVal);
	config->Read("EncTwofish", &iniVal, 1)              ; checkTwofish->SetValue(iniVal);
	config->Read("EncAES_Twofish", &iniVal, 1)          ; checkAES_Twofish->SetValue(iniVal);
	config->Read("EncAES_Twofish_Serpent", &iniVal, 1)  ; checkAES_Twofish_Serpent->SetValue(iniVal);
	config->Read("EncSerpent_AES", &iniVal, 1)          ; checkSerpent_AES->SetValue(iniVal);
	config->Read("EncSerpent_Twofish_AES", &iniVal, 1)  ; checkSerpent_Twofish_AES->SetValue(iniVal);
	config->Read("EncTwofish_Serpent", &iniVal, 1)      ; checkTwofish_Serpent->SetValue(iniVal);
	config->Read("EncBlowfish", &iniVal, 0)             ; checkBlowfish->SetValue(iniVal);
	config->Read("EncCast5", &iniVal, 0)                ; checkCast5->SetValue(iniVal);
	config->Read("EncDES3", &iniVal, 0)                 ; checkDES3->SetValue(iniVal);
	config->Read("EncAES_Blowfish", &iniVal, 0)         ; checkAES_Blowfish->SetValue(iniVal);
	config->Read("EncAES_Blowfish_Serpent", &iniVal, 0) ; checkAES_Blowfish_Serpent->SetValue(iniVal);
	config->Read("EncIDEA", &iniVal, 0)                 ; checkIDEA->SetValue(iniVal);

	config->Read("VolumeType", &iniVal, 0)              ; volumeTypeSelect->Select(iniVal);

	delete config;
}

void OTFBrutusFrame::OnSave(wxCommandEvent &event)
{
    wxIniConfig *config = new wxIniConfig(wxT("OTFBrutusGUI"), wxT(""), wxT("./OTFBrutusGUI.ini"), wxT(""), wxCONFIG_USE_LOCAL_FILE | wxCONFIG_USE_RELATIVE_PATH); //wxIniConfig
    config->SetPath("GUI");

	config->Write("PasswordMethod", dictionarySelect->GetSelection());

	config->Write("HashSelect", hashVSelect->GetSelection());
	config->Write("HashRipeMD160", checkRipeMD->GetValue());
	config->Write("HashSHA512", checkSHA512->GetValue());
	config->Write("HashWhirlpool", checkWhirlpool->GetValue());
	config->Write("HashSHA1", checkSHA1->GetValue());

	config->Write("HashRipeMD160Mode", menuHashRMD->IsChecked(idMenuHashTC1));
	config->Write("HashSHA512Mode", menuHashSHA512->IsChecked(idMenuHashTC2));
	config->Write("HashWhirlpoolMode", menuHashWhirlpool->IsChecked(idMenuHashTC3));
	config->Write("HashSHA1Mode", menuHashSHA1->IsChecked(idMenuHashTC4));

	config->Write("ModeSelect", modeVSelect->GetSelection());
	config->Write("ModeXTS", checkXTS->GetValue());
	config->Write("ModeLRW", checkLRW->GetValue());
	config->Write("ModeCBC", checkCBC->GetValue());

	config->Write("EncryptionSelect", encVSelect->GetSelection());
	config->Write("EncAES", checkAES->GetValue());
	config->Write("EncSerpent", checkSerpent->GetValue());
	config->Write("EncTwofish", checkTwofish->GetValue());
	config->Write("EncAES_Twofish", checkAES_Twofish->GetValue());
	config->Write("EncAES_Twofish_Serpent", checkAES_Twofish_Serpent->GetValue());
	config->Write("EncSerpent_AES", checkSerpent_AES->GetValue());
	config->Write("EncSerpent_Twofish_AES", checkSerpent_Twofish_AES->GetValue());
	config->Write("EncTwofish_Serpent", checkTwofish_Serpent->GetValue());
	config->Write("EncBlowfish", checkBlowfish->GetValue());
	config->Write("EncCast5", checkCast5->GetValue());
	config->Write("EncDES3", checkDES3->GetValue());
	config->Write("EncAES_Blowfish", checkAES_Blowfish->GetValue());
	config->Write("EncAES_Blowfish_Serpent", checkAES_Blowfish_Serpent->GetValue());
	config->Write("EncIDEA", checkIDEA->GetValue());

	config->Write("VolumeType", volumeTypeSelect->GetSelection());

	delete config;
}

void OTFBrutusFrame::OnAbout(wxCommandEvent &event)
{
	wxDialog *dlg;

	dlg = new wxDialog(this, wxID_ANY, wxT("OTFBrutusGUI"), wxDefaultPosition,
					   wxDefaultSize, wxCAPTION | wxSYSTEM_MENU | wxCLOSE_BOX | wxOK | wxCENTRE);

	dlg->SetIcon(wxICON(aaaa));

	wxHyperlinkCtrl *m_hyperlink = new wxHyperlinkCtrl(dlg, NULL, wxT("http://www.tateu.net"), wxT("http://www.tateu.net"));
	wxHyperlinkCtrl *m_hyperlink2 = new wxHyperlinkCtrl(dlg, NULL, wxT("http://www.truecrypt.org"), wxT("http://www.truecrypt.org"));

	wxBoxSizer *topsizer = new wxBoxSizer(wxVERTICAL);
	wxBoxSizer *sizer1 = new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer *sizer2 = new wxBoxSizer(wxVERTICAL);
	wxSizer *buttonSizer = dlg->CreateButtonSizer(wxOK);

	wxSizerFlags flagsBorder2;
	flagsBorder2.DoubleBorder();

	wxStaticBitmap *icon = new wxStaticBitmap(dlg, wxID_ANY, wxICON(aaaa));

	sizer1->Add(icon, 0, wxTOP | wxLEFT | wxRIGHT | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);
	sizer1->Add(dlg->CreateTextSizer(wxString::Format(wxT("OTFBrutusGUI v%s"), __FILEVERSION__)),
		0, wxTOP | wxLEFT | wxRIGHT | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);

	sizer2->Add(dlg->CreateTextSizer(wxT("2012 Josh Harris")), 0, wxTOP | wxLEFT | wxRIGHT | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);
	sizer2->Add(m_hyperlink, 0, wxTOP | wxLEFT | wxRIGHT | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);

	sizer2->AddSpacer(30);
    wxStaticText *st = new wxStaticText( dlg, wxID_ANY, wxT("Portions Based on TrueCrypt, freely available at"), wxDefaultPosition, wxDefaultSize, 0 );
	st->Wrap(-1);
    wxFont font = st->GetFont();
    font.SetPointSize(font.GetPointSize() - 1);
	st->SetFont(font);
	sizer2->Add(st, 0, wxTOP | wxLEFT | wxRIGHT | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);
    font = m_hyperlink2->GetFont();
    font.SetPointSize(font.GetPointSize() - 1);
	m_hyperlink2->SetFont(font);
	sizer2->Add(m_hyperlink2, 0, wxTOP | wxLEFT | wxRIGHT | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);

	topsizer->Add(sizer1, flagsBorder2);
	topsizer->Add(sizer2, flagsBorder2);

	if (buttonSizer) {
		topsizer->Add(buttonSizer, wxSizerFlags(flagsBorder2).Center());
	}

	dlg->SetAutoLayout(true);
	dlg->SetSizer(topsizer);

	topsizer->SetSizeHints(dlg);
	topsizer->Fit(dlg);

	dlg->Centre(wxBOTH);

	dlg->ShowModal();
	dlg->Destroy();
}

void OTFBrutusFrame::onOpenFileBtn( wxCommandEvent& event )
{
	wxFileDialog dlg( NULL, wxT("Select a Header File"), wxT(""), wxT(""), wxT("All Files(*.*)|*.*||"), wxOPEN );

	if (dlg.ShowModal() == wxID_OK) {
		fileNameCtrl->SetValue(dlg.GetPath());
	}
}

void OTFBrutusFrame::onOpenDeviceBtn( wxCommandEvent& event )
{
	DevicesDlg *dlg = new DevicesDlg(this);
	dlg->SetIcon(wxICON(aaaa));

	wxRect r = this->GetRect();
	wxPoint p;
	p.x = r.x;
	p.y = r.y;
	dlg->SetPosition(p);

	if (dlg->ShowModal() == wxID_OK) {
		long itemIndex = -1;
 
		for (;;) {
			itemIndex = dlg->devicesListCtrl->GetNextItem(itemIndex, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
			if (itemIndex == -1)
				break;

			fileNameCtrl->SetValue(dlg->devicesListCtrl->GetItemText(itemIndex));
			break;
		}
	}
}

void OTFBrutusFrame::onDictionaryChoice( wxCommandEvent& event )
{
    int id = ((wxChoice *)event.GetEventObject())->GetSelection();

    if (id == 0) {
		pwdPatternSave = passwordCtrl->GetValue();
		passwordCtrl->SetValue(dictionarySave);
        openDictBtn->Enable(true);
		genWordListBtn->Enable(false);
        //passwordCtrl->DragAcceptFiles(true);
        passwordCtrl->SetDropTarget(new DndDialog(passwordCtrl));
		passwordCtrl->SetToolTip( wxT("Precomputed word list (This is a plaintext file with one password per line)") );
    } else {
		dictionarySave = passwordCtrl->GetValue();
		passwordCtrl->SetValue(pwdPatternSave);
        openDictBtn->Enable(false);
		genWordListBtn->Enable(true);
        //passwordCtrl->DragAcceptFiles(false);
        passwordCtrl->SetDropTarget(NULL);
		//passwordCtrl->SetToolTip( wxT("Password pattern\n  use [] to specify a character pattern type\n    [1234]{2} will build a 2 character pattern using all of the available characters inside the brackets\n      11  12  13  14  21  22  23  34  31  32  33  34  41  42  43  44\n  use () to specify a string pattern type, with each string separated by |\n    (red|blue|black){2} will build a 2 string pattern using all of the available strings inside the parentheses\n      redred  redblue  redblack  bluered  blueblue  blueblack  blackred  blackblue  blackblack\n  If you know the first 16 characters (vUEgSRL745dPr2YM) of your password but forgot the last 4, your pattern might look like this:\n    vUEgSRL745dPr2YM[abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789]{4}") );
		passwordCtrl->SetToolTip( wxT("Read the help file OTFBrutusGUI.txt for details") );
    }
}

void OTFBrutusFrame::onAddKeyFiles( wxCommandEvent& event )
{
	keyFilesDlg *dlg = new keyFilesDlg(this);
	dlg->SetIcon(wxICON(aaaa));

	wxRect r = this->GetRect();
	wxPoint p;
	p.x = r.x;
	p.y = r.y;
	dlg->SetPosition(p);

	for (int i = 0; i < keyFiles.size(); i++) {
		dlg->keyFileListCtrl->InsertItem(i, keyFiles[i]);
	}

	if (dlg->ShowModal() == wxID_OK) {
		keyFiles.clear();
		long itemIndex = -1;
 
		for (;;) {
			itemIndex = dlg->keyFileListCtrl->GetNextItem(itemIndex, wxLIST_NEXT_ALL, wxLIST_STATE_DONTCARE);
			if (itemIndex == -1)
				break;

			keyFiles.push_back(dlg->keyFileListCtrl->GetItemText(itemIndex).c_str());
		}
	}

	if (keyFiles.size() > 0) {
		sort(keyFiles.begin(), keyFiles.end());
		checkKeyFiles->SetValue(true);
		addKeyFilesBtn->Enable();
	} else {
		checkKeyFiles->SetValue(false);
		addKeyFilesBtn->Enable(false);
	}
}

void OTFBrutusFrame::onKeyFilesCheck( wxCommandEvent& event )
{
	if (checkKeyFiles->GetValue()) {
		onAddKeyFiles(wxCommandEvent(wxEVT_NULL));
	} else {
		addKeyFilesBtn->Enable(false);
	}
}

void OTFBrutusFrame::onOpenDictBtn( wxCommandEvent& event )
{
	wxFileDialog dlg( NULL, wxT("Select a Dictionary File"), wxT(""), wxT(""), wxT("All Files(*.*)|*.*||"), wxOPEN );

	if (dlg.ShowModal() == wxID_OK) {
		passwordCtrl->SetValue(dlg.GetPath());
	}
}

void OTFBrutusFrame::onHashCheck( wxCommandEvent& event )
{
	hashVSelect->SetSelection(hashVSelect->GetCount() - 1);
}

void OTFBrutusFrame::onModeCheck( wxCommandEvent& event )
{
	modeVSelect->SetSelection(modeVSelect->GetCount() - 1);
}

void OTFBrutusFrame::onCipherCheck( wxCommandEvent& event )
{
	encVSelect->SetSelection(encVSelect->GetCount() - 1);
}

void OTFBrutusFrame::onHashVChoice( wxCommandEvent& event )
{
    int id = ((wxChoice *)event.GetEventObject())->GetSelection();

	if (id == idHashV50) {
		checkRipeMD->SetValue   (true);
		checkSHA512->SetValue   (true);
		checkWhirlpool->SetValue(true);
		checkSHA1->SetValue     (false);
	} else if (id == idHashV40) {
		checkRipeMD->SetValue   (true);
		checkSHA512->SetValue   (false);
		checkWhirlpool->SetValue(true);
		checkSHA1->SetValue     (true);
	} else if (id == idHashV21) {
		checkRipeMD->SetValue   (true);
		checkSHA512->SetValue   (false);
		checkWhirlpool->SetValue(false);
		checkSHA1->SetValue     (true);
	} else if (id == idHashV10) {
		checkRipeMD->SetValue   (false);
		checkSHA512->SetValue   (false);
		checkWhirlpool->SetValue(false);
		checkSHA1->SetValue     (true);
	} else if (id == idHashVAll) {
		checkRipeMD->SetValue   (true);
		checkSHA512->SetValue   (true);
		checkWhirlpool->SetValue(true);
		checkSHA1->SetValue     (true);
	} else if (id == idHashVCustom) {
		checkRipeMD->SetValue   (false);
		checkSHA512->SetValue   (false);
		checkWhirlpool->SetValue(false);
		checkSHA1->SetValue     (false);
	}

	/*if (id == idHashVCustom) {
		checkRipeMD->SetValue   (false);
		checkSHA512->SetValue   (false);
		checkWhirlpool->SetValue(false);
		checkSHA1->SetValue     (false);

		checkRipeMD->Enable     (true);
		checkSHA512->Enable     (true);
		checkWhirlpool->Enable  (true);
		checkSHA1->Enable       (true);
	} else {
		checkRipeMD->Enable     (false);
		checkSHA512->Enable     (false);
		checkWhirlpool->Enable  (false);
		checkSHA1->Enable       (false);
	}*/
}

void OTFBrutusFrame::onModeVChoice( wxCommandEvent& event )
{
	int id = ((wxChoice *)event.GetEventObject())->GetSelection();

	if (id == idModeV50) {
		checkXTS->SetValue      (true);
		checkLRW->SetValue      (false);
		checkCBC->SetValue      (false);
	} else if (id == idModeV41) {
		checkXTS->SetValue      (false);
		checkLRW->SetValue      (true);
		checkCBC->SetValue      (false);
	} else if (id == idModeV10) {
		checkXTS->SetValue      (false);
		checkLRW->SetValue      (false);
		checkCBC->SetValue      (true);
	} else if (id == idModeVAll) {
		checkXTS->SetValue      (true);
		checkLRW->SetValue      (true);
		checkCBC->SetValue      (true);
	} else if (id == idModeVCustom) {
		checkXTS->SetValue      (false);
		checkLRW->SetValue      (false);
		checkCBC->SetValue      (false);
	}

	/*if (id == idModeVCustom) {
		checkXTS->SetValue      (false);
		checkLRW->SetValue      (false);
		checkCBC->SetValue      (false);

		checkXTS->Enable       (true);
		checkLRW->Enable       (true);
		checkCBC->Enable       (true);
	} else {
		checkXTS->Enable       (false);
		checkLRW->Enable       (false);
		checkCBC->Enable       (false);
	}*/
}

void OTFBrutusFrame::onEncVChoice( wxCommandEvent& event )
{
	int id = ((wxChoice *)event.GetEventObject())->GetSelection();

	if (id == idEncV43) {
		checkAES->SetValue                 (true);
		checkSerpent->SetValue             (true);
		checkTwofish->SetValue             (true);
		checkAES_Twofish->SetValue         (true);
		checkAES_Twofish_Serpent->SetValue (true);
		checkSerpent_AES->SetValue         (true);
		checkSerpent_Twofish_AES->SetValue (true);
		checkTwofish_Serpent->SetValue     (true);
		checkBlowfish->SetValue            (false);
		checkCast5->SetValue               (false);
		checkDES3->SetValue                (false);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (false);
	} else if (id == idEncV30) {
		checkAES->SetValue                 (true);
		checkSerpent->SetValue             (true);
		checkTwofish->SetValue             (true);
		checkAES_Twofish->SetValue         (true);
		checkAES_Twofish_Serpent->SetValue (true);
		checkSerpent_AES->SetValue         (true);
		checkSerpent_Twofish_AES->SetValue (true);
		checkTwofish_Serpent->SetValue     (true);
		checkBlowfish->SetValue            (true);
		checkCast5->SetValue               (true);
		checkDES3->SetValue                (true);
		checkAES_Blowfish->SetValue        (true);
		checkAES_Blowfish_Serpent->SetValue(true);
		checkIDEA->SetValue                (false);
	} else if (id == idEncV21) {
		checkAES->SetValue                 (true);
		checkSerpent->SetValue             (false);
		checkTwofish->SetValue             (false);
		checkAES_Twofish->SetValue         (false);
		checkAES_Twofish_Serpent->SetValue (false);
		checkSerpent_AES->SetValue         (false);
		checkSerpent_Twofish_AES->SetValue (false);
		checkTwofish_Serpent->SetValue     (false);
		checkBlowfish->SetValue            (true);
		checkCast5->SetValue               (true);
		checkDES3->SetValue                (true);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (false);
	} else if (id == idEncV20) {
		checkAES->SetValue                 (true);
		checkSerpent->SetValue             (false);
		checkTwofish->SetValue             (false);
		checkAES_Twofish->SetValue         (false);
		checkAES_Twofish_Serpent->SetValue (false);
		checkSerpent_AES->SetValue         (false);
		checkSerpent_Twofish_AES->SetValue (false);
		checkTwofish_Serpent->SetValue     (false);
		checkBlowfish->SetValue            (true);
		checkCast5->SetValue               (true);
		checkDES3->SetValue                (true);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (true);
	} else if (id == idEncV10) {
		checkAES->SetValue                 (false);
		checkSerpent->SetValue             (false);
		checkTwofish->SetValue             (false);
		checkAES_Twofish->SetValue         (false);
		checkAES_Twofish_Serpent->SetValue (false);
		checkSerpent_AES->SetValue         (false);
		checkSerpent_Twofish_AES->SetValue (false);
		checkTwofish_Serpent->SetValue     (false);
		checkBlowfish->SetValue            (true);
		checkCast5->SetValue               (true);
		checkDES3->SetValue                (true);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (true);
	} else if (id == idEncVAll) {
		checkAES->SetValue                 (true);
		checkSerpent->SetValue             (true);
		checkTwofish->SetValue             (true);
		checkAES_Twofish->SetValue         (true);
		checkAES_Twofish_Serpent->SetValue (true);
		checkSerpent_AES->SetValue         (true);
		checkSerpent_Twofish_AES->SetValue (true);
		checkTwofish_Serpent->SetValue     (true);
		checkBlowfish->SetValue            (true);
		checkCast5->SetValue               (true);
		checkDES3->SetValue                (true);
		checkAES_Blowfish->SetValue        (true);
		checkAES_Blowfish_Serpent->SetValue(true);
		checkIDEA->SetValue                (true);
	} else if (id == idEncVCustom) {
		checkAES->SetValue                 (false);
		checkSerpent->SetValue             (false);
		checkTwofish->SetValue             (false);
		checkAES_Twofish->SetValue         (false);
		checkAES_Twofish_Serpent->SetValue (false);
		checkSerpent_AES->SetValue         (false);
		checkSerpent_Twofish_AES->SetValue (false);
		checkTwofish_Serpent->SetValue     (false);
		checkBlowfish->SetValue            (false);
		checkCast5->SetValue               (false);
		checkDES3->SetValue                (false);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (false);
	}

	/*if (id == idEncVCustom) {
		checkAES->SetValue                 (false);
		checkSerpent->SetValue             (false);
		checkTwofish->SetValue             (false);
		checkAES_Twofish->SetValue         (false);
		checkAES_Twofish_Serpent->SetValue (false);
		checkSerpent_AES->SetValue         (false);
		checkSerpent_Twofish_AES->SetValue (false);
		checkTwofish_Serpent->SetValue     (false);
		checkBlowfish->SetValue            (false);
		checkCast5->SetValue               (false);
		checkDES3->SetValue                (false);
		checkAES_Blowfish->SetValue        (false);
		checkAES_Blowfish_Serpent->SetValue(false);
		checkIDEA->SetValue                (false);

		checkAES->Enable                   (true);
		checkSerpent->Enable               (true);
		checkTwofish->Enable               (true);
		checkAES_Twofish->Enable           (true);
		checkAES_Twofish_Serpent->Enable   (true);
		checkSerpent_AES->Enable           (true);
		checkSerpent_Twofish_AES->Enable   (true);
		checkTwofish_Serpent->Enable       (true);
		checkBlowfish->Enable              (true);
		checkCast5->Enable                 (true);
		checkDES3->Enable                  (true);
		checkAES_Blowfish->Enable          (true);
		checkAES_Blowfish_Serpent->Enable  (true);
		checkIDEA->Enable                  (true);
	} else {
		checkAES->Enable                   (false);
		checkSerpent->Enable               (false);
		checkTwofish->Enable               (false);
		checkAES_Twofish->Enable           (false);
		checkAES_Twofish_Serpent->Enable   (false);
		checkSerpent_AES->Enable           (false);
		checkSerpent_Twofish_AES->Enable   (false);
		checkTwofish_Serpent->Enable       (false);
		checkBlowfish->Enable              (false);
		checkCast5->Enable                 (false);
		checkDES3->Enable                  (false);
		checkAES_Blowfish->Enable          (false);
		checkAES_Blowfish_Serpent->Enable  (false);
		checkIDEA->Enable                  (false);
	}*/
}

void OTFBrutusFrame::onStart( wxCommandEvent& event )
{
	if (isRunning) {
		isRunning = false;

		SetCursor(wxCURSOR_ARROWWAIT);
		WaitForSingleObject(hRunEvent, 10000);
		SetCursor(wxCURSOR_DEFAULT);

		runBtn->SetLabel(wxT("Start"));
		genWordListBtn->SetLabel(wxT("Save Word List"));
		genWordListBtn->Enable(true);
		statusBar->SetStatusText(wxT(""));
		menuFile->Enable(idMenuLoad, true);

		if (OTFFile) {
			delete OTFFile;
			OTFFile = NULL;
		}
		if (pwd_pattern) {
			delete pwd_pattern;
			pwd_pattern = NULL;
		}
		if (dictionary) {
			delete dictionary;
			dictionary = NULL;
		}

		if (hRunEvent) {
			CloseHandle(hRunEvent);
			hRunEvent = NULL;
		}
		//if (hRunThread) {
		//	CloseHandle(hRunThread);
		//	hRunThread = NULL;
		//}
	} else {
		bSaveWordList = event.GetEventObject() == genWordListBtn;

		err.clear();
		logString.clear();
		status.clear();
		user_hash.clear();
		user_mode.clear();
		user_cipher.clear();
		statusCtrl->SetValue(err);

		if (fileNameCtrl->IsEmpty() && !bSaveWordList) {
			wxMessageBox(_("Please select a TrueCrypt file or header"));
			fileNameCtrl->SetFocus();
			return;
		}
		if (passwordCtrl->IsEmpty()) {
			wxMessageBox(_("Please select a dictionary or enter a password pattern"));
			passwordCtrl->SetFocus();
			return;
		}

		wxString s = fileNameCtrl->GetValue();
		OTFFile = new char[s.Length() + 1];
		memcpy(OTFFile, s.c_str(), s.Length());
		OTFFile[s.Length()] = 0; 

		s = passwordCtrl->GetValue();
		if (dictionarySelect->GetSelection() == 0) {
			dictionary = new char[s.Length() + 1];
			memcpy(dictionary, s.c_str(), s.Length());
			dictionary[s.Length()] = 0;
		} else {
			pwd_pattern = new char[s.Length() + 1];
			memcpy(pwd_pattern, s.c_str(), s.Length());
			pwd_pattern[s.Length()] = 0;
		}

		if (checkRipeMD->GetValue()) {
			user_hash.push_back(OTF_RIPEMD160);
		}
		if (checkSHA512->GetValue()) {
			user_hash.push_back(OTF_SHA512);
		}
		if (checkWhirlpool->GetValue()) {
			user_hash.push_back(OTF_WHIRLPOOL);
		}
		if (checkSHA1->GetValue()) {
			user_hash.push_back(OTF_SHA1);
		}

		if (checkXTS->GetValue()) {
			user_mode.push_back(OTF_XTS);
		}
		if (checkLRW->GetValue()) {
			user_mode.push_back(OTF_LRW);
		}
		if (checkCBC->GetValue()) {
			user_mode.push_back(OTF_CBC);
		}

        int maxCascade = 1;
		if (checkAES->GetValue()) {
			user_cipher.push_back(OTF_AES);
		}
		if (checkSerpent->GetValue()) {
			user_cipher.push_back(OTF_SERPENT);
		}
		if (checkTwofish->GetValue()) {
			user_cipher.push_back(OTF_TWOFISH);
		}
		if (checkAES_Twofish->GetValue()) {
			user_cipher.push_back(OTF_AES_TWOFISH);
            maxCascade = max(maxCascade, 2);
		}
		if (checkAES_Twofish_Serpent->GetValue()) {
			user_cipher.push_back(OTF_AES_TWOFISH_SERPENT);
            maxCascade = max(maxCascade, 3);
		}
		if (checkSerpent_AES->GetValue()) {
			user_cipher.push_back(OTF_SERPENT_AES);
            maxCascade = max(maxCascade, 2);
		}
		if (checkSerpent_Twofish_AES->GetValue()) {
			user_cipher.push_back(OTF_SERPENT_TWOFISH_AES);
            maxCascade = max(maxCascade, 3);
		}
		if (checkTwofish_Serpent->GetValue()) {
			user_cipher.push_back(OTF_TWOFISH_SERPENT);
            maxCascade = max(maxCascade, 2);
		}
		if (checkBlowfish->GetValue()) {
			user_cipher.push_back(OTF_BLOWFISH);
            maxCascade = max(maxCascade, 2);
		}
		if (checkCast5->GetValue()) {
			user_cipher.push_back(OTF_CAST5);
		}
		if (checkDES3->GetValue()) {
			user_cipher.push_back(OTF_DES3);
		}
		if (checkAES_Blowfish->GetValue()) {
			user_cipher.push_back(OTF_AES_BLOWFISH);
            maxCascade = max(maxCascade, 2);
		}
		if (checkAES_Blowfish_Serpent->GetValue()) {
			user_cipher.push_back(OTF_AES_BLOWFISH_SERPENT);
            maxCascade = max(maxCascade, 3);
		}
		if (checkIDEA->GetValue()) {
			user_cipher.push_back(OTF_IDEA);
		}

        externalPKCS = 1 << (maxCascade + 4);
		externalPKCS |= (checkXTS->GetValue() | checkLRW->GetValue()) << 4;
		externalPKCS |= menuHashRMD->IsChecked(idMenuHashTC1) << 3;
		externalPKCS |= menuHashSHA512->IsChecked(idMenuHashTC2) << 2;
		externalPKCS |= menuHashWhirlpool->IsChecked(idMenuHashTC3) << 1;
		externalPKCS |= int(menuHashSHA1->IsChecked(idMenuHashTC4));
		//| (rTC->GetValue() << 3) | (s5TC->GetValue() << 2) | (wTC->GetValue() << 1) | (s1TC->GetValue());

		iVolType = volumeTypeSelect->GetCurrentSelection();
		threads = comboThreads->GetCurrentSelection() + 1;
		useKeyFiles = checkKeyFiles->GetValue() && keyFiles.size() > 0;

		idxStart = idxEnd = 0;
		s = startIdxCtrl->GetValue();
		if (s.IsNumber()) {
			idxStart = _atoi64(s.c_str());
		}
		if (idxStart < 1)
			idxStart = 1;

		s = endIdxCtrl->GetValue();
		if (s.IsNumber()) {
			idxEnd = _atoi64(s.c_str());
		}
		if (idxEnd < 0)
			idxEnd = 0;

		if (bSaveWordList) {
			wxFileDialog dlg( NULL, wxT("Select a File to save as"), wxT(""), wxT(""), wxT("Text Files(*.txt)|*.txt||"), wxSAVE);

			if (dlg.ShowModal() == wxID_OK) {
				wordListFile = dlg.GetPath();
				if (wxFileExists(wordListFile)) {
					/* only works in wxWidgets v2.9+
					wxMessageDialog dlg(wxGetActiveWindow(),
						wxT("Overwrite the file? Press Yes\nAppend to the file? Press No\nChoose another file? Press Cancel"),
						wxT("File Exists - Overwrite?"),  wxYES_NO | wxCANCEL | wxICON_EXCLAMATION);
					dlg.se(_("&Overwrite"), _("&Append"));
					int ans = dlg.ShowModal();*/
					int ans = wxMessageBox("Overwrite the file? Press Yes\nAppend to the file? Press No\nChoose another file? Press Cancel",
						"File Exists - Overwrite?", wxYES_NO | wxCANCEL | wxICON_EXCLAMATION);
					if (ans == wxYES) {
						bOverwrite = TRUE;
					} else if (ans == wxNO) {
						bOverwrite = FALSE;
					} else {
						wordListFile = wxT("");
						return;
					}
				}
			} else {
				wordListFile = wxT("");
				return;
			}

			genWordListBtn->SetLabel(wxT("Stop"));
		}

		SetCursor(wxCURSOR_ARROWWAIT);

		hRunEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
			if (hRunEvent == INVALID_HANDLE_VALUE) {
				wxMessageBox(_("Error :: Failed to create Run Thread Event"));
				SetCursor(wxCURSOR_DEFAULT);
				return;
			}
		hRunThread = (HANDLE) _beginthread(runThread, 0, (void*)0);
			if (hRunThread == INVALID_HANDLE_VALUE) {
				wxMessageBox(_("Error :: Failed to create Run Thread"));
				SetCursor(wxCURSOR_DEFAULT);
				return;
			}

		isRunning = true;
		runBtn->SetLabel(wxT("Stop"));
		genWordListBtn->Enable(false);
		menuFile->Enable(idMenuLoad, false);
	}
}
