/***************************************************************
 * Name:      OTFBrutusMain.h
 * Author:    Josh Harris (tateu@tateu.net)
 * Created:   2010-12-01
 * Copyright: Josh Harris (www.tateu.net)
 * License:
 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation and/or
     other materials provided with the distribution.
  3. The name of the author may not be used to endorse or promote products derived
     from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **************************************************************/

#ifndef OTFBrutusMAIN_H
#define OTFBrutusMAIN_H

#include "OTFBrutusApp.h"

/*
for GUIFrame.h
#ifdef WX_GCH
#include <wx_pch.h>
#else
#include <wx/wx.h>
#endif
*/

#include "GUIFrame.h"

#include <wx/hyperlink.h>
#include <wx/tooltip.h>
#include <wx/config.h>
#include <wx/msw/iniconf.h>

#define MAX_THREADS					16

#define idHashV50					0
#define idHashV40					1
#define idHashV21					2
#define idHashV10					3
#define idHashVAll					4
#define idHashVCustom				5

#define idModeV50					0
#define idModeV41					1
#define idModeV10					2
#define idModeVAll					3
#define idModeVCustom				4

#define idEncV43					0
#define idEncV30					1
#define idEncV21					2
#define idEncV20					3
#define idEncV10					4
#define idEncVAll					5
#define idEncVCustom				6

class OTFBrutusFrame: public GUIFrame
{
    protected:
		// Handlers for GUIFrame events.
		void OnClose( wxCloseEvent& event );
		void onOpenFileBtn( wxCommandEvent& event );
		void onOpenDeviceBtn( wxCommandEvent& event );
		void onDictionaryChoice( wxCommandEvent& event );
		void onAddKeyFiles( wxCommandEvent& event );
		void onKeyFilesCheck( wxCommandEvent& event );
		void onOpenDictBtn( wxCommandEvent& event );
		void onHashVChoice( wxCommandEvent& event );
		void onHashCheck( wxCommandEvent& event );
		void onModeVChoice( wxCommandEvent& event );
		void onModeCheck( wxCommandEvent& event );
		void onEncVChoice( wxCommandEvent& event );
		void onVolVChoice( wxCommandEvent& event );
		void onCipherCheck( wxCommandEvent& event );
		void OnQuit( wxCommandEvent& event );
		void LoadSettings();
		void OnLoad( wxCommandEvent& event );
		void OnSave( wxCommandEvent& event );
		void OnAbout( wxCommandEvent& event );
		void onStart( wxCommandEvent& event );

		wxString dictionarySave;
		wxString pwdPatternSave;
	public:
		/** Constructor */
		OTFBrutusFrame( wxWindow* parent );
		~OTFBrutusFrame();

		bool init();
	private:
		WXLRESULT MSWWindowProc(WXUINT nMsg, WXWPARAM wParam, WXLPARAM lParam);
		wxFont sysFixedFont;
};

#endif // OTFBrutusMAIN_H
