#include "OmfMovie.h"

typedef struct _AafOmfGlobals
{
	omfInt16		numIndents;
	char			indentLeader[MAX_PATH+1];

	omfBool			bVerboseMode;
	omfBool			bCreateTOCFile;
	omfBool			bConvertAllObjects;
	omfBool			bOMFFileOpen;
	omfBool			bAAFFileOpen;
	omfBool			bLogFile;
	omfBool			bDefFile;
	omfBool			bDeleteOutput;
	omfBool			bConvertAAFFile;

	// For Statistical summary
	omfInt32		nNumOMFMobs;
	omfInt32		nNumAAFMobs;
	omfInt32		nNumOMFObjects;
	omfInt32		nNumAAFObjects;
	omfInt32		nNumOMFProperties;
	omfInt32		nNumAAFProperties;
	omfInt32		nNumUndefinedOMFObjects;
	omfInt32		nNumUndefinedOMFProperties;
	omfInt32		nNumUndefinedAAFObjects;
	omfInt32		nNumUndefinedAAFProperties;

	char			sInFileName[256];
	char			sTOCFileName[256];
	char			sDefinitionFileName[256];
	char			sOutFileName[256];
	char			sLogFileName[256];
	char*		pProgramName;

	// MC Private Properties
	omfProperty_t		pvtEffectIDProp;
	omfProperty_t		pvtAppCode;
	omfProperty_t		pvtAttributes;
	omfProperty_t		pvtDataAttribute;

	// Codec Properties
	omfProperty_t		omCDCIComponentWidth;
	omfProperty_t		omCDCIHorizontalSubsampling;
	omfProperty_t		omCDCIColorSiting;
	omfProperty_t		omCDCIBlackReferenceLevel;
	omfProperty_t		omCDCIWhiteReferenceLevel;
	omfProperty_t		omCDCIColorRange;
	omfProperty_t		omCDCIPaddingBits;
} AafOmfGlobals;

AafOmfGlobals gpGlobals;

omfProperty_t OMDIDDFirstFrameOffset;

void RegisterCodecProperties(AafOmfGlobals *globals, omfSessionHdl_t OMFSession)
{
	omfErr_t	OMFError;

	// To get the CDCI codec related properties we first register them in OMF
	OMFError = omfsRegisterDynamicProp(OMFSession, kOmfTstRevEither,
									"ComponentWidth", OMClassCDCI,
									OMVersionType, kPropRequired,
									&(globals->omCDCIComponentWidth));
	OMFError = omfsRegisterDynamicProp(OMFSession, kOmfTstRevEither,
									"HorizontalSubsampling", OMClassCDCI,
									OMBoolean, kPropRequired,
									&(globals->omCDCIHorizontalSubsampling));
	OMFError = omfsRegisterDynamicProp(OMFSession, kOmfTstRevEither,
									"ColorSiting", OMClassCDCI,
									OMBoolean, kPropRequired,
									&(globals->omCDCIColorSiting));
	OMFError = omfsRegisterDynamicProp(OMFSession, kOmfTstRevEither,
									"BlackReferenceLevel", OMClassCDCI,
									OMInt32, kPropRequired,
									&(globals->omCDCIBlackReferenceLevel));
	OMFError = omfsRegisterDynamicProp(OMFSession, kOmfTstRevEither,
									"WhiteReferenceLevel", OMClassCDCI,
									OMInt32, kPropRequired,
									&(globals->omCDCIWhiteReferenceLevel));
	OMFError = omfsRegisterDynamicProp(OMFSession, kOmfTstRevEither,
									"ColorRange", OMClassCDCI,
									OMInt32, kPropRequired,
									&(globals->omCDCIColorRange));
	OMFError = omfsRegisterDynamicProp(OMFSession, kOmfTstRevEither,
									"PaddingBits", OMClassCDCI,
									OMInt32, kPropRequired,
									&(globals->omCDCIPaddingBits));
}

#define SWAP_FOUR(x) ( \
	((UINT32)x & 0xFF) << 24 | \
	((UINT32)x & 0xFF00) << 8 | \
	((UINT32)x & 0xFF0000) >> 8 | \
	((UINT32)x & 0xFF000000) >> 24 )
#define SWAP_TWO(x) ( \
	((UINT16)x & 0xFF) << 8 | \
	((UINT16)x & 0xFF00) >> 8 )

const UINT32 kNumTimeQuantumsInSecond = 10000000;
const UINT64 kUnixTimeStartValue = ((UINT64)kNumTimeQuantumsInSecond) * 60 * 60 * 24 * 134774;
void UnixTimeToFileTime(UINT32 unixTime, FILETIME &fileTime)
{
UINT64 v = kUnixTimeStartValue + ((UINT64)unixTime) * kNumTimeQuantumsInSecond;
fileTime.dwLowDateTime = (DWORD)v;
fileTime.dwHighDateTime = (DWORD)(v >> 32);
}

int Seek_Bytes( byte *pBuffer, unsigned long bufLength, unsigned long offset,
	unsigned long Search_For, int nLength )
{
	unsigned long ReturnVal = 0;
	unsigned long ByteLoc = offset;
	unsigned int MaxBitsOn = (int)pow(2.0, (nLength * 8)) - 1;

	Search_For &= MaxBitsOn;

	while( nLength > 0)
	{
		ReturnVal <<= 8;
		ReturnVal |= pBuffer[ByteLoc];
		nLength--;
		ByteLoc++;
	}

	while( ReturnVal != Search_For && ByteLoc < bufLength )
	{
		ReturnVal <<= 8;
		ReturnVal |= pBuffer[ByteLoc];
		ReturnVal &= MaxBitsOn;
		ByteLoc++;

		/*if (ByteLoc > && ByteLoc < ) {
			//if (bInfo) fprintf(infoFile, "Seek at %u for %x = %x\n", ByteLoc, Search_For, ReturnVal);
		}*/
	}
	//if (bInfo) fprintf(infoFile, "End Seek at %u for %x\n", ByteLoc, Search_For);

	if (ByteLoc < bufLength)
		return ByteLoc;
	else
		return 0;
}

COmfMovieDec::COmfMovieDec()
{
	OMFError = OM_ERR_NONE;
	bSessionStarted = false;

	strStatus = NULL;
	omfFile = NULL; infoFile = NULL;
	rows = NULL;
	mpeg2decoder = NULL;
	cinfo.src = NULL;
	InitVariables();

	OMFError = omfsBeginSession(0, &OMFSession);
	if (OMFError != OM_ERR_NONE) {
		sprintf(strStatus, "Unable to begin OMF session: %d\n", OMFError);
		return;
	}

	RegisterCodecProperties(&gpGlobals, OMFSession);
	//omfmLoadMediaPlugins

	OMFError = omfmInit(OMFSession);
	if (OMFError != OM_ERR_NONE) {
		sprintf(strStatus, "Unable to initialize OMF session: %d\n", OMFError);
		omfsEndSession(OMFSession);
		return;
	}

	bSessionStarted = true;
}

void COmfMovieDec::InitVariables()
{
	if (strStatus)
		delete [] strStatus;

	strStatus = new char[512];
	strcpy(strStatus, "No Error");

	//OMFFileRev = NULL;
	OMFVersion = 0;
	OMFHeader = NULL; OMFObject = NULL;
	//headMediaID = 0;

	mOMFNumMobs = 0;

	//vNumTracks = 0; aNumTracks = 0;
	//vNumSlots = 0; aNumSlots = 0;

	//vMediaPtr = NULL; aMediaPtr = NULL;
	//vMediaCrit = NULL; aMediaCrit = NULL;

	vMediaObject = NULL;
	//vMediaIDProperty = NULL;
	vMediaDatakind = NULL;
	//IDATpropName = NULL;

	bReadMedia = false; bForceUseDataValue = false;
	bValidSourceMediaMob = false;
	numBytes = 0; numBytesRead = 0; nBlockSize = 0;
	OMFOffset = 0;

	//Video Properties
		//frameLayout = 0;
		zeroPos = 0; fourPos = 0;
		StoredHeight = 0; StoredWidth = 0;
		DisplayHeight = 0; DisplayWidth = 0;
		SampledHeight = 0; SampledWidth = 0;
		SampledXOffset = 0; SampledYOffset = 0;
		DisplayXOffset = 0; DisplayYOffset = 0;
		alphaTransparency = 0;
		alignmentFactor = 0;
		aspectRatio.denominator = 0; aspectRatio.numerator = 0;
		fps.denominator = 0; fps.numerator = 0;
		frameCount = 0;
		FrameIndexOffset = 0;
		m_iFirstFrameOffset = 0;

	//Video Properties - Extended
		componentWidth = 0;
		horizontalSubsampling = 0;
		//colorSiting = NULL;
		blackReferenceLevel = 0;
		whiteReferenceLevel = 0;
		colorRange = 0;
		paddingBits = 0;
		videoLineMap[0] = 0; videoLineMap[1] = 0;

	m_iFieldOrder = -1;

	m_iCodec = 0;
	bFirstTime = true; bNeedFrameOffset = false;
	m_iDecompressFrameSize = 0;

	if (infoFile)
		fclose(infoFile);
	if (omfFile)
		fclose(omfFile);

	omfFile = NULL; infoFile = NULL;
	ZeroMemory(infoFileName, sizeof(infoFileName));
	bInfo = false;
	omfFileLength = 0;

	/*
	struct jpeg_decompress_struct cinfo;
	struct jpeg_source_mgr jsrc;
	struct my_error_mgr jerr;

	mpeg2dec_t *mpeg2decoder;
	const mpeg2_info_t *mpeg2info;
	const mpeg2_sequence_t *mpeg2sequence;
	mpeg2_state_t mpeg2state;
	*/
}

COmfMovieDec::~COmfMovieDec()
{
	omfsCloseFile(OMFFileHdl);
	omfsEndSession(OMFSession);
	m_vFramePos.clear();

	if (cinfo.src) {
		jpeg_destroy_decompress(&cinfo);
	}

	if (strStatus)
		delete [] strStatus;
	if (infoFile) {
		fclose(infoFile);
		infoFile = NULL;
	}
	if (omfFile) {
		fclose(omfFile);
		omfFile = NULL;
	}

	if (mpeg2decoder) {
		mpeg2_close(mpeg2decoder);
		mpeg2decoder = NULL;
	}

	if (rows) {
		for(int row = 0; row < StoredHeight; row++) free(rows[row]);
		free(rows);
	}
}

bool COmfMovieDec::SetInfoFile(char *strName)
{
	if (!bSessionStarted) {
		sprintf(strStatus, "Session Not Started");
		return false;
	}

	strcpy(infoFileName, strName);

	infoFile = fopen(infoFileName, "wt");
	if (infoFile == NULL) {
		sprintf(strStatus, "Unable to open infoFile:\n%s", infoFileName);
		return false;
	}

	bInfo = true;

	return true;
}

int COmfMovieDec::OpenMovie(char *strFileName) //HRESULT
{
	if (!bSessionStarted) {
		sprintf(strStatus, "Session Not Started");
		return -1;
	}

	strcpy(FileName, strFileName);

	OMFError = omfsOpenFile((fileHandleType)FileName, OMFSession, &OMFFileHdl);
	if (OMFError != OM_ERR_NONE)
	{
		sprintf(strStatus, "omfsOpenFile error: %d", OMFError);
		omfsEndSession(OMFSession);
		return -1;
	}

	if (bInfo) fprintf(infoFile, "%s\n", FileName);

	OMFError = omfsFileGetRev(OMFFileHdl, &OMFFileRev);
	OMFVersion = (OMFFileRev==kOmfRev2x) ? 2 : 1;

	if (bInfo) fprintf(infoFile, "\tFile Version: %d\n", OMFVersion);

	if ( ReadOMFHeader() != OM_ERR_NONE )
		return 0;
	if ( ReadOMFMobs() != OM_ERR_NONE )
		return 0;

	if (bInfo) {
		fprintf(infoFile, "\n%s\n", m_iCodec == CODEC_TYPE_RGBA ? "RGBA" :
			(m_iCodec == CODEC_TYPE_CDCI ? "CDCI" :
			(m_iCodec == CODEC_TYPE_JPEG ? "JPEG" :
			(m_iCodec == CODEC_TYPE_DVC  ? "DV/C NTSC" :
			(m_iCodec == CODEC_TYPE_DVCP  ? "DV/C PAL" :
			(m_iCodec == CODEC_TYPE_MPG2  ? "Mpeg2" :
			(m_iCodec == CODEC_TYPE_TIFF  ? "Tiff" : "UNKnown"
			)))))));
		fprintf(infoFile, "frameCount: %d\n", frameCount);
		fprintf(infoFile, "StoredWidth: %d, StoredHeight: %d\n", StoredWidth, StoredHeight);
		fprintf(infoFile, "DisplayWidth: %d, DisplayHeight: %d\n", DisplayWidth, DisplayHeight);
		fprintf(infoFile, "SampledWidth: %d, SampledHeight: %d\n", SampledWidth, SampledHeight);
		fprintf(infoFile, "Aspect Ratio: %d:%d, fps: %0.3f\n",
				aspectRatio.numerator, aspectRatio.denominator,
				float(fps.numerator)/float(fps.denominator));
		fprintf(infoFile, "SampledXOffset: %d, SampledYOffset: %d\n", SampledXOffset, SampledYOffset);
		fprintf(infoFile, "DisplayXOffset: %d, DisplayYOffset: %d\n", DisplayXOffset, DisplayYOffset);
		fprintf(infoFile, "alphaTransparency: %d, componentWidth: %d\n", alphaTransparency, componentWidth);
		fprintf(infoFile, "horizontalSubsampling: %d, alignmentFactor: %d, frameLayout: %d\n", horizontalSubsampling, alignmentFactor, frameLayout);
		fprintf(infoFile, "blackReferenceLevel: %d, whiteReferenceLevel: %d\n", blackReferenceLevel, whiteReferenceLevel);
		fprintf(infoFile, "colorRange: %d, paddingBits: %d\n", colorRange, paddingBits);
		fprintf(infoFile, "videoLineMap0: %d, videoLineMap1: %d\n", videoLineMap[0], videoLineMap[1]);

		fprintf(infoFile, "FirstFrameOffset: %u\n", m_iFirstFrameOffset);
		fprintf(infoFile, "FrameIndexOffset: %u\n", FrameIndexOffset);

		fprintf(infoFile, "\n\n");
	}

	return 1;
}

int COmfMovieDec::ReadOMFHeader()
{
	omfProperty_t OMFPropertyID;
	int m_iMediaType = DATA_TYPE_UNKNOWN;

	OMFError = omfsGetHeadObject( OMFFileHdl, &OMFHeader );

	m_iNumDefs = omfsLengthObjRefArray(OMFFileHdl, OMFHeader, OMHEADDefinitionObjects);

	if (bInfo) fprintf(infoFile, "Data Definition Count: %d\n", m_iNumDefs);

	for (int i = 1; i <= m_iNumDefs; i++)
	{
		OMFError = omfsGetNthObjRefArray(OMFFileHdl, OMFHeader, OMHEADDefinitionObjects, &OMFObject, i);
		ReadOMFDataDef(OMFObject);
	}


	if (OMFFileRev == kOmfRev2x) {
		m_iNumClassDC = omfsLengthObjRefArray(OMFFileHdl, OMFHeader, OMHEADClassDictionary);
	} else {
		m_iNumClassDC = omfsLengthObjRefArray(OMFFileHdl, OMFHeader, OMClassDictionary);
	}

	if (bInfo) fprintf(infoFile, "Class Dictionary Count: %d\n", m_iNumClassDC);

	for (int j = 1; j <= m_iNumClassDC; j++)
	{
		if (OMFFileRev == kOmfRev2x)
			OMFError = omfsGetNthObjRefArray(OMFFileHdl, OMFHeader, OMHEADClassDictionary, &OMFObject, j);
		else
			OMFError = omfsGetNthObjRefArray(OMFFileHdl, OMFHeader, OMClassDictionary, &OMFObject, j);

		ReadOMFClassDC(OMFObject);
	}


	if (OMFFileRev == kOmfRev2x) {
		OMFPropertyID = OMHEADMediaData;
		m_iNumMedia = omfsLengthObjRefArray(OMFFileHdl, OMFHeader, OMFPropertyID);
	} else {
		OMFPropertyID = OMMediaData;
		m_iNumMedia = omfsLengthObjIndex(OMFFileHdl, OMFHeader, OMFPropertyID);
	}

	if (bInfo) fprintf(infoFile, "Media Count: %d\n", m_iNumMedia);

	for (int k = 1; k <= m_iNumMedia; k++)
	{
		omfObjIndexElement_t objIndex;
		omfUID_t tmpMediaID;

		if (OMFFileRev == kOmfRev2x) {
			OMFError = omfsGetNthObjRefArray(OMFFileHdl, OMFHeader, OMFPropertyID, &OMFObject, k);
			OMFError = omfsReadUID(OMFFileHdl, OMFObject, OMMDATMobID, &tmpMediaID);
			//tmpMediaID.prefix = 0;
			//tmpMediaID.major = 0;
			//tmpMediaID.minor = 0;
		} else {
			OMFError = omfsGetNthObjIndex(OMFFileHdl, OMFHeader, OMFPropertyID, &objIndex, k);
			OMFObject = objIndex.Mob;
			tmpMediaID = objIndex.ID;

		}

		int m_iTemp;
		m_iTemp = ReadOMFMediaData(OMFObject, tmpMediaID);
		if ( m_iTemp < 3) {
			headMediaID = tmpMediaID;
			m_iMediaType = m_iTemp;
			break;
		}
	}

	//if (bInfo) fprintf(infoFile, "Data Def: %s\n", objClass);

	if (bInfo) {
		omfIterHdl_t fileIter;

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		OMFError = omfiIteratorAlloc(OMFFileHdl, &fileIter);
		OMFError = omfiGetNextObject(fileIter, &OMFObject);

		fprintf(infoFile, "Class & Property List: %d\n", mOMFNumMobs);

		while (OMFError == OM_ERR_NONE) {
			memset(id, 0, sizeof(id));
			OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
			fprintf(infoFile, "\t%s\n", id);

			OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

			while (OMFError == OM_ERR_NONE && tmpProp) {
				OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

				mPropOffset = 0;
				OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
					tmpType, &mPropOffset);

				//if (mPropOffset < 1000)
					fprintf(infoFile, "\t\t%s = %d\n", tmpPropName, mPropOffset);
				//else
				//	fprintf(infoFile, "\t%s = %X\n", tmpPropName, mPropOffset);

				/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
							zeroPos, kNeverSwab, OMUInt32,
							sizeof(omfUInt32), &mPropOffset);
				OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
				fprintf(infoFile, "\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

				OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
			}
			OMFError = omfiIteratorDispose(OMFFileHdl, propIter);

			/*if (omfsReadUInt32(OMFFileHdl, OMFObject, OMDIDDStoredHeight, &StoredHeight) != OM_ERR_NONE) {
				if (omfsReadInt32(OMFFileHdl, OMFObject, OMDIDDStoredHeight, (omfInt32 *)&StoredHeight) != OM_ERR_NONE) {
					StoredHeight = 0;
				} else {
					fprintf(infoFile, "\t\tStoredHeight = %d\n", StoredHeight);
				}
			} else {
				fprintf(infoFile, "\t\tStoredHeight = %d\n", StoredHeight);
			}*/

			OMFError = omfiGetNextObject(fileIter, &OMFObject);
		}//OM_ERR_NO_MORE_OBJECTS

		OMFError = omfiIteratorDispose(OMFFileHdl, fileIter);
	}

	if (m_iMediaType > 2) {
		if (m_iMediaType == DATA_TYPE_TIFF)
			strcpy(strStatus,"Unable to read TIFF formatted video media");
		else if (m_iMediaType == DATA_TYPE_WAV)
			strcpy(strStatus,"No video data found.\nUnable to read WAV formatted audio media");
		else if (m_iMediaType == DATA_TYPE_AIFF)
			strcpy(strStatus,"No video data found.\nUnable to read AIFF formatted audio media");
		else //if (m_iMediaType == DATA_TYPE_UNKNOWN)
			strcpy(strStatus,"Unknown media type");

		return OM_ERR_CODEC_INVALID;
	}

	return OM_ERR_NONE;
}

omfErr_t COmfMovieDec::ReadOMFDataDef(omfObject_t obj)
{
	omfProperty_t OMFPropertyID;
	char objClass[5];

	if (OMFFileRev == kOmfRev2x) {
		OMFPropertyID = OMOOBJObjClass;
	} else {
		OMFPropertyID = OMObjID;
	}

	memset(objClass, 0, sizeof(objClass));
	OMFError = omfsReadClassID(OMFFileHdl, obj, OMFPropertyID, objClass);
	//if (OMFError != OM_ERR_NONE)
	//	return OMFError;

	//This list gets printed at the end of ReadOMFHeader, but this list is in order
	/*if (bInfo) {
		if (objClass)
			fprintf(infoFile, "\tData Def: %s\n", objClass);
		else
			fprintf(infoFile, "\tUnknown Data Def\n");
	}*/
	return OMFError;
}

omfErr_t COmfMovieDec::ReadOMFClassDC(omfObject_t obj)
{
	omfProperty_t OMFPropertyID;
	char objClass[5];

	if (OMFFileRev == kOmfRev2x) {
		OMFPropertyID = OMCLSDClass;
	} else {
		OMFPropertyID = OMCLSDClassID;
	}

	memset(objClass, 0, sizeof(objClass));
	OMFError = omfsReadClassID(OMFFileHdl, obj, OMFPropertyID, objClass);
	//if (OMFError != OM_ERR_NONE)
	//	return OMFError;

	//This list gets printed at the end of ReadOMFHeader, but this list is in order
	if (bInfo) {
		if (objClass)
			fprintf(infoFile, "\tClass Dictionary: %s\n", objClass);
		else
			fprintf(infoFile, "\tUnknown Class Dictionary\n");
	}
	return OMFError;
}

int COmfMovieDec::ReadOMFMediaData( omfObject_t obj, omfUID_t inMediaID )
{
	omfProperty_t OMFPropertyID;
	char objClass[24];
	omfUniqueName_t propName;
	int m_iType;

	if (OMFFileRev == kOmfRev2x) {
		OMFPropertyID = OMOOBJObjClass;
	} else {
		OMFPropertyID = OMObjID;
	}

	strcpy(propName, "OMFI:");

	memset(objClass, 0, sizeof(objClass));
	OMFError = omfsReadClassID(OMFFileHdl, obj, OMFPropertyID, objClass);
	//if (OMFError != OM_ERR_NONE)
	//	return OMFError;

	if (bInfo) {
		if (objClass)
			fprintf(infoFile, "\tMediaType: %s\n", objClass);
		else
			fprintf(infoFile, "\tUnknown MediaType\n");
	}

	if (strncmp(objClass, "TIFF", 4) == 0) {
		m_iType = DATA_TYPE_TIFF;

		//Cannot handle TIFF data
		/*
		if (OMFFileRev == kOmfRev2x) {
			vMediaIDProperty = OMTIFFData;
			omfiDatakindLookup(OMFFileHdl, "omfi:data:Picture", &vMediaDatakind, &OMFError );
		} else {
			strncat(propName, objClass, (size_t)4);
			strcat(propName, ":Data");
		}

		bReadMedia = true;
		vMediaObject = obj;
		*/
	} else if (strncmp(objClass, "IDAT", 4) == 0) { //RGBA, CDCI and DV
		m_iType = DATA_TYPE_IDAT;

		if (OMFFileRev == kOmfRev2x) {
			vMediaIDProperty = OMIDATImageData;
			omfiDatakindLookup(OMFFileHdl, "omfi:data:Picture", &vMediaDatakind, &OMFError );
		} else {
			strcat(propName, "IDAT");
			strcat(propName, ":ImageData");
		}

		bReadMedia = true;
		bForceUseDataValue = true;
		vMediaObject = obj;
	} else if (strncmp(objClass, "JPEG", 4) == 0) {
		m_iType = DATA_TYPE_JPEG;

		if (OMFFileRev == kOmfRev2x) {
			vMediaIDProperty = OMIDATImageData;
			omfiDatakindLookup(OMFFileHdl, "omfi:data:Picture", &vMediaDatakind, &OMFError );
		} else {
			strcat(propName, "IDAT");
			strcat(propName, ":ImageData");
		}

		bReadMedia = true;
		bForceUseDataValue = true;
		vMediaObject = obj;
		vMediaIDProperty = OMIDATImageData;

		omfUniqueName_t tmpPropName;
		omfIterHdl_t propIter = NULL;
		omfProperty_t tmpProp;
		omfType_t tmpType;

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		omfErr_t err = omfiGetNextProperty(propIter, obj, &tmpProp, &tmpType);
		while (OM_ERR_NONE == err && tmpProp)
		{
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);
				if (bInfo) fprintf(infoFile, "\t%s\n", tmpPropName);
			if (strcmp(tmpPropName, "OMFI:JPEG:FrameIndex") == 0)
			{
				OMFError = OMGetPropertyFileOffset(OMFFileHdl, obj, tmpProp, 0,
					tmpType, &FrameIndexOffset);
				FrameIndexOffset += 2;
				//if (bInfo) fprintf(infoFile, "\t\t%d\n", FrameIndexOffset);
				if (!bInfo) break;
			}
			err = omfiGetNextProperty(propIter, obj, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);

	} else if (strncmp(objClass, "MPEG", 4) == 0) {
		m_iType = DATA_TYPE_MPG2;

		if (OMFFileRev == kOmfRev2x) {
			vMediaIDProperty = OMIDATImageData;
			omfiDatakindLookup(OMFFileHdl, "omfi:data:Picture", &vMediaDatakind, &OMFError );
		} else {
			strcat(propName, "IDAT");
			strcat(propName, ":ImageData");
		}

		bReadMedia = true;
		bForceUseDataValue = true;
		vMediaObject = obj;

		omfUniqueName_t tmpPropName;
		omfIterHdl_t propIter = NULL;
		omfProperty_t tmpProp;
		omfType_t tmpType;

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		omfErr_t err = omfiGetNextProperty(propIter, obj, &tmpProp, &tmpType);
		while (OM_ERR_NONE == err && tmpProp)
		{
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);
			if (bInfo) fprintf(infoFile, "\t%s\n", tmpPropName);
			if (strcmp(tmpPropName, "OMFI:MPEG:FrameIndex") == 0)
			{
				OMFError = OMGetPropertyFileOffset(OMFFileHdl, obj, tmpProp, 0,
					tmpType, &FrameIndexOffset);
				FrameIndexOffset += 2;
				//if (bInfo) fprintf(infoFile, "\t\t%d\n", FrameIndexOffset);
				if (!bInfo) break;
			}
			err = omfiGetNextProperty(propIter, obj, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	} else if (strncmp(objClass, "AIFC", 4) == 0) {
		m_iType = DATA_TYPE_AIFF;

		//Cannot handle AIFF data
		/*
		if (OMFFileRev == kOmfRev2x) {
			aMediaIDProperty = OMAIFCData;
			omfiDatakindLookup(OMFFileHdl, "omfi:data:Sound", &aMediaDatakind, &OMFError );
		} else {
			strncat(propName, objClass, (size_t)4);
			strcat(propName, ":Data");
		}

		bReadMedia = true;
		aMediaObject = obj;
		*/
	} else if (strncmp(objClass, "WAVE", 4) == 0 ) {
		m_iType = DATA_TYPE_WAV;

		//Cannot handle WAV data
		/*
		if (OMFFileRev == kOmfRev2x) {
			aMediaIDProperty = OMWAVEData;
			omfiDatakindLookup(OMFFileHdl, "omfi:data:Sound", &aMediaDatakind, &OMFError );
		} else {
			strncat(propName, objClass, (size_t)4);
			strcat(propName, ":Data");
		}

		bReadMedia = true;
		aMediaObject = obj;
		*/
	} else {
		m_iType = DATA_TYPE_UNKNOWN;
	}

	strcpy(IDATpropName, propName);

	return m_iType;
}

int COmfMovieDec::ReadOMFMobs()
{
	omfIterHdl_t OMFMobIter = NULL;
	omfMobObj_t OMFMob;

	OMFError = omfiGetNumMobs(OMFFileHdl, kAllMob, &mOMFNumMobs);

	if (bInfo) fprintf(infoFile, "Mob Count: %d\n", mOMFNumMobs);

	OMFError = omfiIteratorAlloc(OMFFileHdl, &OMFMobIter);

	for (int i = 0; i < mOMFNumMobs; i++)
	{
		OMFError = omfiGetNextMob(OMFMobIter, NULL, &OMFMob);

		if ( omfiIsACompositionMob(OMFFileHdl, OMFMob, &OMFError) ) {
			ReadOMFCompositionMob(OMFMob);
		} else if ( omfiIsAMasterMob(OMFFileHdl, OMFMob, &OMFError) ) {
			ReadOMFMasterMob(OMFMob);
		} else if ( omfiIsAFileMob(OMFFileHdl, OMFMob, &OMFError) ) {
			if ( omfiIsAFileMob(OMFFileHdl, OMFMob, &OMFError) )
				ReadOMFFileMob(OMFMob);
			else if ( omfiIsATapeMob(OMFFileHdl, OMFMob, &OMFError) )
				ReadOMFTapeMob(OMFMob);
			else if ( omfiIsAFilmMob(OMFFileHdl, OMFMob, &OMFError) )
				ReadOMFFilmMob(OMFMob);
			else
				ReadOMFUnknownSourceMob(OMFMob);

			if (bInfo) {
				omfIterHdl_t locatorIter;
				omfObject_t OMFLocator;

				omfInt32 numLocators = 1;
				//OMFError = omfmMobGetNumLocators(OMFFileHdl, OMFMob, &numLocators);
				fprintf(infoFile, "\t  Locator Count: %d\n", numLocators);

				if (numLocators > 0) {
					omfIterHdl_t locIter = NULL;
					omfObject_t OMFLocator = NULL;
					omfClassID_t type;
					char locatorPath[128];

					OMFError = omfiIteratorAlloc(OMFFileHdl, &locIter);
					OMFError = omfmMobGetNextLocator(locIter, OMFMob, &OMFLocator);
					while (OM_ERR_NONE == OMFError && locIter) {
						//OMFError = omfmWindowsLocatorGetInfo(OMFFileHdl, OMFLocator, MAX_PATH, tmpFileName);
						OMFError = omfmLocatorGetInfo(OMFFileHdl, OMFLocator, type, sizeof(locatorPath), locatorPath);
						if (OM_ERR_NONE == OMFError) {
							fprintf(infoFile, "\t\tLocator: %s\n", locatorPath);
						} else {
							fprintf(infoFile, "\t\tLocator Error: %s\n", omfsGetErrorString(OMFError));
						}
						OMFError = omfmMobGetNextLocator(locIter, OMFMob, &OMFLocator);
					}
					fprintf(infoFile, "\t\tLocator Error: %s\n", omfsGetErrorString(OMFError));
					OMFError = omfiIteratorDispose(OMFFileHdl, locIter);
				}
			}
		} else {
			if (bInfo) {
				omfProperty_t OMFPropertyID;
				char objClass[5];
				char objSuperClass[5];
				omfBool bFound = false;

				if (OMFFileRev == kOmfRev2x)
					OMFPropertyID = OMOOBJObjClass;
				else
					OMFPropertyID = OMObjID;

				memset(objClass, 0, sizeof(objClass));
				OMFError = omfsReadClassID(OMFFileHdl, OMFMob, OMFPropertyID, objClass);

				memset(objSuperClass, 0, sizeof(objSuperClass));
				OMFError = omfsClassFindSuperClass(OMFFileHdl, objClass, objSuperClass, &bFound);
				if (bFound)
					fprintf(infoFile, "\tUnknown Mob: %s:%s\n", objSuperClass, objClass);
				else
					fprintf(infoFile, "\tUnknown Mob: %s\n", objClass);
			}
		}

	}

	return 0;
}

omfErr_t COmfMovieDec::ReadOMFCompositionMob(omfObject_t OMFMob)
{
	if (bInfo) fprintf(infoFile, "\tComposition Mob\n");

	if (bInfo) {
		omfNumSlots_t numSlots;
		OMFObject = OMFMob;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	omfObject_t mediaDescriptor;
	OMFError = omfmMobGetMediaDescription(OMFFileHdl, OMFMob, &mediaDescriptor);

	if (bInfo && OMFError == OM_ERR_NONE) {
		omfNumSlots_t numSlots;
		OMFObject = mediaDescriptor;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	return OM_ERR_NONE;
}

omfErr_t COmfMovieDec::ReadOMFMasterMob(omfObject_t OMFMob)
{
	if (bInfo) fprintf(infoFile, "\tMaster Mob\n");

	if (bInfo) {
		omfNumSlots_t numSlots;
		OMFObject = OMFMob;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	omfObject_t mediaDescriptor;
	OMFError = omfmMobGetMediaDescription(OMFFileHdl, OMFMob, &mediaDescriptor);

	if (bInfo && OMFError == OM_ERR_NONE) {
		omfNumSlots_t numSlots;
		OMFObject = mediaDescriptor;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	return OM_ERR_NONE;
}

omfErr_t COmfMovieDec::ReadOMFFileMob(omfObject_t OMFMob)
{
	if (bInfo) fprintf(infoFile, "\tFile Mob\n");

	if (bInfo) {
		omfNumSlots_t numSlots;
		OMFObject = OMFMob;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	omfObject_t mediaDescriptor;
	OMFError = omfmMobGetMediaDescription(OMFFileHdl, OMFMob, &mediaDescriptor);

	if (bInfo && OMFError == OM_ERR_NONE) {
		omfNumSlots_t numSlots;
		OMFObject = mediaDescriptor;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	if ( omfsIsTypeOf(OMFFileHdl, mediaDescriptor, OMClassMDES, &OMFError) )
	{
		if (bInfo && infoFile) fprintf(infoFile, "\t\tOMClassMDES\n");
		if ( omfsIsTypeOf(OMFFileHdl, mediaDescriptor, OMClassMDFL, &OMFError) )
		{
			if (bInfo && infoFile) fprintf(infoFile, "\t\t\tOMClassMDFL\n");

			if ( omfsIsTypeOf(OMFFileHdl, mediaDescriptor, OMClassTIFD, &OMFError) )
			{
				if (bInfo && infoFile) fprintf(infoFile, "\t\t\t\tOMClassTIFD\n");

				omfUInt32 TIFDVersion=0;
				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, OMTIFDVersion, &TIFDVersion) != OM_ERR_NONE) {
					if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMTIFDVersion, (omfInt32 *)&TIFDVersion) != OM_ERR_NONE) {
						TIFDVersion = 0;
					}
				}

	/*//////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////
				omfUID_t mediaID;
				omfProperty_t OMFPropertyID;
				omfUID_t mobID;
				omfUniqueName_t propName;
				omfProperty_t idProperty;
				omfDDefObj_t datakind;
				char					summary[1024];	//!!!Fixed size //
				omfUInt32				bytesRead = 0;
				if (OMFFileRev == kOmfRev2x) {
					omfErr_t err;
					idProperty = OMIDATImageData;
					omfiDatakindLookup(OMFFileHdl, "omfi:data:Picture", &datakind, &err );
					OMFError = err;

					(void)omfsReadDataValue(OMFFileHdl, //
						mediaDescriptor,
						OMTIFDSummary,
						datakind,
						summary,
						0,
						sizeof(summary),
						&bytesRead);
				} else {
					strcat(propName, "IDAT");
					strcat(propName, ":ImageData");

					OMFError = omfsReadVarLenBytes(OMFFileHdl, //
						mediaDescriptor,
						OMTIFDSummary,
						0,
						sizeof(summary),
						summary,
						&bytesRead);
				}
	//////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////*/
			}
			else if ( omfsIsTypeOf(OMFFileHdl, mediaDescriptor, OMClassWAVD, &OMFError) )
			{
				if (bInfo && infoFile) fprintf(infoFile, "\t\t\t\tOMClassWAVD\n");
			}
			else if ( omfsIsTypeOf(OMFFileHdl, mediaDescriptor, OMClassAIFD, &OMFError) )
			{
				if (bInfo && infoFile) fprintf(infoFile, "\t\t\t\tOMClassAIFD\n");
			}
			else if ( omfsIsTypeOf(OMFFileHdl, mediaDescriptor, OMClassRGBA, &OMFError) )
			{
				if (bInfo && infoFile) fprintf(infoFile, "\t\t\t\tOMClassRGBA\n");
			}
			else if ( omfsIsTypeOf(OMFFileHdl, mediaDescriptor, OMClassCDCI, &OMFError) )
			{
				if (bInfo && infoFile) fprintf(infoFile, "\t\t\t\tOMClassCDCI\n");
				/*zeroPos = 0; fourPos = 0;
				StoredHeight = 0; StoredWidth = 0;
				DisplayHeight = 0; DisplayWidth = 0;
				SampledHeight = 0; SampledWidth = 0;
				XOffset = 0; YOffset = 0;
				alphaTransparency = 0;
				componentWidth = 0;
				horizontalSubsampling = 0;
				colorSiting = kCoSiting;
				blackReferenceLevel = 0;
				whiteReferenceLevel = 0;
				colorRange = 0;
				paddingBits = 0;*/

				omfUID_t sourceMobID;
				OMFError = omfiMobGetMobID(OMFFileHdl, OMFMob, &sourceMobID);
				if (OMFError == OM_ERR_NONE) {
					if ( (headMediaID.prefix == sourceMobID.prefix &&
							headMediaID.major == sourceMobID.major &&
							headMediaID.minor == sourceMobID.minor )
							||
							sourceMobID.prefix == -2 ) { //-2 seems to be from AFterFX files
						//sprintf(strStatus, "Same = %dx%dx%d",
						//	sourceMobID.prefix, sourceMobID.major, sourceMobID.minor);
					} else { //This is not the media in the Header so try again
						//sprintf(strStatus, "headMediaID = %dx%dx%d, sourceMobID = %dx%dx%d",
						//	headMediaID.prefix, headMediaID.major, headMediaID.minor,
						//	sourceMobID.prefix, sourceMobID.major, sourceMobID.minor);

						//If we get here, this means that there are multiple source mobs
						//and this omf file part of a multi-omf set and is NOT the 1st one
						//Set bNeedFrameOffset so that we look for the firstframeoffset
						//when parsing this omf
						bNeedFrameOffset = true;
						sprintf(strStatus, "Bad Media Index");
						return OM_ERR_IBADMEDIAINDEX;
					}
				} else {
					sprintf(strStatus, "Error Getting Media Index");
					return OMFError;
				}

				omfUniqueName_t tmpPropName;
				omfIterHdl_t propIter = NULL;
				omfProperty_t tmpProp;
				omfType_t tmpType;

				OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
				omfErr_t err = omfiGetNextProperty(propIter, mediaDescriptor, &tmpProp, &tmpType);
				while (OM_ERR_NONE == err && tmpProp)
				{
					OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);
					/*if (strcmp(tmpPropName, "OMFI:DIDD:VideoLineMap") == 0)
					{
						FrameIndexOffset = 0;
						OMFError = OMGetPropertyFileOffset(OMFFileHdl, mediaDescriptor, tmpProp, 0,
							tmpType, &FrameIndexOffset);
						break;
					}*/
					if (strcmp(tmpPropName, "OMFI:DIDD:FirstFrameOffset") == 0)	{ //kNeverSwab kSwabIfNeeded
						//OMFError = OMReadProp(OMFFileHdl, mediaDescriptor, tmpProp,
						//			zeroPos, kNeverSwab, OMUInt32,
						//			sizeof(omfUInt32), &m_iFirstFrameOffset);
						OMFError = OMGetPropertyFileOffset(OMFFileHdl, mediaDescriptor, tmpProp, 0,
							tmpType, (omfLength_t *)&m_iFirstFrameOffset);
						if (OMFError != OM_ERR_NONE) {
							m_iFirstFrameOffset = -1;
						}

					}/* else if (strcmp(tmpPropName, "OMFI:JPEG:FrameIndex") == 0)	{
						OMFError = OMGetPropertyFileOffset(OMFFileHdl, mediaDescriptor, tmpProp, 0,
							tmpType, &FrameIndexOffset);
						FrameIndexOffset += 2;
						break;
					}*/

					err = omfiGetNextProperty(propIter, mediaDescriptor, &tmpProp, &tmpType);
				}
				OMFError = omfiIteratorDispose(OMFFileHdl, propIter);

				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, OMDIDDStoredHeight, &StoredHeight) != OM_ERR_NONE) {
					if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDStoredHeight, (omfInt32 *)&StoredHeight) != OM_ERR_NONE) {
						StoredHeight = 0;
					}
				}
				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, OMDIDDStoredWidth, &StoredWidth) != OM_ERR_NONE) {
					if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDStoredWidth, (omfInt32 *)&StoredWidth) != OM_ERR_NONE) {
						StoredWidth = 0;
					}
				}

				//////////////////////////////////////////////////////////////////////////
				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, OMDIDDSampledHeight, &SampledHeight) != OM_ERR_NONE) {
					if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDSampledHeight, (omfInt32 *)&SampledHeight) != OM_ERR_NONE) {
						SampledHeight = 0;
					}
				}
				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, OMDIDDSampledWidth, &SampledWidth) != OM_ERR_NONE) {
					if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDSampledWidth, (omfInt32 *)&SampledWidth) != OM_ERR_NONE) {
						SampledWidth = 0;
					}
				}
				if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDSampledXOffset, &SampledXOffset) != OM_ERR_NONE)
					SampledXOffset = 0;
				if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDSampledYOffset, &SampledYOffset) != OM_ERR_NONE)
					SampledYOffset = 0;

				//////////////////////////////////////////////////////////////////////////
				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, OMDIDDDisplayHeight, &DisplayHeight) != OM_ERR_NONE) {
					if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDDisplayHeight, (omfInt32 *)&DisplayHeight) != OM_ERR_NONE) {
						DisplayHeight = 0;
					}
				}
				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, OMDIDDDisplayWidth, &DisplayWidth) != OM_ERR_NONE) {
					if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDDisplayWidth, (omfInt32 *)&DisplayWidth) != OM_ERR_NONE) {
						DisplayWidth = 0;
					}
				}
				if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDDisplayXOffset, &DisplayXOffset) != OM_ERR_NONE)
					DisplayXOffset = 0;
				if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDDisplayYOffset, &DisplayYOffset) != OM_ERR_NONE)
					DisplayYOffset = 0;

				//////////////////////////////////////////////////////////////////////////
				if (omfsReadLayoutType(OMFFileHdl, mediaDescriptor, OMDIDDFrameLayout, &frameLayout) != OM_ERR_NONE) {
					frameLayout = kNoLayout;
				} else {
					///    kNoLayout       - Default; not a valid value.
					///    kFullFrame      - Each frame contains a full sample in
					///                      progressive scan lines.
					///    kSeparateFields - Each sample consists of two fields, which
					///                      when interlaced produce a full sample.
					///    kOneField       - Each sample consists of two interlaced
					///                      fields, but only one field is stored in the
					///                      data stream.
					///    kMixedFields    - Similar to FullFrame, except the two fields
					///                      may have been sampled at different times.
				}

				//////////////////////////////////////////////////////////////////////////
				if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDAlphaTransparency, &alphaTransparency) != OM_ERR_NONE) {
					alphaTransparency = 0;
				} else {
				}

				//////////////////////////////////////////////////////////////////////////
				if (omfsReadRational(OMFFileHdl, mediaDescriptor, OMDIDDImageAspectRatio, (omfRational_t *)&aspectRatio) != OM_ERR_NONE)
				{
					aspectRatio.numerator = 0;
					aspectRatio.denominator = 1;
				}

				//////////////////////////////////////////////////////////////////////////
				if (omfsReadLength(OMFFileHdl, mediaDescriptor, OMMDFLLength,
						&frameCount) != OM_ERR_NONE)
					frameCount = 1;

				if (OMFFileRev == kOmfRev2x) {
					if (omfsReadRational(OMFFileHdl, mediaDescriptor, OMMDFLSampleRate, (omfRational_t *)&fps) != OM_ERR_NONE) {
						fps.numerator = 29970;
						fps.denominator = 1000;
					}
				} else {
					if (omfsReadExactEditRate(OMFFileHdl, mediaDescriptor, OMMDFLSampleRate, (omfRational_t *)&fps) != OM_ERR_NONE) {
						fps.numerator = 29970;
						fps.denominator = 1000;
					}
				}

				//omfmGetVideoTopField(omfMediaHdl_t media, omfFieldTop_t *type);

				//////////////////////////////////////////////////////////////////////////
				if (omfsReadInt32(OMFFileHdl, mediaDescriptor, OMDIDDFieldAlignment, &alignmentFactor) != OM_ERR_NONE)
					alignmentFactor = 0;

				//////////////////////////////////////////////////////////////////////////
				if (OMReadProp(OMFFileHdl, mediaDescriptor, OMDIDDVideoLineMap,
									zeroPos, kSwabIfNeeded, OMInt32Array,
									sizeof(omfInt32), &videoLineMap[0]) != OM_ERR_NONE)
					videoLineMap[0] = 9998;
				omfsCvtInt32toPosition(sizeof(omfInt32), fourPos);
				if (OMReadProp(OMFFileHdl, mediaDescriptor, OMDIDDVideoLineMap,
									fourPos, kSwabIfNeeded, OMInt32Array,
									sizeof(omfInt32), &videoLineMap[1]) != OM_ERR_NONE)
					videoLineMap[1] = 9999;

				//////////////////////////////////////////////////////////////////////////
				omfUID_t OMFCompress;
				omfUInt32 compLen = omfsLengthString(OMFFileHdl, mediaDescriptor, OMDIDDCompression);
				if ( compLen > 0 ) {
					char compress[64] = "";
					OMFError = omfsReadString(OMFFileHdl, mediaDescriptor, OMDIDDCompression, compress, compLen+1);
					if (strcmp(compress, "JFIF") == 0) {
						//OMFCompress = kAAFCodecJPEG;
						m_iCodec = CODEC_TYPE_JPEG;
						//vi.pixel_type = VideoInfo::CS_BGR24;

						////////////////////////////////////////////////////
							//Jpeg init
							// We set up the normal JPEG error routines, then override error_exit.
							cinfo.err = jpeg_std_error(&jerr.pub);
							jerr.pub.error_exit = my_error_exit;
							if (setjmp(jerr.setjmp_buffer)) {
								jpeg_destroy_decompress(&cinfo);
								if (bInfo && infoFile) {fclose(infoFile); infoFile = NULL;}
								sprintf(strStatus, "\nUnable to create jpeg decompression object\n");
								return OM_ERR_BADJPEGINFO;
							}

							// initialize the JPEG decompression object.
							jpeg_create_decompress(&cinfo);

							cinfo.src = &jsrc;
							// functions for managing jpeg lib's input buffer
							jsrc.init_source = init_source;
							jsrc.fill_input_buffer = fill_input_buffer;
							jsrc.skip_input_data = skip_input_data;
							jsrc.resync_to_restart = resync_to_restart;
							jsrc.term_source = term_source;

							int row_stride = StoredWidth * sizeof(uint8_t) * 3;
							// Allocate the jpeg output buffer
							rows = (uint8_t**) malloc(StoredHeight*sizeof(uint8_t*));
							for(int row = 0; row < StoredHeight; row++)
								rows[row] = (uint8_t *)malloc(row_stride);
						////////////////////////////////////////////////////
					} else if (strcmp(compress, "DV/C") == 0) {
						//Fix for DV Codec because it only has
						//info for Stored Height and Width
						if (DisplayHeight==0) {
							DisplayWidth = StoredWidth;
							DisplayHeight = StoredHeight;
							SampledWidth = StoredWidth;
							SampledHeight = StoredHeight;
						}
						if (StoredHeight == 240 || StoredHeight == 480)
							m_iCodec = CODEC_TYPE_DVC;
						else
							m_iCodec = CODEC_TYPE_DVCP;
					} else if (strcmp(compress, "AUNC") == 0) {
						m_iCodec = CODEC_TYPE_CDCI;
					} else if (strcmp(compress, "MPG2") == 0) {
						m_iCodec = CODEC_TYPE_MPG2;
						omfFile = fopen(FileName, "rb");
						fseek(omfFile, 0, SEEK_END);
						omfFileLength = ftell(omfFile);

						//Check to make sure the mpeg2 decoder is working, then close it
						//currently have to open and close it for each frame
						//when opening it only once here, the decode process is not working
						mpeg2decoder = mpeg2_init();
						if (mpeg2decoder == NULL) {
							if (bInfo && infoFile) {fclose(infoFile); infoFile = NULL;}
							sprintf(strStatus, "\nCould not allocate an mpeg2 decoder object.\n");
							return OM_ERR_BADJPEGINFO;
						}
						mpeg2_close(mpeg2decoder);
						mpeg2decoder = NULL;

						//mpeg2info = mpeg2_info(mpeg2decoder);
					} else {
						//UnRecognized Codec
						if (bInfo && infoFile) {fclose(infoFile);}
						sprintf(strStatus, "\nUnRecognized Codec: %s\n", compress);
						return OM_ERR_CODEC_INVALID;
					}
				}

				int row_stride;
				if (m_iCodec == CODEC_TYPE_DVC || m_iCodec == CODEC_TYPE_DVCP)
					row_stride = DisplayWidth; //YV12
				else
					row_stride = DisplayWidth * 2; //YUY2

				m_iDecompressFrameSize = DisplayHeight * row_stride;

				//////////////////////////////////////////////////////////////////////////
				if (omfsReadInt32(OMFFileHdl, mediaDescriptor, gpGlobals.omCDCIComponentWidth, &componentWidth) != OM_ERR_NONE)
					componentWidth = 0;
				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, gpGlobals.omCDCIHorizontalSubsampling, &horizontalSubsampling) != OM_ERR_NONE)
					horizontalSubsampling = 0;
				if (OMReadProp(OMFFileHdl, mediaDescriptor, gpGlobals.omCDCIHorizontalSubsampling,
									zeroPos, kSwabIfNeeded, OMColorSitingType,
									sizeof(colorSiting), (void *)&(colorSiting)) != OM_ERR_NONE)
					memset(&colorSiting, 0, sizeof(omfColorSiting_t));
				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, gpGlobals.omCDCIBlackReferenceLevel, &blackReferenceLevel) != OM_ERR_NONE)
					blackReferenceLevel = 0;
				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, gpGlobals.omCDCIWhiteReferenceLevel, &whiteReferenceLevel) != OM_ERR_NONE)
					whiteReferenceLevel = 255;
				if (omfsReadUInt32(OMFFileHdl, mediaDescriptor, gpGlobals.omCDCIColorRange, &colorRange) != OM_ERR_NONE)
					colorRange = 255;
				if (OMReadProp(OMFFileHdl, mediaDescriptor, gpGlobals.omCDCIPaddingBits,
									zeroPos, kSwabIfNeeded, OMInt16,
									sizeof(paddingBits), &paddingBits) != OM_ERR_NONE)
					paddingBits = 0;

				//////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////
				//////////////////////////////////////////////////////////////////////////

				//Found the correct video source mob
				//for now, exit
				//Need to add audio code
				bValidSourceMediaMob = true;
			} else {
				if (bInfo && infoFile) fprintf(infoFile, "\t\t\t\tUnRecognized MDFL Subclass\n");
			}
		} else if ( omfsIsTypeOf(OMFFileHdl, mediaDescriptor, OMClassMDFM, &OMFError) ){
			if (bInfo && infoFile) fprintf(infoFile, "\t\t\tOMClassMDFM\n");
		} else if ( omfsIsTypeOf(OMFFileHdl, mediaDescriptor, OMClassMDTP, &OMFError) ){
			if (bInfo && infoFile) fprintf(infoFile, "\t\t\tOMClassMDTP\n");
		} else {
			/*if (bInfo && infoFile) fprintf(infoFile, "\t\t\tUnRecognized MDES Subclass\n");
			omfProperty_t OMFPropertyID;
			char id[5];

			if (OMFFileRev == kOmfRev2x)
				OMFPropertyID = OMOOBJObjClass;
			else
				OMFPropertyID = OMObjID;

				OMFPropertyID = OMMDESMobKind;

			memset(id, 0, sizeof(id));
			OMFError = omfsReadClassID(OMFFileHdl, mediaDescriptor, OMFPropertyID, id);

			//OMWINLPathName
			omfString strOmf;
			if ((OMFError = omfsReadString(OMFFileHdl, mediaDescriptor, OMNETLURLString, strOmf, 32)) == OM_ERR_NONE) {
				if (bInfo) fprintf(infoFile, "OMNETLURLString %s", strOmf);
			} else {
				if (bInfo) fprintf(infoFile, "Failed OMNETLURLString %s", omfsGetErrorString(OMFError));
			}
			if ((OMFError = omfsReadString(OMFFileHdl, mediaDescriptor, OMTXTLName, strOmf, 32)) == OM_ERR_NONE) {
				if (bInfo) fprintf(infoFile, "OMTXTLName %s", strOmf);
			} else {
				if (bInfo) fprintf(infoFile, "Failed OMTXTLName %s", omfsGetErrorString(OMFError));
			}
			if ((OMFError = omfsReadString(OMFFileHdl, mediaDescriptor, OMWINLPathName, strOmf, 32)) == OM_ERR_NONE) {
				if (bInfo) fprintf(infoFile, "OMWINLPathName %s", strOmf);
			} else {
				if (bInfo) fprintf(infoFile, "Failed OMWINLPathName %s", omfsGetErrorString(OMFError));
			}
			if ((OMFError = omfsReadString(OMFFileHdl, mediaDescriptor, OMDOSLPathName, strOmf, 32)) == OM_ERR_NONE) {
				if (bInfo) fprintf(infoFile, "OMDOSLPathName %s", strOmf);
			} else {
				if (bInfo) fprintf(infoFile, "Failed OMDOSLPathName %s", omfsGetErrorString(OMFError));
			}

			omfUInt32 OffsetJpeg=0;
			if ((OMFError = omfsReadUInt32(OMFFileHdl, mediaDescriptor, OMJPEDOffsetToFrameIndexes, &OffsetJpeg)) == OM_ERR_NONE) {
				if (bInfo) fprintf(infoFile, "OMJPEDOffsetToFrameIndexes %s", strOmf);
			} else {
				if (bInfo) fprintf(infoFile, "Failed OMJPEDOffsetToFramesIndexes %s", omfsGetErrorString(OMFError));
			}*/
		}
	} else {
		if (bInfo && infoFile) fprintf(infoFile, "\tUnRecognized Source Mob Subclass\n");
	}

	return OM_ERR_NONE;
}

omfErr_t COmfMovieDec::ReadOMFTapeMob(omfObject_t OMFMob)
{
	if (bInfo) fprintf(infoFile, "\tTape Mob\n");

	if (bInfo) {
		omfNumSlots_t numSlots;
		OMFObject = OMFMob;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	omfObject_t mediaDescriptor;
	OMFError = omfmMobGetMediaDescription(OMFFileHdl, OMFMob, &mediaDescriptor);

	if (bInfo && OMFError == OM_ERR_NONE) {
		omfNumSlots_t numSlots;
		OMFObject = mediaDescriptor;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	return OM_ERR_NONE;
}

omfErr_t COmfMovieDec::ReadOMFFilmMob(omfObject_t OMFMob)
{
	if (bInfo) fprintf(infoFile, "\tFilm Mob\n");

	if (bInfo) {
		omfNumSlots_t numSlots;
		OMFObject = OMFMob;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	omfObject_t mediaDescriptor;
	OMFError = omfmMobGetMediaDescription(OMFFileHdl, OMFMob, &mediaDescriptor);

	if (bInfo && OMFError == OM_ERR_NONE) {
		omfNumSlots_t numSlots;
		OMFObject = mediaDescriptor;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	return OM_ERR_NONE;
}

omfErr_t COmfMovieDec::ReadOMFUnknownSourceMob(omfObject_t OMFMob)
{
	if (bInfo) fprintf(infoFile, "\tUnknown Source Mob\n");

	if (bInfo) {
		omfNumSlots_t numSlots;
		OMFObject = OMFMob;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	omfObject_t mediaDescriptor;
	OMFError = omfmMobGetMediaDescription(OMFFileHdl, OMFMob, &mediaDescriptor);

	if (bInfo && OMFError == OM_ERR_NONE) {
		omfNumSlots_t numSlots;
		OMFObject = mediaDescriptor;
		if (OM_ERR_NONE != omfiMobGetNumSlots(OMFFileHdl, OMFObject, &numSlots))
			numSlots = 0;
		fprintf(infoFile, "\t\tSlot Count: %d\n", numSlots);

		omfIterHdl_t propIter = NULL;
		omfUniqueName_t tmpPropName;
		omfProperty_t tmpProp;
		omfType_t tmpType;
		omfLength_t mPropOffset;
		omfProperty_t OMFPropertyID;

		char id[5];
		if (OMFFileRev == kOmfRev2x)
			OMFPropertyID = OMOOBJObjClass;
		else
			OMFPropertyID = OMObjID;

		memset(id, 0, sizeof(id));
		OMFError = omfsReadClassID(OMFFileHdl, OMFObject, OMFPropertyID, id);
		if (id)
			fprintf(infoFile, "\t\t%s\n", id);

		OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
		OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);

		while (OMFError == OM_ERR_NONE && tmpProp) {
			OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);

			mPropOffset = 0;
			OMFError = OMGetPropertyFileOffset(OMFFileHdl, OMFObject, tmpProp, 0,
				tmpType, &mPropOffset);

			//if (mPropOffset < 1000)
				fprintf(infoFile, "\t\t\t%s = %d\n", tmpPropName, mPropOffset);
			//else
			//	fprintf(infoFile, "\t\t\t%s = %X\n", tmpPropName, mPropOffset);

			/*OMFError = OMReadProp(OMFFileHdl, OMFObject, tmpProp,
						zeroPos, kNeverSwab, OMUInt32,
						sizeof(omfUInt32), &mPropOffset);
			OMFError = omfsReadUInt32(OMFFileHdl, OMFObject, tmpProp, &StoredHeight);
			fprintf(infoFile, "\t\t\t%s = %d\n", omfsGetErrorString(OMFError), StoredHeight);*/

			OMFError = omfiGetNextProperty(propIter, OMFObject, &tmpProp, &tmpType);
		}
		OMFError = omfiIteratorDispose(OMFFileHdl, propIter);
	}

	return OM_ERR_NONE;
}

bool COmfMovieDec::InitializeDataRead(omfUInt32 frameNum)
{
	// find out how big the data is
	if (m_iCodec == CODEC_TYPE_DVC) {
		numBytes = nBlockSize = 120000;
	} else if (m_iCodec == CODEC_TYPE_DVCP) {
		numBytes = nBlockSize = 144000;
	} else if (m_iCodec == CODEC_TYPE_MPG2) {
		numBytes = nBlockSize = 0;
	} else {
		//CDCI and JPEG
		if (OMFFileRev == kOmfRev2x) {
			numBytes = (omfUInt32)omfsLengthDataValue(OMFFileHdl, vMediaObject, vMediaIDProperty);
		} else {
			omfUniqueName_t tmpPropName;
			omfIterHdl_t propIter = NULL;
			omfProperty_t tmpProp;
			omfType_t tmpType;

			OMFError = omfiIteratorAlloc(OMFFileHdl, &propIter);
			omfErr_t err = omfiGetNextProperty(propIter, vMediaObject, &tmpProp, &tmpType);
			while (OM_ERR_NONE == err && tmpProp)
			{
				OMFError = omfiGetPropertyName(OMFFileHdl, tmpProp, OMUNIQUENAME_SIZE, tmpPropName);
				if (strcmp(tmpPropName, IDATpropName) == 0)
				{
					vMediaIDProperty = tmpProp;
					break;
				}
				err = omfiGetNextProperty(propIter, vMediaObject, &tmpProp, &tmpType);
			}
			OMFError = omfiIteratorDispose(OMFFileHdl, propIter);

			if (OMFFileRev == kOmfRev2x || bForceUseDataValue)
				numBytes = (omfUInt32)omfsLengthDataValue(OMFFileHdl, vMediaObject, vMediaIDProperty);
			else
				numBytes = (omfUInt32)omfsLengthVarLenBytes(OMFFileHdl, vMediaObject, vMediaIDProperty);
		}

		if (numBytes > (4 * StoredHeight * StoredWidth)) {
			if ( frameLayout != kSeparateFields )
				nBlockSize = (2 * StoredHeight * StoredWidth) + 4;
			else
				nBlockSize = (4 * StoredHeight * StoredWidth) + 8;
		} else {
			nBlockSize = numBytes;
		}
	}

	OMFOffset = 0;

	if (m_iCodec == CODEC_TYPE_JPEG) {
		if ( !ReadOMFFrameIndex() ) {
			sprintf(strStatus, "Cannot read Jpeg Frame Index List");
			return false;
		}
		OMFOffset = m_vFramePos[frameNum].field1;
	}

	return true;
}

bool COmfMovieDec::ReadOMFFrameIndex()
{
	byte *pBuffer;
	FramePos mFramePos;
	unsigned long foundPos = 0, fileLength = 0, curPos = 0, lastPos=0;
	unsigned long bufferLength = 2*1024*1024, bytesRead = 0, secondJpegPos = 0;
	unsigned long mJpegLength = 0;
	unsigned long m_lJpegCount = 0;

	if ( (omfFile = fopen(FileName, "rb")) == NULL ) {
		sprintf(strStatus, "Unable to open OMF file to read Jpeg Frame Index\n%s",
			FileName);
		return false;
	}

	fseek(omfFile, 0, SEEK_END);
	fileLength = ftell(omfFile);

	bufferLength = fileLength - FrameIndexOffset;

	pBuffer = new byte[bufferLength + 1];
//Read in begining of file, get 2nd jpeg location?
	fseek(omfFile, FrameIndexOffset, SEEK_SET);

	bytesRead = fread(pBuffer, sizeof(unsigned char), bufferLength, omfFile);
	fclose(omfFile);
	omfFile = NULL;

	curPos = 0;
	for (int i = 0; i < frameCount; i++, curPos+=4) {
		mFramePos.field1 = pBuffer[curPos]
			| (pBuffer[curPos+1] << 8)
			| (pBuffer[curPos+2] << 16)
			| (pBuffer[curPos+3] << 24);
		mFramePos.NextFrame = pBuffer[curPos+4]
			| (pBuffer[curPos+5] << 8)
			| (pBuffer[curPos+6] << 16)
			| (pBuffer[curPos+7] << 24);

		m_vFramePos.push_back(mFramePos);

		//if (bInfo) fprintf(infoFile, "pos = %d, field1 = %d, NextFrame = %d\n",
		//	curPos, mFramePos.field1, mFramePos.NextFrame);
	}

	if (bInfo) fprintf(infoFile, "1st JpegFrameIndex Read: %d\n", m_vFramePos[0].field1);

	if (pBuffer)
		delete [] pBuffer;

	return true;

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

//Manual way of finding jpeg indexes
/*
	fseek(omfFile, 0, SEEK_END);
	fileLength = ftell(omfFile);

	if (bufferLength > fileLength)
		bufferLength = fileLength;

	pBuffer = new byte[bufferLength + 1];
//Read in begining of file, get 2nd jpeg location?
	fseek(omfFile, -bufferLength, SEEK_END);

	bytesRead = fread(pBuffer, sizeof(unsigned char), bufferLength, omfFile);
	fclose(omfFile);
	omfFile = NULL;


	foundPos = Seek_Bytes(pBuffer, bytesRead, 0, 0xffd8ffe0, 4); //
	if (foundPos==0)
		if (bInfo) fprintf(infoFile, "Did not find jpeg ");
	while (foundPos > 0) {
		mJpegLength = ((pBuffer[foundPos-4+12] & 255) << 24)
			| ((pBuffer[foundPos-4+13] & 255) << 16)
			| ((pBuffer[foundPos-4+14] & 255) << 8)
			| (pBuffer[foundPos-4+15] & 255);

		curPos = foundPos - 4 + mJpegLength;
		lastPos = foundPos;

		//if (bInfo) fprintf(infoFile, "foundPos = %d, curPos=%d, mJpegLength=%d\n",
		//	foundPos, curPos, mJpegLength);

		foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, '', 4);
	}
	curPos -= 10000;
	lastPos = curPos;

	if (curPos > 0) {
		//for (;curPos < bytesRead; curPos++) {
		//	if (pBuffer[curPos] > 0)
		//		break;
		//}

		while (curPos < bytesRead && curPos > 0) {
			foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, SWAP_TWO(frameCount + 1), 2);

			if ( pBuffer[foundPos] == 0 && pBuffer[foundPos+1] == 2
					&& pBuffer[foundPos+2] == 0 && pBuffer[foundPos+3] == 0 )
				break;
			curPos = foundPos;
		}

		//Number of frames > 0xFFFF so the frameCount field is set to FFFF
		if (curPos == 0) {
			curPos = lastPos;
			while (curPos < bytesRead && curPos > 0) {
				foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, 0xFFFF, 2);

				if ( pBuffer[foundPos] == 0 && pBuffer[foundPos+1] == 2
						&& pBuffer[foundPos+2] == 0 && pBuffer[foundPos+3] == 0 )
					break;
				curPos = foundPos;
			}
		}

		//foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, frameCount + 1, 2);
		//if (foundPos == 0)
			//foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, SWAP_TWO((UINT16)frameCount + 1), 2);

		****start comment if (foundPos == 0)
			foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, SWAP_FOUR(frameCount + 1), 4);
		if (foundPos == 0)
			foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, frameCount + 1, 4);


		if (foundPos == 0)
			foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, SWAP_FOUR(frameCount), 4);
		if (foundPos == 0)
			foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, frameCount, 4);
		if (foundPos == 0)
			foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, frameCount, 2);
		if (foundPos == 0)
			foundPos = Seek_Bytes(pBuffer, bytesRead, curPos, SWAP_FOUR(frameCount), 2);*/
		/*if (foundPos == 0) {
		} else
		if (bInfo) fprintf(infoFile, "foundPos = %d, curPos=%d, bytesRead=%d, frameCount=%d",
			foundPos, curPos, bytesRead, frameCount);****close comment

		curPos = foundPos;
		for (int i = 0; i < frameCount; i++, curPos+=4) {
			****start comment mFramePos.field1 = ((pBuffer[curPos++] & 255) << 24)
				| ((pBuffer[curPos++] & 255) << 16)
				| ((pBuffer[curPos++] & 255) << 8)
				| (pBuffer[curPos++] & 255);
			mFramePos.NextFrame = ((pBuffer[curPos] & 255) << 24)
				| ((pBuffer[curPos+1] & 255) << 16)
				| ((pBuffer[curPos+2] & 255) << 8)
				| (pBuffer[curPos+3] & 255);****close comment
			mFramePos.field1 = pBuffer[curPos]
				| (pBuffer[curPos+1] << 8)
				| (pBuffer[curPos+2] << 16)
				| (pBuffer[curPos+3] << 24);
			mFramePos.NextFrame = pBuffer[curPos+4]
				| (pBuffer[curPos+5] << 8)
				| (pBuffer[curPos+6] << 16)
				| (pBuffer[curPos+7] << 24);

			m_vFramePos.push_back(mFramePos);

			//if (bInfo) fprintf(infoFile, "pos = %d, field1 = %d, NextFrame = %d\n",
			//	curPos, mFramePos.field1, mFramePos.NextFrame);
		}

		//if (bInfo) fprintf(infoFile, "m_lJpegCount at %d\n", m_lJpegCount);
	}
	****start comment
		if (bytePos + mFieldLength1 >= numBytesRead - mUseHeaderLength - 15) {
			curFrame--;
			delete [] pTempData;
			break;
		}

		if ( frameLayout == kSeparateFields ) {
			mFieldLength2 = ((pTempData[bytePos+mUseHeaderLength+12+mFieldLength1] & 255) << 24)
				| ((pTempData[bytePos+mUseHeaderLength+13+mFieldLength1] & 255) << 16)
				| ((pTempData[bytePos+mUseHeaderLength+14+mFieldLength1] & 255) << 8)
				| (pTempData[bytePos+mUseHeaderLength+15+mFieldLength1] & 255);

				m_FramePos.field1 = OMFOffset + bytePos + mUseHeaderLength;
				//m_FramePos.field2 = OMFOffset + bytePos + mUseHeaderLength + mFieldLength1;
				m_FramePos.field2 = m_FramePos.field1 + mFieldLength1;
				m_FramePos.NextFrame = m_FramePos.field2 + mFieldLength2;
		} else {
			mFieldLength2 = 0;
			m_FramePos.field1 = OMFOffset + bytePos + mUseHeaderLength;
			//m_FramePos.field2 = OMFOffset + bytePos + mUseHeaderLength + mFieldLength1;
			m_FramePos.field2 = m_FramePos.field1;
			m_FramePos.NextFrame = m_FramePos.field1 + mFieldLength1;
		}

		m_vFramePos.push_back(m_FramePos);

		bytePos += mFieldLength1 + mFieldLength2;****close comment

	fclose(omfFile);
	omfFile = NULL;
	return true;
	*/
}

int COmfMovieDec::jpeg_Decompress(char *jpgData, uint8_t **outputRows, long jpgSize, int row_stride, J_COLOR_SPACE colorModel)
{
	int rowsRead = 0;
	//JSAMPARRAY jpgBuffer;

	/*
	// We set up the normal JPEG error routines, then override error_exit.
	cinfo.err = jpeg_std_error(&jerr.pub);
	jerr.pub.error_exit = my_error_exit;
	if (setjmp(jerr.setjmp_buffer)) {
		jpeg_destroy_decompress(&cinfo);
		sprintf(strStatus, "\nUnable to create jpeg decompression object\n");
		return 0;
	}

	// Now we can initialize the JPEG decompression object.
	jpeg_create_decompress(&cinfo);

	// Step 2: specify data source (eg, a file)
	//jpeg_stdio_src(&cinfo, input_file);
	cinfo.src = &jsrc;
	// functions for managing jpeg lib's input buffer
	jsrc.init_source = init_source;
	jsrc.fill_input_buffer = fill_input_buffer;
	jsrc.skip_input_data = skip_input_data;
	jsrc.resync_to_restart = resync_to_restart;
	jsrc.term_source = term_source;

	*/

	jsrc.next_input_byte = (byte *)jpgData; //framepointer;
	jsrc.bytes_in_buffer = jpgSize; // count

	jpeg_read_header(&cinfo, true);

	cinfo.do_fancy_upsampling = FALSE; //If true, this causes some slight color shifts 
	cinfo.do_block_smoothing = FALSE;
	cinfo.dct_method = JDCT_ISLOW; //JDCT_IFAST JDCT_ISLOW JDCT_FLOAT
	//cinfo.dither_mode = JDITHER_ORDERED;
	//cinfo.raw_data_out = TRUE;
	cinfo.out_color_space = colorModel; //JCS_YCbCr JCS_RGB

	//if (bInfo) sprintf(infoFile, "image_width=%d, image_height=%d, output_components=%d, size=%d\n",
	//	cinfo.image_width, cinfo.image_height, cinfo.output_components, jpgSize);

	(void) jpeg_start_decompress(&cinfo);

	//int row_stride = cinfo.output_width * cinfo.output_components;

	//if (bInfo) sprintf(infoFile, "output_height=%d, output_height=%d, output_components=%d, size=%d, row_stride=%d\n",
		//cinfo.output_width, cinfo.output_height, cinfo.output_components, jpgSize, row_stride);

	// Read scanlines one by one into output buffer
	for (int i = 0; i < cinfo.output_height; i++) {
		rowsRead += jpeg_read_scanlines( &cinfo, &outputRows[i], 1);
	}

	row_stride = cinfo.output_width * cinfo.output_components;

	jpeg_finish_decompress(&cinfo);

	//Send abort command so we can reuse the jpeg object
	jpeg_abort_decompress(&cinfo);

	return rowsRead;
}

bool COmfMovieDec::ReadOMFData(
	omfUInt32 frameNum, char *pBuffer, size_t *bufSize1, size_t *bufSize2)
{
	if (frameNum >= frameCount) {
		sprintf(strStatus, "Requested frame %d is greater than Framecount %d",
			frameNum, frameCount);
		return false;
	}

	char *compressedData;
	omfUInt32 m_Pos = 0, mUseHeaderLength = 0;
	omfUInt32 mTempUint, bytePos = 0;

	omfUInt32 mFieldLength1, mFieldLength2;

	if (bFirstTime) {
		if (!InitializeDataRead(frameNum))
			return false;
	}

	if (m_iCodec != CODEC_TYPE_JPEG) {
		OMFOffset = frameNum * nBlockSize;// + m_iFirstFrameOffset;
		if (!bFirstTime)
			OMFOffset += m_iFirstFrameOffset;
	} else if (m_vFramePos.size() > 0) {
		OMFOffset = m_vFramePos[frameNum].field1;
	} else {
		sprintf(strStatus, "Cannot read Jpeg Frame Index List");
		return false;
	}

	mFieldLength1 = 0;
	mFieldLength2 = 0;

	compressedData = new char[nBlockSize+1];

ReadFrameData:
	if (m_iCodec < CODEC_TYPE_MPG2) {
		//uncompressed, dv, jpeg
		if (OMFFileRev == kOmfRev2x) {
			//numBytes = (omfUInt32)omfsLengthDataValue(OMFFileHdl, vMediaObject, vMediaIDProperty);
			OMFError = omfsReadDataValue( OMFFileHdl,
												vMediaObject,
												vMediaIDProperty,
												vMediaDatakind,
												(omfDataValue_t)compressedData,
												OMFOffset,
												nBlockSize,
												&numBytesRead);
			//if (bInfo) fprintf(infoFile, "omfsReadDataValue OMFError=%d, numBytes=%d, OMFOffset=%d, Blocksize=%d, bytesRead=%d\n",
			//	OMFError, numBytes, OMFOffset, nBlockSize, numBytesRead);
		} else {
			if(bForceUseDataValue) {
				OMFError = OMReadProp(OMFFileHdl, vMediaObject, vMediaIDProperty, OMFOffset, kNeverSwab,
									OMDataValue, nBlockSize, compressedData);
				numBytesRead = nBlockSize;
				//if (bInfo) fprintf(infoFile "m_iFirstFrameOffset=%d, OMReadProp OMFError=%d, numBytes=%d, OMFOffset=%d, Blocksize=%d, bytesRead=%d\n",
				//	m_iFirstFrameOffset, OMFError, numBytes, OMFOffset, nBlockSize, numBytesRead);
			} else {
				OMFError = omfsReadVarLenBytes(OMFFileHdl,
												vMediaObject,
												vMediaIDProperty,
												OMFOffset,
												nBlockSize,
												compressedData,
												&numBytesRead);
				//if (bInfo) fprintf(infoFile, "omfsReadVarLenBytes OMFError=%d, numBytes=%d, OMFOffset=%d, Blocksize=%d, bytesRead=%d\n",
				//	OMFError, numBytes, OMFOffset, nBlockSize, numBytesRead);
			}
		}

		//bFirstTime = false;
		//If this is the first time through, check to see if the first frame offset matches
		if (!bNeedFrameOffset) {
			//This means there was only one Source Mob so all data should be in this omf
			//Do not need to check for fileoffset
			bFirstTime = false;
			m_iFirstFrameOffset = 0;
		} else if (bFirstTime && m_iFirstFrameOffset != -1 && m_iFirstFrameOffset != 0) {
			//Positive FrameOffset was found using OMFI:DIDD:FirstFrameOffset property
			//Don't need to manually find it
			bFirstTime = false;
			OMFOffset = frameNum * nBlockSize + m_iFirstFrameOffset;
			goto ReadFrameData;
		}

		//Manually find the first frame offset
		//This is used to read an OMF that is part of a multi OMF set
		//this method is not fully working
		if (bFirstTime) {
			bFirstTime = false;
			byte *tmpData = new byte[1024*1024*2 + 1];
			int bytesRead = 0;
			int pos1 = 1, pos2 = 0;
			omfFile = fopen(FileName, "rb");
			bytesRead = fread(tmpData, sizeof(unsigned char), 1024*1024*2, omfFile);

			if (m_iCodec == CODEC_TYPE_DVC || m_iCodec == CODEC_TYPE_DVCP) {
				m_iFirstFrameOffset = 0;

				if (tmpData[0] == 0x1F
						&& (tmpData[1] == 0x07 || tmpData[1] == 0x07)
						&& (tmpData[2] == 0x00 || tmpData[2] == 0x00)
						&& (tmpData[3] == 0x3F || tmpData[3] == 0x3F))
					m_iFirstFrameOffset = 0;
				else {
					// 0x01800180 0x10801080 0x017F0180 0x107F1080
					// 0x80018001 0x80108010 0x80017F01 0x80107F10 //0xD9FFFFFF
					while (pos1 > 0) {
						if (m_iCodec == CODEC_TYPE_DVC) //NTSC
							pos1 = Seek_Bytes(tmpData, bytesRead, pos2, 0x1F07003F, 4);
						else //PAL
							pos1 = Seek_Bytes(tmpData, bytesRead, pos2, 0x1F0700BF, 4);
						if (pos1 + 3 > bytesRead)
							break;
						else if (pos1 > 0) {
							if (tmpData[pos1] == 0x68 || tmpData[pos1] == 0xF8
									&& (tmpData[pos1+1] == 0x78 || tmpData[pos1+1] == 0x78)
									&& (tmpData[pos1+2] == 0x78 || tmpData[pos1+2] == 0x78)
									&& (tmpData[pos1+3] == 0x78 || tmpData[pos1+3] == 0x78)) {
								m_iFirstFrameOffset = pos1 - 4;
								break;
							}
						}
						pos2 = pos1;
						//if (bInfo) fprintf(infoFile, "Found = %d\n", pos1);
					}

					/*pos2 = Seek_Bytes(tmpData, bytesRead, 0, 0x017F0180, 4);
					if (pos2 == 0)
						pos2 = Seek_Bytes(tmpData, bytesRead, 0, 0x107F1080, 4);

					if (pos1 == 0 && pos2 == 0)
						m_iFirstFrameOffset = 0;
					else
						m_iFirstFrameOffset = (pos1 < pos2) ? pos1 : pos2;*/
				}
				//if (bInfo) fprintf(infoFile, "First Frame = %d, offset = %d\n", m_iFirstFrameOffset, OMFOffset);
			} else if (m_iCodec == CODEC_TYPE_JPEG) {
				//Jpeg
				//Haven't written this code yet...
				m_iFirstFrameOffset = 0;
			} else {
				//Uncompressed
				m_iFirstFrameOffset = 0;

				if (tmpData[0] == 0x80
						&& (tmpData[1] == 0x01 || tmpData[1] == 0x10)
						&& (tmpData[2] == 0x80 || tmpData[2] == 0x7F)
						&& (tmpData[3] == 0x01 || tmpData[3] == 0x10))
					m_iFirstFrameOffset = 0;
				else {
					// 0x01800180 0x10801080 0x017F0180 0x107F1080
					// 0x80018001 0x80108010 0x80017F01 0x80107F10 //0xD9FFFFFF
					while (pos1 > 0) {
						pos1 = Seek_Bytes(tmpData, bytesRead, pos2, 0xFFFFFFD9, 4);
						if (pos1 + 3 > bytesRead)
							break;
						else if (pos1 > 0) {
							if (tmpData[pos1] == 0x80
									&& (tmpData[pos1+1] == 0x01 || tmpData[pos1+1] == 0x10)
									&& (tmpData[pos1+2] == 0x80 || tmpData[pos1+2] == 0x7F)
									&& (tmpData[pos1+3] == 0x01 || tmpData[pos1+3] == 0x10)) {
								m_iFirstFrameOffset = pos1;
								break;
							}
						}
						pos2 = pos1;
						//if (bInfo) fprintf(infoFile, "Found = %d\n", pos1);
					}

					/*pos2 = Seek_Bytes(tmpData, bytesRead, 0, 0x017F0180, 4);
					if (pos2 == 0)
						pos2 = Seek_Bytes(tmpData, bytesRead, 0, 0x107F1080, 4);

					if (pos1 == 0 && pos2 == 0)
						m_iFirstFrameOffset = 0;
					else
						m_iFirstFrameOffset = (pos1 < pos2) ? pos1 : pos2;*/
				}
				//if (bInfo) fprintf(infoFile, "First Frame = %d, offset = %d\n", m_iFirstFrameOffset, OMFOffset);
			}


			if (m_iFirstFrameOffset > 0) {
				//if (bInfo) fprintf(infoFile, "First Frame = %d, offset = %d\n", m_iFirstFrameOffset, OMFOffset);

				//Search for "omfi" to make sure the offset isn't because of header data
				//But what happens if there is header data and an offset???
				//or "omfi" text does not appear = this happens with OMF 1.0
				pos1 = Seek_Bytes(tmpData, bytesRead, 0, 0x6f6d6669, 4); //"omfi"
				delete [] tmpData;
				fclose(omfFile);
				omfFile = NULL;
				//if (pos1 == 0 || pos1 > m_iFirstFrameOffset) {
				if (pos1 > 0 && pos1 < m_iFirstFrameOffset) {
					OMFOffset = frameNum * nBlockSize + m_iFirstFrameOffset;
					goto ReadFrameData;
				} else {
					m_iFirstFrameOffset = 0;
				}
			} else {
				delete [] tmpData;
				fclose(omfFile);
				omfFile = NULL;
			}
			//else m_iFirstFrameOffset = 0;
		}
	} else { //Mpeg2 File
		//Data for an mpeg2 file is read with fopen and fread, not the standard OMF routines
		bFirstTime = false;
		m_iFirstFrameOffset = 0;
		numBytesRead = 20;
	}

	if (m_iCodec == CODEC_TYPE_JPEG) {
		//If starting from beginning skip 512 byte header
		if (OMFOffset == 0)
			mUseHeaderLength = 512;
		else
			mUseHeaderLength = 0;

		/////////////////////////////////////////////////////////////
		mFieldLength1 = ((compressedData[mUseHeaderLength+12] & 255) << 24)
			| ((compressedData[mUseHeaderLength+13] & 255) << 16)
			| ((compressedData[mUseHeaderLength+14] & 255) << 8)
			| (compressedData[mUseHeaderLength+15] & 255);

		//if (bInfo) fprintf(infoFile, "OMFOffset: %d, vectorField1 = %d, mFieldLength1: %d, numBytesRead: %d, datalength: %d\n",
		//	OMFOffset, (m_vFramePos[frameNum]).field1, mFieldLength1, numBytesRead, strlen(compressedData));

		/////////////////////////////////////////////////////////////
		if ( frameLayout == kSeparateFields ) {
			mFieldLength2 = ((compressedData[mUseHeaderLength+12+mFieldLength1] & 255) << 24)
				| ((compressedData[mUseHeaderLength+13+mFieldLength1] & 255) << 16)
				| ((compressedData[mUseHeaderLength+14+mFieldLength1] & 255) << 8)
				| (compressedData[mUseHeaderLength+15+mFieldLength1] & 255);

				//if (m_vFramePos.size()==0 || bSequential || bAddVector) {
					/*m_FramePos.field1 = OMFOffset + bytePos + mUseHeaderLength;
					m_FramePos.field2 = OMFOffset + bytePos + mUseHeaderLength + mFieldLength1;*/

					m_FramePos.field1 = OMFOffset + bytePos + mUseHeaderLength;
					m_FramePos.field2 = m_FramePos.field1 + mFieldLength1;
					m_FramePos.NextFrame = m_FramePos.field2 + mFieldLength2;

					//m_vFramePos.push_back(m_FramePos);
					(m_vFramePos[frameNum]).field2 = m_FramePos.field2;
			} else {
			//if (m_vFramePos.size()==0 || bSequential || bAddVector) {
				mFieldLength2 = 0;
				m_FramePos.field1 = OMFOffset + bytePos + mUseHeaderLength;
				//m_FramePos.field2 = OMFOffset + bytePos + mUseHeaderLength + mFieldLength1;
				m_FramePos.field2 = m_FramePos.field1;
				m_FramePos.NextFrame = m_FramePos.field1 + mFieldLength1;

				//m_vFramePos.push_back(m_FramePos);
				(m_vFramePos[frameNum]).field2 = m_FramePos.field2;
			//}
		}

		OMFOffset = OMFOffset + mFieldLength1 + mFieldLength2 + mUseHeaderLength;

		//if (bInfo) fprintf(infoFile, "OMFOffset=%d, mFieldLength1=%d, mFieldLength2=%d\n",
		//	OMFOffset, mFieldLength1, mFieldLength2);

	} else {
		//Uncompressed
	}

	size_t mSize = *bufSize1;
	if (true) { //create a variable so we can return compressed data or uncompressed data
		//decompress and return data
		if (m_iCodec == CODEC_TYPE_RGBA || m_iCodec == CODEC_TYPE_CDCI) {
			int mOffset, start, row_stride, dummy;
			//if YUY2
				row_stride = DisplayWidth * 2;
			if ( frameLayout != kSeparateFields ) {
				//progressive
				//mOffset = DisplayYOffset;
				mOffset = StoredHeight - DisplayHeight;

				start = 0;
				for (int h = 0; h < DisplayHeight + mOffset; h++) {
					if (h >= mOffset)
					{
						for (int w = 0; w < row_stride; w += 4) {
							dummy = start + w;
							*(pBuffer + w) = compressedData[dummy + 1];
							*(pBuffer + w + 1) = compressedData[dummy];
							*(pBuffer + w + 2) = compressedData[dummy + 3];
							*(pBuffer + w + 3) = compressedData[dummy + 2];
						}
						pBuffer += row_stride;
					}
					start += row_stride;
				}
			} else {
				char *fieldData;
				//Interlaced
				//Upper Field
				mOffset = DisplayYOffset + StoredHeight;
				//mOffset = StoredHeight - DisplayHeight + StoredHeight;

				fieldData = pBuffer;
				if (m_iFieldOrder == 1 || ( m_iFieldOrder == -1 && DisplayHeight == 288) )
					fieldData += row_stride;
				/*if (m_iFieldOrder == 0 || ( m_iFieldOrder == -1 && DisplayHeight != 288) )
					fieldData = pBuffer;
				else
					fieldData = pBuffer + row_stride;  // set dstp to second line*/
				start = 4;
				for (int h = 0; h < DisplayHeight + mOffset; h++) {
					if (h >= mOffset)
					{
						for (int w = 0; w < row_stride; w += 4) {
							dummy = start + w;
							*(fieldData + w) = compressedData[dummy + 1];
							*(fieldData + w + 1) = compressedData[dummy];
							*(fieldData + w + 2) = compressedData[dummy + 3];
							*(fieldData + w + 3) = compressedData[dummy + 2];
						}
						fieldData += row_stride * 2;
					}
					start += row_stride;
				}

				//Lower Field
				mOffset = DisplayYOffset;
				//mOffset = StoredHeight - DisplayHeight;

				fieldData = pBuffer;
				if (m_iFieldOrder == 0 || ( m_iFieldOrder == -1 && DisplayHeight != 288) )
					fieldData += row_stride;
				/*if (m_iFieldOrder == 0 || ( m_iFieldOrder == -1 && DisplayHeight != 288) )
					fieldData = pBuffer + row_stride;  // set dstp to second line
				else
					fieldData = pBuffer;*/

				start = 0;
				for (int h = 0; h < DisplayHeight + mOffset; h++) {
					if (h >= mOffset)
					{
						for (int w = 0; w < row_stride; w += 4) {
							dummy = start + w;
							*(fieldData + w) = compressedData[dummy + 1];
							*(fieldData + w + 1) = compressedData[dummy];
							*(fieldData + w + 2) = compressedData[dummy + 3];
							*(fieldData + w + 3) = compressedData[dummy + 2];
						}
						fieldData += row_stride * 2;
					}
					start += row_stride;
				}
			}
		} else if (m_iCodec == CODEC_TYPE_DVC) {
			decode_NTSC_DVSD( (uint8_t *)compressedData,
				(uint32_t *)pBuffer, COLORFORMAT_YUY2 );
		} else if (m_iCodec == CODEC_TYPE_DVCP) {
			decode_PAL_DVSD( (uint8_t *)compressedData,
				(uint32_t *)pBuffer, COLORFORMAT_YUY2 );
		} else if (m_iCodec == CODEC_TYPE_JPEG) {
			char *pData;
			int jpgDataSize, mSkipBytes = 0;

			if (m_vFramePos.size() > 0) {
				if (m_vFramePos[frameNum].field1 == m_vFramePos[frameNum].field2)
					jpgDataSize = m_vFramePos[frameNum].NextFrame - m_vFramePos[frameNum].field1;
				else
					jpgDataSize = m_vFramePos[frameNum].field2 - m_vFramePos[frameNum].field1;
			} else {
			}

			pData = &compressedData[mSkipBytes];

			int row, row_stride, curSample = 0;
			row_stride = StoredWidth * sizeof(uint8_t) * 3;
			// Allocate the output buffer
			/*uint8_t** rows = (uint8_t**) malloc(StoredHeight*sizeof(uint8_t*));
			for(row = 0; row < StoredHeight; row++)
				rows[row] = (uint8_t *)malloc(row_stride);*/

			 //JCS_YCbCr JCS_RGB
			if (jpeg_Decompress(pData, rows, jpgDataSize, row_stride, JCS_YCbCr) == 0)
				return false;

			//if YUY2
				row_stride = DisplayWidth * 2;

			if ( frameLayout == kSeparateFields ) {
				char *fieldData;
				if (m_iFieldOrder == 0 || ( m_iFieldOrder == -1 && DisplayHeight != 288) )
					fieldData = pBuffer + row_stride;
				else
					fieldData = pBuffer;

				//for(row=StoredHeight - DisplayHeight;row<StoredHeight;row++) {
				for(row = DisplayYOffset; row < StoredHeight; row++) {
					for ( int h = 0, i = 0; h < StoredWidth / 2; h++, i+=6, curSample+=4 ) {
						//dstp[curSample] = rows[row][i*3];

						// YUYV = YUY2     y0u0y1v0 y2u2y3v2
						fieldData[curSample]   = rows[row][i];       // y0
						fieldData[curSample+1] = rows[row][i + 1];   // u0
						fieldData[curSample+2] = rows[row][i + 3];   // y1
						fieldData[curSample+3] = rows[row][i + 2];   // v0

						// UYVY
						/*dstp[curSample]   = rows[row][i*3 + 1];
						dstp[curSample+1] = rows[row][i*3];
						dstp[curSample+2] = rows[row][i*3 + 2];
						dstp[curSample+3] = rows[row][i*3];*/

						// YVYU
						/*dstp[curSample]   = rows[row][i*3 + 1];
						dstp[curSample+1] = rows[row][i*3];
						dstp[curSample+2] = rows[row][i*3 + 2];
						dstp[curSample+3] = rows[row][i*3];*/

						// YUVY
						/*dstp[curSample]   = rows[row][i*3];
						dstp[curSample+1] = rows[row][i*3 + 1];
						dstp[curSample+2] = rows[row][i*3 + 2];
						dstp[curSample+3] = rows[row][i*3];*/
					}
					curSample += row_stride;
				}

				pData = &compressedData[mSkipBytes + jpgDataSize];
				jpgDataSize = m_vFramePos[frameNum].NextFrame - m_vFramePos[frameNum].field2;

				if (jpeg_Decompress(pData, rows, jpgDataSize, row_stride, JCS_YCbCr) == 0)
					return false;

				if (m_iFieldOrder == 0 || ( m_iFieldOrder == -1 && DisplayHeight != 288) )
					fieldData = pBuffer;
				else
					fieldData = pBuffer + row_stride;

				curSample = 0;
				for(row = DisplayYOffset; row < StoredHeight; row++) {
					for ( int h = 0, i = 0; h < StoredWidth / 2; h++, i+=6, curSample+=4 ) {
						// YUYV = YUY2     y0u0y1v0 y2u2y3v2
						fieldData[curSample]   = rows[row][i];       // y0
						fieldData[curSample+1] = rows[row][i + 1];   // u0
						fieldData[curSample+2] = rows[row][i + 3];   // y1
						fieldData[curSample+3] = rows[row][i + 2];   // v0
					}
					curSample += row_stride;
				}
			} else {
				//Progressive
				curSample = 0;
				for(row = DisplayYOffset; row < StoredHeight; row++) {
					for ( int h = 0, i = 0; h < StoredWidth / 2; h++, i+=6, curSample+=4 ) {
						// YUYV = YUY2     y0u0y1v0 y2u2y3v2
						pBuffer[curSample]   = rows[row][i];       // y0
						pBuffer[curSample+1] = rows[row][i + 1];   // u0
						pBuffer[curSample+2] = rows[row][i + 3];   // y1
						pBuffer[curSample+3] = rows[row][i + 2];   // v0
					}
					//curSample += row_stride;
				}
			}

			//for(row = 0; row < StoredHeight; row++) free(rows[row]);
			//free(rows);
		} else if (m_iCodec == CODEC_TYPE_MPG2) {
ReadMpeg:
			size_t size = numBytesRead, curPos = 0;
			omfUInt32 m_iFirstReqFrame = 0;
			uint8_t *mpegBuffer = new uint8_t[4097];
			static uint8_t black[16384] = { 0 };

			mpeg2decoder = mpeg2_init();
			mpeg2info = mpeg2_info(mpeg2decoder);

			OMFOffset = frameNum * nBlockSize;

			if (nBlockSize == 0 && frameNum != 0)
				m_iFirstReqFrame = frameNum;

			//numBytes = nBlockSize = 208896;

			fseek(omfFile, OMFOffset, SEEK_SET);
			//if (bInfo) fprintf(infoFile, "OMFOffset = %d\n", OMFOffset);

			int chroma_width = DisplayWidth / 2;
			int out_height = DisplayHeight;
			if (frameLayout == kSeparateFields)
				out_height *= 2;
			int chroma_height = out_height / 2;

			size = (size_t)-1;
			do {
				mpeg2state = mpeg2_parse (mpeg2decoder);
				mpeg2sequence = mpeg2info->sequence;
				switch (mpeg2state) {
					case STATE_BUFFER:
						size = fread (mpegBuffer, 1, 4096, omfFile);
						mpeg2_buffer(mpeg2decoder, mpegBuffer, mpegBuffer + size);
						curPos += 4096;
						break;
					case STATE_PICTURE:
						break;
					case STATE_SLICE:

					case STATE_END:
						//if (bInfo) fprintf(infoFile, "Mpeg2 STATE_END, Pos = %d, DisplayWidth=%d, dst_pitch=%d\n",
						//	curPos, DisplayWidth, dst_pitch);
						//if (bInfo) fprintf(infoFile, "P5\n%d %d\n255\n",
						//	2 * chroma_width, out_height + chroma_height);

						if (nBlockSize == 0 && frameNum != 0) {
							//If we get here, this means we do not
							//know the compressed block size
							//and the first frame requested is not 0, we need
							//to reread the mpeg
						} else {
							memcpy(pBuffer, &mpeg2info->display_fbuf->buf[0][2*DisplayYOffset*DisplayWidth],
									out_height*DisplayWidth);
								//memset(pBuffer, 0, out_height*DisplayWidth);
								pBuffer += out_height*DisplayWidth;
							for (int i = 0; i < out_height; i+=2) {
								memcpy(pBuffer,
									&mpeg2info->display_fbuf->buf[2][2*DisplayYOffset*chroma_width + i*chroma_width],
									chroma_width);
								pBuffer += chroma_width;
							}
							for (int i = 0; i < out_height; i+=2) {
								memcpy(pBuffer,
									&mpeg2info->display_fbuf->buf[1][2*DisplayYOffset*chroma_width + i*chroma_width],
									chroma_width);
								pBuffer += chroma_width;
							}
						}
						/*for(int h = DisplayYOffset; h<StoredHeight*2;h++) {
							for ( int w = 0, i = 0; w < StoredWidth / 2; w++, i+=2, curSample+=4 ) {
								//pBuffer[curSample] = rows[row][i*3];

								// YUYV     y0u0y1v0 y2u2y3v2
								pBuffer[curSample]   = mpeg2info->display_fbuf->buf[0][i];       // y0
								pBuffer[curSample+1] = mpeg2info->display_fbuf->buf[1][i];   // u0
								pBuffer[curSample+2] = mpeg2info->display_fbuf->buf[2][i];   // y1
								pBuffer[curSample+3] = mpeg2info->display_fbuf->buf[0][i+1];   // v0
							}
						}*
						/*
						memcpy(pBuffer, &mpeg2info->display_fbuf->buf[1][DisplayYOffset*chroma_width],
								chroma_height*chroma_width);
							pBuffer += chroma_height*chroma_width;
						memcpy(pBuffer, &mpeg2info->display_fbuf->buf[2][DisplayYOffset*chroma_width],
								chroma_height*chroma_width); //Correct Width, but only 50% tall streched
						memset(pBuffer, 0, chroma_height*chroma_width);
						*/

						//pBuffer = mpeg2info->display_fbuf->buf[0];
						size = 0;
						if (nBlockSize == 0)
							nBlockSize = curPos - 4096;
						break;
					case STATE_INVALID_END:
						break;
					default:
						break;
				}
			} while (size);

			if (mpeg2decoder) {
				mpeg2_close(mpeg2decoder);
				mpeg2decoder = NULL;
			}

			if (m_iFirstReqFrame != 0) {
				//The first time reading an mpeg file, we do not
				//know the compressed block size
				//if the first frame requested is not 0, then we need
				//to reread the mpeg
				goto ReadMpeg;
			}
		}
	} else {
		//return compressed data
		if (m_iCodec == CODEC_TYPE_JPEG)
			mSize = (m_vFramePos[frameNum]).NextFrame - (m_vFramePos[frameNum]).field1;

			memcpy(pBuffer, compressedData, mSize);
	}

	if (compressedData)
		delete [] compressedData;

	return true;
}

omfErr_t COmfMovieDec::GetTrackInfo(omfHdl_t file, omfMobObj_t mob, omfMSlotObj_t slot, omfTrackInfo_t *mTrackInfo)
{
	OMFError = omfiTrackGetInfo(
		file,           // IN - File Handle
		mob,         // IN - Mob object (for 1.x trackID compat)
		slot,      // IN - Mob Slot object
		&mTrackInfo->editRate, // OUT - Editrate property value
		mTrackInfo->nameSize,       // IN - Size of name buffer
		mTrackInfo->name,          // IN/OUT - preallocated buffer for name
		&mTrackInfo->origin,   // OUT - Origin property value
		&mTrackInfo->trackID,   // OUT - TrackID property value
		&mTrackInfo->segment);   // OUT - Segment property value (objref)

	/*OMFError = omfiMobSlotGetInfo(
		file,           // IN - File Handle
		slot,      // IN - Mob Slot Object
		&mTrackInfo->editRate, // OUT - Edit Rate property value
		&mTrackInfo->segment);*/

	return OMFError;
}
