///////////////////////////////////////////////////////////////////////
//
//
///////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "OmfSource.h"

static char* GetWorkingDir(char* buf, size_t bufSize)
{
	//assert(buf != NULL);
	DWORD len = GetCurrentDirectory(bufSize - 1, buf);

	// if the retrieved directory name doesn't end in a trailing slash, add one
	if (len > 0 && len < bufSize - 1 && buf[len - 1] != '\\')
	{
		buf[len] = '\\';
		buf[len + 1] = '\0';
		++len;
	}
	return buf;
}

static char* AbsolutePath_to_FileName(char* buf, size_t bufSize)
{
	//assert(buf != NULL);
	if ( strrchr(buf, '\\') != NULL )
		return strrchr(buf, '\\');
	else if ( strrchr(buf, '/') != NULL )
		return strrchr(buf, '/');

	return buf;
}

static bool IsAbsolutePath(const char* path)
{
	//assert(path != NULL);
	return    strchr(path, ':') != NULL
		// Allow UNC paths too
		|| (path[0] == '\\' && path[1] == '\\')
		|| (path[0] == '/' && path[1] == '/');
}

///////////////////////////////////////////////////////////////////////
//
//
///////////////////////////////////////////////////////////////////////

OMFInput::OMFInput(const char name[], const int _order, const bool _levels, const bool _info, IScriptEnvironment* env)
{
	char sBuf[512];
	strStatus = new char[1024];

	m_OmfMovie = new COmfMovieDec;

	m_iFieldOrder = _order;
    m_iAdjustLevels = _levels;
	bInfo = _info;

	// Generate full name
	if (IsAbsolutePath(name))
	{
		sBuf[0] = '\0';
		strncat(sBuf, name, sizeof sBuf);
	}
	else
	{
		char cwd[MAX_PATH + 1];
		GetWorkingDir(cwd, sizeof cwd);
		_snprintf(sBuf, sizeof sBuf, "%s%s", cwd, name);
	}
	strcpy(FileName, sBuf);

	if (bInfo) {
		char *infoFileName = new char[MAX_PATH];

		char cwd[MAX_PATH];
		char fName[MAX_PATH];
		GetWorkingDir(cwd, sizeof cwd);
		strcpy(fName, AbsolutePath_to_FileName(FileName, sizeof FileName));
		sprintf(infoFileName, "%s%s_avs_Info.txt", cwd, &fName[1]);

		m_OmfMovie->SetInfoFile(infoFileName);

		delete [] infoFileName;
	}

	if ( m_OmfMovie->OpenMovie(FileName) != 1 ) {
		env->ThrowError(m_OmfMovie->OMFGetLastError());
	}
	m_iCodec = m_OmfMovie->GetCodec();
	frameLayout = m_OmfMovie->GetFrameLayout();
	m_lBlockSize1 = m_OmfMovie->GetDecompressedSize();
	m_iDisplayYOffset = m_OmfMovie->GetDisplayYOffset();
	m_iStoredHeight = m_OmfMovie->GetStoredHeight();

	if ( frameLayout == kSeparateFields )
		m_lBlockSize2 = m_lBlockSize1;

	if (m_iCodec == CODEC_TYPE_MPG2)
		vi.pixel_type = VideoInfo::CS_YV12;
	else if (m_iCodec == CODEC_TYPE_RGBA)
		vi.pixel_type = VideoInfo::CS_BGR24;
	else
		vi.pixel_type = VideoInfo::CS_YUY2;

	m_OmfMovie->SetFieldOrder(m_iFieldOrder);

	/*sprintf(strStatus,
		"m_iStoredHeight: %d, StoredWidth: %d\n"
		"DisplayHeight: %d, DisplayWidth: %d\n"
		"Aspect Ratio: %d:%d\n"
		"DisplayXOffset: %d, DisplayYOffset: %d\n"
		"frameLayout: %d\n"
		"blackReferenceLevel: %d, whiteReferenceLevel: %d\n",
		m_OmfMovie->GetStoredHeight(), m_OmfMovie->GetStoredWidth(),
		m_OmfMovie->GetDisplayHeight(), m_OmfMovie->GetDisplayWidth(),
		m_OmfMovie->GetAspectRatio().numerator, m_OmfMovie->GetAspectRatio().denominator,
		m_OmfMovie->GetDisplayXOffset(), m_OmfMovie->GetDisplayYOffset(),
		m_OmfMovie->GetBlackLevel(), m_OmfMovie->GetWhiteLevel());
	*/

	/*if (bInfo) {
		vi.SetFieldBased(FALSE);
		vi.height=486;
		vi.width=720;
		vi.num_frames=frameCount;
		vi.fps_numerator=fps.numerator;
		vi.fps_denominator=fps.denominator;
		vi.audio_samples_per_second=0;
		//vi.pixel_type = VideoInfo::CS_YUY2;
		vi.pixel_type = VideoInfo::CS_BGR24;
	} else {*/
		if ( frameLayout == kSeparateFields ) {
			vi.SetFieldBased(FALSE); //TRUE
			vi.height = m_OmfMovie->GetDisplayHeight() * 2;
		} else {
			vi.SetFieldBased(FALSE);
			vi.height = m_OmfMovie->GetDisplayHeight();
		}
		vi.width = m_OmfMovie->GetDisplayWidth();
		vi.num_frames = m_OmfMovie->GetFrameCount();
		vi.fps_numerator = m_OmfMovie->GetFPS().numerator;
		vi.fps_denominator = m_OmfMovie->GetFPS().denominator;
		vi.audio_samples_per_second = 0;
		//vi.pixel_type = VideoInfo::CS_YUY2;
		//vi.pixel_type = VideoInfo::CS_BGR24;
	//}

	if (m_iAdjustLevels && (m_OmfMovie->GetBlackLevel() != 0 || m_OmfMovie->GetWhiteLevel() != 255))
		mLevels.Initialize( vi, m_OmfMovie->GetBlackLevel(), 1.0, m_OmfMovie->GetWhiteLevel(), 0, 255, false );
	else
		m_iAdjustLevels = false;
}

///////////////////////////////////////////////////////////////////////
//
//
///////////////////////////////////////////////////////////////////////

OMFInput::~OMFInput()
{

	if (m_OmfMovie) {
		delete m_OmfMovie;
		m_OmfMovie = NULL;
	}

	if (pBuffer)
		delete [] pBuffer;
	if (strStatus)
		delete [] strStatus;
}

PVideoFrame __stdcall OMFInput::GetFrame(int n, IScriptEnvironment* env)
{
	dst = env->NewVideoFrame(vi);

	unsigned char* dstp;// = dst->GetWritePtr();
	/*const int dst_pitch = dst->GetPitch();
	const int dst_pitch_dbl = 2*dst_pitch;
	const int dst_width = dst->GetRowSize();
	const int dst_height = dst->GetHeight();*/

	dstp = dst->GetWritePtr();
	if ( !m_OmfMovie->ReadOMFData(
			n, (char *)dstp, &m_lBlockSize1, &m_lBlockSize2) ) {
				sprintf(strStatus, "Cannot Read Frame: %d\n%s",
				n, m_OmfMovie->OMFGetLastError());
		env->ThrowError(strStatus);
	}

    /*if (m_iCodec == CODEC_TYPE_JPEG) {
		dstp = dst->GetWritePtr();
		if ( !m_OmfMovie->ReadOMFData(
				n, (char *)dstp, &m_lBlockSize1, &m_lBlockSize2) ) {
					sprintf(strStatus, "Cannot Read Jpeg Frame: %d", n);
			env->ThrowError(strStatus);
		}
    } else if (m_iCodec == CODEC_TYPE_DVC) {
    	dstp = dst->GetWritePtr();
        if ( !m_OmfMovie->ReadOMFData(
				n, (char *)dstp, &m_lBlockSize1, &m_lBlockSize2) ) {
					sprintf(strStatus, "Cannot Read DV Frame: %d", n);
			env->ThrowError(strStatus);
		}
    } else if (m_iCodec == CODEC_TYPE_DVCP) {
    	dstp = dst->GetWritePtr();
        if ( !m_OmfMovie->ReadOMFData(
				n, (char *)dstp, &m_lBlockSize1, &m_lBlockSize2) ) {
					sprintf(strStatus, "Cannot Read DV Frame: %d", n);
			env->ThrowError(strStatus);
		}
	} else if (m_iCodec == CODEC_TYPE_MPG2) {
    	dstp = dst->GetWritePtr();
		if ( !m_OmfMovie->ReadOMFData(
				n, (char *)dstp, &m_lBlockSize1, &m_lBlockSize2) ) {
					sprintf(strStatus, "Cannot Read Mpeg2 Frame: %d", n);
			env->ThrowError(strStatus);
		}
	} else { //Uncompressed
		dstp = dst->GetWritePtr();
		if ( !m_OmfMovie->ReadOMFData(
				n, (char *)dstp, &m_lBlockSize1, &m_lBlockSize2) ) {
					sprintf(strStatus, "Cannot Read Frame: %d", n);
			env->ThrowError(strStatus);
		}
	}*/

	if (m_iAdjustLevels) {
		dstp = dst->GetWritePtr();
		mLevels.Apply(dst, vi, (BYTE *)dstp);
	}

	return dst;
}

bool __stdcall OMFInput::GetParity(int n) { return false; }
void __stdcall GetAudio(void* buf, __int64 start, __int64 count, IScriptEnvironment* env);
const VideoInfo& __stdcall OMFInput::GetVideoInfo() { return vi;}
void __stdcall SetCacheHints(int cachehints,int frame_range) ;

///////////////////////////////////////////////////////////////////////////////////////////////////

//OMFOutput
OMFOutput::OMFOutput(PClip _child, const char name[], const char format[], IScriptEnvironment* env)
	: GenericVideoFilter(_child)
{
}

OMFOutput::~OMFOutput()
{
}

PVideoFrame __stdcall OMFOutput::GetFrame(int n, IScriptEnvironment* env)
{
	PVideoFrame src = child->GetFrame(n, env);
	return src;
}
