///////////////////////////////////////////////////////////////////////
//
//
///////////////////////////////////////////////////////////////////////

#if _MSC_VER > 1000
#pragma once
#endif                          // _MSC_VER > 1000

#include <stdlib.h>
#include <math.h>
#include <objbase.h>
#include <vfw.h>

#include <vector>
using namespace std;

#include "./core/avisynth.h"

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
#include "QTMovie.h"

///////////////////////////////////////////////////////////////////////

class QTInput:public IClip {
    VideoInfo vi;
    PVideoFrame dst;
    char FileName[MAX_PATH];
    char szFourCC[5];
    char *strStatus;
    byte *pFrameBuffer;
    bool bInfo, bAdjustLevels, bCompressed;
    int m_iInfoLevel;
    QTCodecInfo mCodec, m_DecoderCodec;
    int m_iRaw, m_iMode;
    float m_fGamma, m_fvfrFPS;

    CQTMovieDec *m_QTMovie;

    int headerOffset, fieldOrder, numFields, avid_fields;

    int DisplayHeight, DisplayWidth, depth;
    double aspectRatio, fps;
    __int64 frameCount;

  public:
#ifdef QT_VFW
     QTInput(const char name[], const int _color, const int quality, const int fAudio,
             const int _mode, const char _raw[], const int _info, const int _dither,
             const char _vfw[], const float _gamma, const float _vfrFPS, IScriptEnvironment * env);
#else
     QTInput(const char name[], const int _color, const int quality, const int fAudio,
             const int _mode, const char _raw[], const int _info, const int _dither,
             const float _gamma, IScriptEnvironment * env);
#endif
     virtual ~ QTInput();

// avisynth virtual functions
    PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment * env);
    bool __stdcall GetParity(int n);    // return field parity if field_based, else parity of first field in frame
    void __stdcall GetAudio(void *buf, __int64 start, __int64 count, IScriptEnvironment * env); // start and count are in samples
    const VideoInfo & __stdcall GetVideoInfo();
    void __stdcall SetCacheHints(int cachehints, int frame_range) {
    };
};

class QTOutput:public GenericVideoFilter {
    VideoInfo vi;
    char FileName[MAX_PATH];
    char strFormat[100];
    char strStatus[560];
    char *pData;
    int pitch, rowsize, height, width;
    int m_iAudio;

    __int64 audio_stream_pos;

    int frameCount;
    bool bComplete;

    CQTMovieEnc *m_QTMovie;

  public:
     QTOutput(PClip _child, const char name[], const char format[], const int _quality,
              const int _datarate, const int _keyframerate, const char _raw[],
              const char _settings[], const int fAudio, IScriptEnvironment * env);
     virtual ~ QTOutput();

// avisynth virtual functions
    PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment * env);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

AVSValue __cdecl Create_QTInput(AVSValue args, void *user_data, IScriptEnvironment * env)
{
    return new QTInput(args[0].AsString(),      //Filename
                       args[1].AsInt(2),        //RGB, RGBA, YUY2, YV12
                       args[2].AsInt(100),      //quality
                       args[3].AsInt(0),        //audio
                       args[4].AsInt(0),        //Mode, 0 = MoviesTask, 1 = Decompress Sequence
                       args[5].AsString("uyvy"),        //yuvy, uyvy, rgb
                       args[6].AsInt(0),        //Display Fileinfo
                       args[7].AsInt(0),        //dither
#ifdef QT_VFW
                       args[8].AsString(""),    //vfw
#endif
                       args[9].AsFloat(-1),     //
                       args[10].AsFloat(0), env);
}

AVSValue __cdecl Create_QTOutput(AVSValue args, void *user_data, IScriptEnvironment * env)
{
    return new QTOutput(args[0].AsClip(), args[1].AsString(),   //Filename
                        args[2].AsString(""),   //format mjpa
                        args[3].AsInt(80),      //quality
                        args[4].AsInt(1000),    //DataRate
                        args[5].AsInt(1),       //KeyFramerate
                        args[6].AsString(""),   //raw
                        args[7].AsString(""),   //settings file
                        args[8].AsInt(0),       //audio
                        env);
}

extern "C" __declspec(dllexport)
const char *__stdcall AvisynthPluginInit2(IScriptEnvironment * env)
{
#ifdef QT_VFW
    env->AddFunction("QTInput", "[file]s[color]i[quality]i[audio]i[mode]i[raw]s[info]i[dither]i[vfw]s[gamma]f[vfrFPS]f",
                     Create_QTInput, 0);
#else
    env->AddFunction("QTInput", "[file]s[color]i[quality]i[audio]i[mode]i[raw]s[info]i[dither]i[gamma]f",
                     Create_QTInput, 0);
#endif
    env->AddFunction("QTOutput", "c[file]s[format]s[quality]i[datarate]i[keyframe]i[raw]s[settings]s[audio]i",
                     Create_QTOutput, 0);
    return 0;
}
