#pragma once

#ifndef __QTMOVIE_H
#define __QTMOVIE_H

#ifdef QT_DSHOW
// Winmm.lib strmbase.lib Vfw32.lib
#define QT_FREE_DSHOW(x) { if (x) x->Release(); x = NULL; }
        //#include "initguid.h"
#include <uuids.h>
#include <strmif.h>
#include <control.h>
        //#include <evcode.h>
        //#include <wxdebug.h>
        //#include <reftime.h>
        //#include <amvideo.h>      // IDirectDrawVideo
        //#include <mtype.h>
#endif
#ifdef QT_VFW
//Vfw32.lib Winmm.lib
#include "Vfw.h"
#endif

#include <qtml.h>
#include <movies.h>
#ifdef QT7
#include <CVPixelBuffer.h>
#endif

//#include <tchar.h>
#include <Gestalt.h>
//#include <wtypes.h>
#include <FixMath.h>
#include <Script.h>
//#include <stdlib.h>
#include <TextUtils.h>
#include <NumberFormatting.h>
#include <QuickTimeComponents.h>
#include <MediaHandlers.h>
#include <GXMath.h>

#include <vector>
using namespace std;

#define FOUR_CHAR_CODE_M(w,x,y,z) (w<<24 | x<<16 | y<< 8 | z)
//#define FourCC_to_Char(x)

#define QT_FREE_BUFFER(x) { if (x) free(x); x = NULL; }
#define QT_DELETE_BUFFER(x) { if (x) delete [] x; x = NULL; }
#define QT_FREE_HANDLE(x) { if (x) DisposeHandle((Handle)x); x = NULL; }

#define QT_MAX_AUDIO_SAMPLES 16384

#define		kPixelDepth 		32      /* use 32-bit depth */
#define		kNoOffset 			0
#define		kMgrChoose			0
#define		kSyncSample 		0
#define		kAddOneVideoSample	1
//#define               kSampleDuration         60      /* frame duration = 1/10 sec */

#define kSoundSampleDuration 1
#define kSyncSample 0
#define kTrackStart 0
#define kMediaStart 0
#define kFix1 0x00010000

#define RowOrderTopDown 0
#define RowOrderBottomUp 1

#define QTMOVIE_RAW_MODE_RGB	1
#define QTMOVIE_RAW_MODE_ARGB	2
#define QTMOVIE_RAW_MODE_UYVY	3
#define QTMOVIE_RAW_MODE_V210	4
#define QTMOVIE_RAW_MODE_YUYV	5
#define QTMOVIE_RAW_MODE_YVYU	6
#define QTMOVIE_RAW_MODE_VYUY	7
#define QTMOVIE_RAW_MODE_YUV2	8
#define QTMOVIE_RAW_MODE_AYUV	9
#define QTMOVIE_RAW_MODE_YUVA	10
#define QTMOVIE_RAW_MODE_UYVYA	11
#define QTMOVIE_RAW_MODE_YV12	12

enum {
    //kTargetBytes = 75 * 1024//48000 * 16bit = 768,000bps / 10fps = 75 * 1024
    kTargetBytes = 1920000
        //10s buffer = 48000 * 10 * 16bit * 2channels / 8bits
};

typedef struct {
    byte *data;
    unsigned long frame;
} myFrameBuffer;

struct MyAudioBuffer {
    UInt32 mNumberChannels;
    UInt32 mDataByteSize;
    byte *mData;
};
typedef struct MyAudioBuffer MyAudioBuffer;

struct MyAudioBufferList {
    UInt32 mNumberBuffers;
    MyAudioBuffer mBuffers[kVariableLengthArray];
};
typedef struct MyAudioBufferList MyAudioBufferList;

typedef struct {
    unsigned long numerator;
    unsigned long denominator;
} fpsInfo;

typedef struct {
    TimeValue mTime;
    //TimeValue mTime2;
    TimeValue mDur;
    //TimeValue mDur2;
    //ULONG idx;
} frameInfo;

typedef struct {
    TimeValue mTime;
    TimeValue mTimeDec;
    TimeValue mDur;
    TimeValue mDurDec;
    TimeValue mOffset;
    SInt64 mFlags;
    bool bKeyframe;
    SInt64 idx;
} mpegFrameInfo;

typedef struct {
    char strFourCC[5];
    CodecType m_iFourCC;
    char CodecName[50];
    CodecQ quality;
    int m_iKeyframeRate;
    int m_iDataRate;
} QTCodecInfo;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

class CQTMovieDec {
    TCHAR strStatus[512];
    GWorldPtr m_GWorld;
    Movie m_Movie;
    Track m_vTrack;
    Media m_vMedia;
    Track m_aTrack;
    Media m_aMedia;
    Str255 m_FileName;
    FSSpec m_fileSpec;
    short m_resRefNum;
    Rect m_vTrackFrame;
    Rect m_vMovieFrame;
    float m_vTrackRot;
    MatrixRecord m_vTrackMatrix;
    Handle m_compressedData;
    Ptr m_compressedDataPtr;
    Handle m_decompressedData;
    Ptr m_decompressedDataPtr;
    PixMapHandle m_PixMap;
    ImageDescriptionHandle m_imageDesc;
    ImageSequence m_seqID;
    ICMCompletionProcRecord mCompletionProcRecord;
    OSType m_pixelFormat;
    QTCodecInfo m_CodecInfo, m_DecoderCodecInfo;
    byte *GWorldDataPtr;
    byte *pDataCompressed;
    MovieAudioExtractionRef m_AudioExtractor;
    AudioStreamBasicDescription m_ASBD;
    AudioBufferList *ioData;

//#ifdef QT_BAND_DECOMP
    Component deComp;
    ComponentInstance decompInstance;
    CodecDecompressParams decomParams;
//#endif

    /////////////////////////////////////////////////////////////////////
#ifdef QT_ICM
    ICMDecompressionSessionRef decompressionSession;
    /*static void QT_ICM_Decode_Frame(
       void *decompressionTrackingRefCon,
       OSStatus result,
       ICMDecompressionTrackingFlags decompressionTrackingFlags,
       CVPixelBufferRef pixelBuffer,
       TimeValue64 displayTime,
       TimeValue64 displayDuration,
       ICMValidTimeFlags validTimeFlags,
       void *reserved,
       void *sourceFrameRefCon); */

    //static
    OSStatus createDecompressionSession(ImageDescriptionHandle imageDesc,
                                        int width,
                                        int height,
                                        OSType pixelFormat,
                                        ICMDecompressionTrackingCallback trackingCallback,
                                        void *trackingRefCon, ICMDecompressionSessionRef * decompressionSessionOut);
#endif
    /////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////
    //Handle hSound;
    //SoundDescriptionHandle hSoundDesc;

    AudioFormatAtomPtr source_sound_decomp_atom;
    SoundDescriptionV1Handle source_sound_description;
    Handle source_sound_description_extension;
    Size source_sound_description_extension_size;
    Handle data_ref;

    AudioFormatAtomPtr atom;
    SoundComponentData source_format;
    SoundComponentData dest_format;
    SoundConverter converter;

    unsigned long inputFrames, inputBytes;
    unsigned long outputFrames, outputBytes;
    Ptr inputAudioPtr, outputAudioPtr;
    Handle inputAudio, outputAudio;
    /////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////

    bool QTVersion7, bIsLoaded;
    bool bAudioExtractionApi, bDecompressSequence;
    int m_iRaw, m_iMode;
    float m_fGamma;
    long maxCompressedSize;
    long m_lRawFrameSize;
    int m_iDither;
    int audioType;

     vector < long >m_vKeyframes;
     vector < frameInfo > m_vFrameInfo;
     vector < mpegFrameInfo > m_vFrameInfoDisplay, m_vFrameInfoDecode;
    int rowOrder, m_Rowsize, depth, m_iModRowsize;
    TimeScale m_MovieTimeScale, m_vMediaTimeScale, m_aMediaTimeScale;
    TimeBase m_VideoTimeBase, m_AudioTimeBase;
    TimeValue m_vTrackStartTime, m_vMediaFrameCount, m_vMovieFrameCount,
        m_aMediaDur, m_vMovieDur, m_vTrackDur, m_vMediaDur, m_aTrackDur, m_aMediaSampleCount;
    float m_vTrackIncrement;
    float m_SampleDuration, m_vMediaSampleDuration;
    int m_iTrackCount, m_vTrackCount, m_aTrackCount;
    long m_lRowBytes;
    float fps;
    bool bIsDV25;

    byte *chan[8];

    //avc1
    HIC hic;
    BITMAPINFOHEADER *pbiSrc;
    BITMAPINFOHEADER biDst;
    long m_lPrevFrameNum, m_lLastFrameDecodeIdx;
    QTSampleTableRef sampleTable;
    bool bContainsDisplayOffsets;       //b-frames
    bool bUseSampleTable;
    bool bIFrameOnly;

#ifdef QT_DSHOW
    IGraphBuilder *d_pGraph;
    IMediaControl *pMC;
    IMediaEventEx *pME;
    IVideoWindow *pVW;
    IBasicAudio *pBA;
    IBasicVideo *pBV;
    IMediaSeeking *pMS;
    IMediaPosition *pMP;
    IVideoFrameStep *pFS;

    IBaseFilter *d_pSFileSource;
    IBaseFilter *d_pVCap;
    IBaseFilter *d_pMSplit;
    IBaseFilter *d_pAudio;
    IPin *pPin1, *pPin2, *pPin3;

    int InitDShow(char *strFourCC);
#endif

    void QTFreeMemory();
#ifdef QT_VFW
    bool bVFW;
    int Init_VFW(char *strFourCC);
#endif
    bool SetUpMovieAudioExtraction();
    bool UpdateFrameBuffer(byte * pBuffer, long frame, bool bForward);
    int IsFrameInBuffer(long frame);

  public:
     CQTMovieDec();
    ~CQTMovieDec(void);
    char *GetErrorMessage();
    HRESULT OpenMovie(char *strFileName, QTCodecInfo mCodec, int vTrackIdx, int aTrackIdx);
    HRESULT InitializeGraphics(int audio, char *strFourCC, bool Yuv2Rgb, int dither, float vfrFPS);
    bool SetFormat(OSType mFormat, int mRaw, int mMode, float mGamma, int mOrder);
    OSType GetColorSpace() {
        return m_pixelFormat;
    };
    int ReadVideoFrame(long frameNum, byte * pData, int dst_pitch);
    //byte *ReadVideoFrame(long frameNum);
    long ReadAudioFrame(byte * pData, __int64 frameNum, __int64 count, unsigned long *m_lBytesConverted);

    long GetVideoDuration() {
        return m_vMovieFrameCount;
    }                           //m_vMediaFrameCount
    int GetDepth() {
        return depth;
    }
    QTCodecInfo QTGetCodecInfo() {
        return m_CodecInfo;
    }
    QTCodecInfo QTGetDecoderInfo() {
        return m_DecoderCodecInfo;
    }
    long GetDisplayWidth() {
        return m_vMovieFrame.right;
    }
    long GetDisplayHeight() {
        return m_vMovieFrame.bottom;
    }
    float GetDisplayRot() {
        return m_vTrackRot;
    }
    //2008-12-17 fpsInfo GetFPS() { fpsInfo fps; fps.numerator=10000*m_vMediaTimeScale; fps.denominator=10000*m_vMediaSampleDuration; return fps;}
    fpsInfo GetFPS() {
        fpsInfo fps;
        fps.numerator = 10000 * m_MovieTimeScale;
        fps.denominator = 10000 * m_vMediaSampleDuration;
        return fps;
    }                           //2008-12-17
    //fpsInfo GetFPS() { fpsInfo fps; fps.numerator=GetMediaSampleCount(m_vMedia)*GetMediaTimeScale(m_vMedia); fps.denominator=GetMediaDisplayDuration(m_vMedia); return fps;} //2008-12-17
    long GetRawFrameSize() {
        return m_lRawFrameSize;
    }
    bool HasVideo() {
        return m_vTrackCount > 0;
    }
    bool audio() {
        return m_aTrackCount > 0;
    }
    //SoundComponentData GetAudioDescription() { return source_format; }
    int GetAudioFormat() {
        return source_format.format;
    }
    int GetAudioNumChannels() {
        return dest_format.numChannels;
    }
    int GetAudioSampleSize() {
        return dest_format.sampleSize;
    }
    int GetAudioSampleRate() {
        return UInt16(dest_format.sampleRate >> 16);
    }
    int GetAudioSampleCount() {
        return dest_format.sampleCount;
    }

    bool ISQTInitialized() {
        return bIsLoaded;
    }
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

class CQTMovieEnc {
    TCHAR strStatus[512];
    CGrafPtr m_Port;
    GDHandle m_GDHandle;
    GWorldPtr m_GWorld;
    GWorldPtr m_GWorldPrev;
    PixMapHandle m_PixMap;
    PixMapHandle m_PixMapPrev;
    CompressorComponent compressor;
    DecompressorComponent decompressor;
    Movie m_Movie;
    Track m_vTrack;
    Media m_vMedia;
    Track m_aTrack;
    Media m_aMedia;
    Str255 m_FileName;
    FSSpec m_fileSpec;
    short m_resRefNum;
    Rect m_vTrackFrame;
    Handle m_compressedData;
    Ptr m_compressedDataPtr;
    ImageDescriptionHandle m_imageDesc;
    ImageSequence m_seqID;
    OSType m_pixelFormat;
    QTCodecInfo m_CodecInfo;
    char *GWorldDataPtr;
    char *GWorldDataPtrPrev;

    Handle hSound;
    SoundDescriptionHandle hSoundDesc;

    ComponentInstance stdCompression;
    //MovieExportComponent myExporter;
    ComponentInstance myExporter;

    int m_MovieTimeScale, m_SampleDuration, rowOrder, m_Rowsize, m_iModRowsize;

    bool QTVersion7, bIsLoaded;
    bool bFristFrame;

    short SyncFlag;
    int m_iRaw, m_iRawExtras;

    void QTFreeMemory();

  public:
     CQTMovieEnc();
    ~CQTMovieEnc(void);
    void SetFormat(OSType mFormat, int mOrder);
    char *GetErrorMessage();
    bool ISQTInitialized() {
        return bIsLoaded;
    };
    HRESULT Initialize(char *strFileName, int width, int height, int fps_numerator,
                       int fps_denominator, int rowsize, QTCodecInfo mCodec, int raw, char *strSettings);
    HRESULT CreateMovie();
    HRESULT CreateVideoTrack();
    HRESULT EncodeVideoFrame(char *pData, int src_pitch);
    HRESULT CreateAudioTrack(int channels, int sampleRate, int bits, bool isFloat);
    HRESULT EncodeAudioFrame(char *pData, long m_lNumSamples, int buffersize);

    void PrintCodecList(char *filename) {
        CodecNameSpecListPtr list;
        FILE *stream = NULL;
        char typeName[256], name[32];
        if (filename != NULL)
            stream = fopen(filename, "wb");
        if (stream) {
            if (GetCodecNameList(&list, 1) != noErr)
                return;
            for (int i = 0; i < list->count; i++) {
                p2cstrcpy(typeName, list->list[i].typeName);
                memcpy(name, &(list->list[i].typeName[1]), list->list[i].typeName[0]);
                name[list->list[i].typeName[0]] = '\0';

                fprintf(stream, "fourCC = %c%c%c%c\t\ttypeName = %s\t\tname = %s\n",
                        UInt8(list->list[i].cType >> 24),
                        UInt8(list->list[i].cType >> 16),
                        UInt8(list->list[i].cType >> 8), UInt8(list->list[i].cType), typeName, name);

                fprintf(stdout, "fourCC = %c%c%c%c\t\ttypeName = %s\t\tname = %s\n",
                        UInt8(list->list[i].cType >> 24),
                        UInt8(list->list[i].cType >> 16),
                        UInt8(list->list[i].cType >> 8), UInt8(list->list[i].cType), typeName, name);
            }
            DisposeCodecNameList(list);
            fclose(stream);
        }
    }
};

#endif
