/*******************************************************************************
 * Copyright (C) 2006 Josh Harris
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/

 // Added 2006-03-25, v1.2

package org.bbcorrector;

import net.rim.device.api.system.*;
import net.rim.device.api.ui.*;
import net.rim.device.api.ui.component.*;
import net.rim.device.api.ui.container.*;

import net.rim.device.api.util.*; // Added 2006-04-02, v1.2, Arrays

import java.util.Vector;

public class BBCorrectorDictionaryScreen extends MainScreen {

    private static boolean isDirty = false;
    //private static FieldChangeListener FIELD_CHANGE_LISTENER = new AllFieldChangeListener();
    //private static TrackwheelListener TRACK_WHEEL_LISTENER = new TrackwheelClickListener();

    private BBCorrectorOptions options = null;
    private ListField DictionaryField = null;
    private ListCallback myCallback = null;

    // Setup the screen, add listeners, fields, etc.
    public BBCorrectorDictionaryScreen() {
        super(DEFAULT_MENU | DEFAULT_CLOSE);
        setTitle("BBCorrector Dictionary");

        // Add callback to listen for trackwheel events
        //super.addTrackwheelListener(TRACK_WHEEL_LISTENER);

        // Read stored BBCorrector options
        options = BBCorrectorOptions.load();

        // Get the count of items in the stored dictionary
        int mSize = options.mvDictionary.length;

        DictionaryField = new ListField(0);
        //DictionaryField.enableInputMethods(true);
        //DictionaryField.setEditable(true);
        myCallback = new ListCallback();
        DictionaryField.setCallback(myCallback);

        // Add stored dictionary words to the list field
        for (int i = 0; i < mSize; i++) {
            DictionaryField.insert(0);
            myCallback.insert((String)options.mvDictionary[i], 0);
        }

        //DictionaryField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(DictionaryField);
        DictionaryField.setSelectedIndex(0);
        isDirty = false;
    }

    // Create the menu items for the dictionary screen
    protected void makeMenu(Menu menu, int instance) {
        MenuItem item = new MenuItem("Clear Dictionary", 900000000, 100) {
            public void run() {
                doClearDictionairy();
            }
        };
        menu.add(item);

        item = new MenuItem("Insert", 900000000, 100) {
            public void run() {
                doInsert();
            }
        };
        menu.add(item);

        item = new MenuItem("Delete", 900000000, 100) {
            public void run() {
                doDelete();
            }
        };
        menu.add(item);

        item = new MenuItem("Save", 900000000, 100) {
            public void run() {
                doSave();
            }
        };
        menu.add(item);
        menu.addSeparator();

        item = new MenuItem("Exit", 999999999, 999) {
            public void run() {
                doExit();
            }

        };
        menu.add(item);

        // When a user opens the menu, this will be the default item selected
        if (isDirty) {
            menu.setDefault(3); //Save
        } else {
            menu.setDefault(4); //Exit
        }
    }

    // Check if user type typed a character and do appropriate action
    protected boolean keyDown(int keycode, int time) {
        switch (Keypad.map(keycode)) {
        case Characters.ESCAPE:
            doExit();
            break;
        case Characters.DELETE:
        case Characters.LATIN_CAPITAL_LETTER_D:
        case Characters.LATIN_SMALL_LETTER_D:
            doDelete();
            break;
        case Characters.LATIN_CAPITAL_LETTER_I:
        case Characters.LATIN_SMALL_LETTER_I:
            doInsert();
            break;
        case Characters.LATIN_CAPITAL_LETTER_C:
        case Characters.LATIN_SMALL_LETTER_C:
            doClearDictionairy();
            break;
        case Characters.LATIN_CAPITAL_LETTER_S:
        case Characters.LATIN_SMALL_LETTER_S:
            doSave();
            break;
        case Characters.LATIN_CAPITAL_LETTER_E:
        case Characters.LATIN_SMALL_LETTER_E:
            doExit();
            break;
        }

        return true;
    }

    private void doClearDictionairy() {
        // Ask the user if they want to perform this action
        Dialog dialog = new Dialog(Dialog.D_YES_NO,
                                    "Erase All Entries?",
                                    Dialog.YES,
                                    Bitmap.getPredefinedBitmap(Bitmap.INFORMATION), 0);
        int dialogReturn = dialog.doModal();

        switch (dialogReturn) {
            case -1:
                break;
            case 4: //Yes
                myCallback.erase(DictionaryField);
                isDirty = true;
                break;
            default: //Discard, cancel
                break;
        }
    }

    private void doInsert() {
        BBCorrectorDictionaryDialog dialog = new BBCorrectorDictionaryDialog();
        dialog.show();
        if (dialog.isCancelled()) {
            return;
        }

        DictionaryField.insert(DictionaryField.getSize());
        myCallback.insert(dialog.getNewWord(), DictionaryField.getSize());
        isDirty = true;
        DictionaryField.setSelectedIndex(DictionaryField.getSize());
    }

    private void doDelete() {
        if (myCallback.count() < 1)
            return;
        // Ask the user if they want to perform this action
        Dialog dialog = new Dialog(Dialog.D_YES_NO,
                               "Delete ???\n"
                               + myCallback.get(DictionaryField, DictionaryField.getSelectedIndex()),
                               Dialog.YES,
                              Bitmap.getPredefinedBitmap(Bitmap.INFORMATION), 0);
        int dialogReturn = dialog.doModal();

        switch (dialogReturn) {
            case -1:
                break;
            case 4: //Yes
                myCallback.delete(DictionaryField, DictionaryField.getSelectedIndex());
                isDirty = true;
                break;
            default: //Discard, cancel
                break;
        }
    }

    private void doSave() {
        if (isDirty) {
            // Clear old elements from dictionary store
            options.mvDictionary = new String[0];

            // Loop through all items in list and add to dictionary store
            for (int i = 0; i < DictionaryField.getSize(); i++) {
                Arrays.add(options.mvDictionary, (String)myCallback.get(DictionaryField, i));
            }
            options.save();
            isDirty = false;
        }
        close();
    }

    private void doExit() {
        if (isDirty) {
            if (Dialog.ask(Dialog.D_YES_NO, "Save Changes?") == Dialog.YES) {
                doSave();
                return;
            }
        }
        close();
    }

    // Callback for performing actions on the dictionary listfield
    private static class ListCallback implements ListFieldCallback {
        private Vector listElements = new Vector();

        public void drawListRow(ListField list, Graphics g, int index, int y, int w) {
            String text = (String)listElements.elementAt(index);
            g.drawText(text, 0, y, 0, w);
        }

        public Object get(ListField list, int index) {
            return listElements.elementAt(index);
        }

        public int getPreferredWidth(ListField list) {
            return Graphics.getScreenWidth();
        }

        public int indexOfList(ListField list, String p, int s) {
            return listElements.indexOf(p, s);
        }

        public void insert(String toInsert, int index) {
            listElements.addElement(toInsert);
        }

        public int count() {
            return listElements.size();
        }

        public void delete(ListField list, int index) {
            if (index < listElements.size()) {
                list.delete(index);
                listElements.removeElementAt(index);
            }
        }

        public void erase(ListField list) {
            for (int i = 0; i < listElements.size(); i++) {
                list.delete(0);
            }
            listElements.removeAllElements();
        }
    }

    /*private static class AllFieldChangeListener implements FieldChangeListener {
        public void fieldChanged(Field field, int context) {
            isDirty = true;
        }
    }*/

    /*private static class TrackwheelClickListener implements TrackwheelListener {
        public boolean trackwheelClick(int status, int time) {
            // Which field has focus?
            Field field = this.getFieldWithFocus();//getLeafFieldWithFocus();
            if (field.equals(mOK)) {
                doOK();
                return true;
            } else if (field.equals(mCancel)) {
                doCancel();
                return true;
            }
            if (isDirty) {
            }
            return false;
        }

        public boolean trackwheelRoll(int amount, int status, int time) {
            return false;
        }

        public boolean trackwheelUnclick(int status, int time) {
            return false;
        }
    }*/
}
