/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bbcorrector;

/*import net.rim.device.api.system.Characters;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.component.CheckboxField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.EditField;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.container.MainScreen;

//import net.rim.device.api.ui.component.SeparatorField; // Added 2006-03-25, v1.2
//import net.rim.device.api.ui.UiApplication; // Added 2006-03-25, v1.2*/

import net.rim.device.api.system.*; // Added 2006-03-25, v1.2
import net.rim.device.api.ui.*; // Added 2006-03-25, v1.2
import net.rim.device.api.ui.component.*; // Added 2006-03-25, v1.2
import net.rim.device.api.ui.container.*; // Added 2006-03-25, v1.2

public class BBCorrectorOptionScreen extends MainScreen {

    private static boolean isDirty = false;
    private static FieldChangeListener FIELD_CHANGE_LISTENER = new AllFieldChangeListener();

    private BBCorrectorOptions options = null;

    private EditField urlField = null;

    private EditField usernameField = null;

    private EditField passwordField = null;

    private CheckboxField disableMDSProxyField = null;

    private CheckboxField useGoogleField = null; // Added 2006-03-25, v1.2

    private EditField languageField = null;

    private CheckboxField bAutoAdvanceField = null; // Added 2006-03-25, v1.2

    public BBCorrectorOptionScreen() {
        super(DEFAULT_MENU | DEFAULT_CLOSE);

        setTitle("BBCorrector");

        options = BBCorrectorOptions.load();
        add(new LabelField("BBCorrector Server URL:"));
        // Added 2006-02-11 (Josh Harris), added "| EditField.FILTER_URL"
        // to make the field behave like a normal url field
        urlField = new EditField(null,
                                 options.urlCorrectorServer,
                                 256,
                                 Field.EDITABLE | Field.FIELD_RIGHT | EditField.FILTER_URL);
        urlField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(urlField);

        // Added 2006-03-25, v1.2
        SeparatorField separatorField = new SeparatorField();
        add(separatorField);

        usernameField = new EditField("Username: ",
                                      options.username,
                                      32,
                                      Field.EDITABLE | Field.FIELD_RIGHT);
        usernameField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(usernameField);

        passwordField = new EditField("Password: ",
                                      options.password,
                                      32,
                                      Field.EDITABLE | Field.FIELD_RIGHT);
        passwordField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(passwordField);

        // Added 2006-03-25, v1.2
        languageField = new EditField("Language: ",
                                      options.language,
                                      2,
                                      Field.EDITABLE | Field.FIELD_RIGHT);
        languageField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(languageField);

        SeparatorField separatorField2 = new SeparatorField();
        add(separatorField2);

        disableMDSProxyField = new CheckboxField("Disable MDS Proxy: ",
                                                 options.disableMDSProxy);
        disableMDSProxyField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(disableMDSProxyField);

        useGoogleField = new CheckboxField("Use Google Spell Checker: ",
                                                 options.useGoogle);
        useGoogleField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(useGoogleField);

        bAutoAdvanceField = new CheckboxField("AutoAdvance to Next Item: ",
                                                 options.bAutoAdvance);
        bAutoAdvanceField.setChangeListener(FIELD_CHANGE_LISTENER);
        add(bAutoAdvanceField);
        // **Added 2006-03-17, v1.2
    }

    protected void makeMenu(Menu menu, int instance) {

        // Added 2006-03-25, v1.2
        MenuItem item = new MenuItem("Edit Dictionary", 900000000, 100) {

            public void run() {
                BBCorrectorDictionaryScreen DictionaryScreen;
                DictionaryScreen = new BBCorrectorDictionaryScreen();
                UiApplication.getUiApplication().pushScreen(DictionaryScreen);
            }
        };
        menu.add(item);

        item = new MenuItem("Save", 900000000, 100) {

            public void run() {
                doSave();
            }
        };
        menu.add(item);
        menu.addSeparator();

        item = new MenuItem("Exit", 999999999, 999) {

            public void run() {
                doExit();
            }

        };
        menu.add(item);
    }

    protected boolean keyDown(int keycode, int time) {

        switch (Keypad.map(keycode)) {
        case Characters.ESCAPE:
            doExit();
            return true;
        }

        return false;
    }

    private void doSave() {

        //System.out.println("*** Saving options");
        options.urlCorrectorServer = urlField.getText();
        options.username = usernameField.getText();
        options.password = passwordField.getText();
        options.disableMDSProxy = disableMDSProxyField.getChecked();
        options.useGoogle = useGoogleField.getChecked(); // Added 2006-03-25, v1.2
        options.language = languageField.getText(); // Added 2006-03-25, v1.2
        options.bAutoAdvance = bAutoAdvanceField.getChecked(); // Added 2006-03-25, v1.2
        options.save();
        isDirty = false;
        // Added 2006-03-23, v1.12
        doExit();
    }

    private void doExit() {
        if (isDirty) {
            if (Dialog.ask(Dialog.D_YES_NO, "Save Changes?") == Dialog.YES) {
                doSave();
                return;
            }
        }
        System.exit(0);
    }

    private static class AllFieldChangeListener implements FieldChangeListener {

        public void fieldChanged(Field field, int context) {
            isDirty = true;
        }
    }
}
