#!c:/Perl/bin/Perl.exe

#!/usr/bin/perl

#
# BBCorrector Server
#
# This script accepts a block of text from the BlackBerry software
# BBCorrector, runs it through Aspell, and returns an XML packet
# indicating spelling errors.
#
# NOTES:
#
# - It is recommended you protect this script with some form of HTTP
#   authentication. BBCorrector is setup to handle Basic Authentication.
#
use CGI qw(:standard Vars);
use File::Temp qw/ tempfile tempdir /;
use Encode;

# The Aspell executable
my $cmdAspellExe = "aspell";

my %FORM = Vars();

# Get the block of text from the HTTP parameter "check"
my $text2Check = "$FORM{check}";

#  if using an old Aspell version that does not support UTF8, use this
# Otherwise use Aspell $cmdAspellOptions = '-a --ignore-case --encoding="UTF-8"' . $lang;
Encode::from_to($text2Check, 'utf-8', 'iso-8859-1');

# Get the block of text from the HTTP parameter "check"
my $lang =  "$FORM{lang}";
if ($lang) {
	$lang = " --lang=$lang";
}

# Options for Aspell. Puts Aspell into Ispell compatibility mode
# so that its output is written to stdout
#my $cmdAspellOptions = '-a --ignore-case --encoding="UTF-8"' . $lang;
my $cmdAspellOptions = '-a --ignore-case' . $lang;

# Convert line endings to a common format. In this case whatever
# line ending combination we get (CRLF, LF, etc), we convert to a standard
# format of LF
$text2Check =~ s/\x0D\x0A|\r/\n/g;

# Create a temporary file to store our block of text
my $dirTemp = tempdir( CLEANUP => 1 );
my( $tempHandle, $tempFilename ) = tempfile( DIR => $dir );

# Split block of text into lines and write to temp file
@lines = split( /\n/, $text2Check );
for my $line ( @lines ) {
  # Force Aspell to check whole line via ^ contol character
  print $tempHandle "^$line\n";
}
close $tempHandle;

# XML packet has format such as:
# <spell-results>
#   <error>
#     <word>maan</word>
#     <position>12</position>
#     <suggest>Man</suggest>
#     <suggest>man</suggest>
#     <suggest>moan</suggest>
#   </error>
#   <error>
#     <word>helllo</word>
#     <position>33</position>
#     <suggest>hello</suggest>
#   </error>
#   <error>
#     <word>chris</word>
#     <position>41</position>
#     <suggest>Chris</suggest>
#     <suggest>Charis</suggest>
#   </error>
# </spell-results>
my $xmlPacket = "<spell-results>";

# Do this here so that when we are debugging we can display it in return output
print header;

# Keeps track of current line number
my $lineNum = 0;

# Keeps track of the absolute position in the block of text
my $posAbsolute = 0;

# Execute Aspell
my $cmd = "$cmdAspellExe $cmdAspellOptions < $tempFilename 2>&1";
# TODO: $status most likely only tracks wether the fork failed or not, not
# whether the actual command we are running (ie: aspell) failed
my $status = open ASPELL, "$cmd |";

if ($status > 0) {
  # Parse Aspell output
  for my $cmdReturn (<ASPELL>) {
    chomp($cmdReturn);

	if( $cmdReturn =~ /^Error/ ) {
		$xmlPacket .= "<exception>BBCorrector Server has encountered an error ($cmdReturn)</exception>";
		last;
    } elsif( $cmdReturn =~ /^\*/ ) {
      # Line begins with *. Do nothing.

    } elsif( $cmdReturn =~ /^(&|#)/ ) {
      # Line begins with & or #.

      # Start error element
      $xmlPacket .= "<error>";

      # Split return line up for easier access
      my @tokens = split(" ", $cmdReturn, 5);

      # Add word element which contains original misspelled word
      $xmlPacket .= "<word>$tokens[1]</word>";

      # Need to work out absolute position in file, not just position in current line
      my $offsetIdx = 3;
      if ($cmdReturn =~ /^\#/) {
        $offsetIdx--;
      }
      my $pos = $posAbsolute + ($tokens[$offsetIdx] - 1);
      $xmlPacket .= "<position>".$pos."</position>";

      # Add suggestions
      my @suggestions = ();
      if ($tokens[4]) {
        @suggestions = split(", ", $tokens[4]);
        for my $suggestion (@suggestions) {
          $xmlPacket .= "<suggest>$suggestion</suggest>";
        }
      }

      # End error element
      $xmlPacket .= "</error>";

    } elsif( $cmdReturn =~ /^$/ ) {
      # We have a blank line which indicates a line of text has been processed

      my $line = $lines[$lineNum];
      $posAbsolute += (length($line) + 1);
      $lineNum++;
    }
  }
  close ASPELL;

} else {
  $xmlPacket .= "<exception>BBCorrector Server has encountered an error ($!)</exception>";
}

# Delete the temp file
unlink $tempFilename;

# End results XML packet
$xmlPacket .= "</spell-results>";

#print "check = $text2Check<p>\n";

# Return XML packet back to client
print "$xmlPacket\n";

