/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bblight;

import java.util.Date;

import net.rim.device.api.system.ApplicationManager;
import net.rim.device.api.system.DeviceInfo;
import net.rim.device.api.system.HolsterListener;
import net.rim.device.api.system.SystemListener;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.util.DateTimeUtilities;

//JHH 2008-05-15, email monitoring
import net.rim.device.api.servicebook.*;
import net.rim.blackberry.api.mail.*;
import net.rim.blackberry.api.mail.event.*;

//JHH 2008-05-15, SMS monitoring
import java.io.IOException;
import javax.microedition.io.*;
import javax.wireless.messaging.*;

//JHH 2009-02-10, phone monitoring
import net.rim.blackberry.api.phone.*;

//JHH 2009-02-10 Vibrate
import net.rim.device.api.system.Alert;
import net.rim.device.api.system.AlertListener;

import net.rim.blackberry.api.invoke.*; //JHH 2009-02-10 open Message App

//EventInjector.KeyCodeEvent -- TRY TO USE THIS FOR AUTOANSWER???
import net.rim.device.api.system.ApplicationDescriptor;
import net.rim.device.api.system.EventInjector;
import net.rim.device.api.system.Characters;
//import net.rim.device.api.system.KeypadListener;
//import net.rim.device.api.system.EventInjector.*;
//import net.rim.blackberry.api.homescreen.HomeScreen;

//JHH 2009-02-18
import net.rim.device.api.notification.*;
import net.rim.device.api.system.LED;

public class BBLight extends UiApplication implements HolsterListener,
        SystemListener, FolderListener, PhoneListener, AlertListener {

    private BBLightOptionScreen optionScreen = null;

    private boolean isActivated = false;

    private boolean isWorkerRunning = false;

    private Thread workerThread = null;

    private boolean isInHolster = false; //JHH 2008-05-15, SMS/email

    private ListeningThread _listener = null; //JHH 2008-05-15, SMS

    private int homeScreenID = -1; //JHH 2008-05-19

    private int vibeCount = 0; //JHH 2009-02-10
    private boolean bPhoneConnected = false; //JHH 2009-02-10
    //private boolean isActive = false; //JHH 2009-02-10

    //JHH 2009-02-18
    public static final long NotificationID = 0x3ba5c080f13e26e1L; //org.bblight.NotificationID
    public static final Object NotificationEvent = new Object() {
        public String toString() {
            return "BBLight";
        }
    };

    public BBLight() {

        //JHH 2008-05-19, used to help detect if homescreen is foreground app
        // This finds the process ID of the home screen
        ApplicationDescriptor[] appDes = ApplicationManager.getApplicationManager().getVisibleApplications();
        //String version = "";
        for (int i = 0; i < appDes.length; i++) {
            //System.out.println("*** BBlightApps " + appDes[i].getModuleName() + " --- " + appDes[i].getName());
            if ((appDes[i].getModuleName()).equals("net_rim_bb_ribbon_app")) {
                homeScreenID =  ApplicationManager.getApplicationManager().getProcessId(appDes[i]);
                //version = appDes[i].getVersion();
                //System.out.println("*** BBlightApps " + version + " --- " + homeScreenID);
            }
        }
        //*JHH

        optionScreen = new BBLightOptionScreen(this);
        // If we are starting up see if we need to activate
        if (ApplicationManager.getApplicationManager().inStartup()) {
            BBLightOptions options = BBLightOptions.load();

            if (options.isActivateOnStartup) {
                doActivate();
            } else {
                System.exit(0);
            }
        } else {
            pushScreen(optionScreen);
            //JHH 2009-02-10 - Make Automatically activate when the program opens
            if (!isActivated())
                doActivate();
        }

        //JHH 2009-02-18
        NotificationsManager.registerSource(NotificationID, NotificationEvent, NotificationsConstants.DEFAULT_LEVEL);
    }

    public void doActivate() {
        init();
        startWorker();
        if ((optionScreen != null) && (optionScreen.isDisplayed()))
            optionScreen.setupTitle();
    }

    public void doDeactivate() {
        stopWorker();
        deinit();
        if ((optionScreen != null) && (optionScreen.isDisplayed()))
            optionScreen.setupTitle();
    }

    public boolean isActivated() {
        return isActivated;
    }

    public void activate() {

        super.activate();

        if (!optionScreen.isDisplayed())
            pushScreen(optionScreen);
    }

    public void inHolster() {
        System.out.println("*** In holster");
        isInHolster = true; //JHH 2008-05-15

        BacklightController.getInstance().off();
        stopWorker();
    }

    public void outOfHolster() {
        System.out.println("*** Out of holster");
        isInHolster = false; //JHH 2008-05-15

        BBLightOptions options = BBLightOptions.load();
        if (options.isOutOfHolster)
            BacklightController.getInstance().on();

        startWorker();
    }

    public void powerOff() {
        System.out.println("*** Power Off");
        BacklightController.getInstance().off();
        stopWorker();
    }

    public void powerUp() {
        System.out.println("*** Power Up");
        BBLightOptions options = BBLightOptions.load();
        if (options.isActivateOnStartup) {
            startWorker();
        }
    }

    public void batteryLow() {
    }

    public void batteryGood() {
    }

    public void batteryStatusChange(int status) {
    }

    //JHH 2008-05-15
    // Called when an email message arrives
    public void messagesAdded(FolderEvent e) {
        final net.rim.blackberry.api.mail.Message theMsg = e.getMessage();
        //final Folder theFolder = theMsg.getFolder();

        //if (theFolder.getType() == Folder.INBOX) {
        if (theMsg.isInbound() && !isInHolster) {
            System.out.println("*** BBLight new Email");

            //JHH 2009-02-10
            BBLightOptions options = BBLightOptions.load();
            if (!options.openMessageAppNever) {
                long idleTime = DeviceInfo.getIdleTime();
                PhoneCall currentCall = Phone.getActiveCall();
                int foregroundID = ApplicationManager.getApplicationManager().getForegroundProcessId();

                if ((idleTime > options.openMessageAppIdle) &&
                            (!options.openMessageAppPhone || (currentCall == null && !bPhoneConnected)) &&
                            (!options.openMessageAppHome || (homeScreenID == foregroundID))) {
                    //ApplicationManager.getApplicationManager().
                    Invoke.invokeApplication(Invoke.APP_TYPE_MESSAGES, new MessageArguments(MessageArguments.ARG_DEFAULT));
                }
            }
            //*JHH

            BacklightController.getInstance().on();

            /*//JHH 2009-02-10
            if (options.emailVibeCount > 0 && Alert.isVibrateSupported()) {
                vibeCount = options.emailVibeCount - 1;
                Alert.startVibrate(1000);
            }*/
        } else {
        //    System.out.println("*** Msg Other " + theFolder.getFullName());
        }
    }

    public void messagesRemoved(FolderEvent e) {
    }

    // Monitor incoming SMS
    private /*static*/ class ListeningThread extends Thread {
        private boolean _stop = false;
        private DatagramConnection _dc = null;
        public synchronized void stop() {
            _stop = true;
            try {
                _dc.close(); // Close the connection so the thread returns.
                _dc = null;
            } catch (IOException e) {
                System.err.println("Exception: SMS Close " + e.toString());
            }
        }
        public void run() {
            BBLightOptions options = BBLightOptions.load(); //JHH 2009-02-10
            try {
                _dc = (DatagramConnection)Connector.open("sms://");
                for(;;) {
                    if (_stop || _dc == null) {
                        return;
                    }
                    Datagram d = _dc.newDatagram(_dc.getMaximumLength());
                    _dc.receive(d);

                    if (!isInHolster) {
                        BacklightController.getInstance().on();

                        //JHH 2009-02-10
                        if (!options.openMessageAppNever) {
                            long idleTime = DeviceInfo.getIdleTime();
                            PhoneCall currentCall = Phone.getActiveCall();
                            int foregroundID = ApplicationManager.getApplicationManager().getForegroundProcessId();

                            if ((idleTime > options.openMessageAppIdle) &&
                                        (!options.openMessageAppPhone || (currentCall == null && !bPhoneConnected)) &&
                                        (!options.openMessageAppHome || (homeScreenID == foregroundID))) {
                                //ApplicationManager.getApplicationManager().
                                Invoke.invokeApplication(Invoke.APP_TYPE_MESSAGES, new MessageArguments(MessageArguments.ARG_DEFAULT));
                            }
                        }
                        //*JHH
                    }

                    /*//JHH 2009-02-10
                    if (options.smsVibeCount > 0 && Alert.isVibrateSupported()) {
                        vibeCount = options.smsVibeCount - 1;
                        Alert.startVibrate(1000);
                    }*/
                }
            } catch (IOException e) {
                System.err.println("Exception: SMS Receive - " + e.toString());
            }
        }
    }

    //** Phone Call
    //JHH 2009-02-10
    public void callAdded(int callId) {} // Invoked when a call gets added to a conference call.
    public void callAnswered(int callId) { // Invoked when the user answers a call (user driven).
        vibeCount = -1;
        Alert.stopVibrate();
        bPhoneConnected = true;
        NotificationsManager.cancelImmediateEvent(NotificationID, 0, this, null); //JHH 2009-02-18
    }
    public void callConferenceCallEstablished(int callId) {} // Invoked when a conference call has been established.
    public void callConnected(int callId) { // Invoked when the network indicates a connected event (network driven).
        vibeCount = -1;
        Alert.stopVibrate();
        bPhoneConnected = true;
        NotificationsManager.cancelImmediateEvent(NotificationID, 0, this, null); //JHH 2009-02-18
    }
    public void callDirectConnectConnected(int callId) { // Invoked when a direct-connect call is connected.
        vibeCount = -1;
        Alert.stopVibrate();
        bPhoneConnected = true;
        NotificationsManager.cancelImmediateEvent(NotificationID, 0, this, null); //JHH 2009-02-18
    }
    public void callDirectConnectDisconnected(int callId) { // Invoked when a direct-connect call is disconnected.
        vibeCount = -1;
        Alert.stopVibrate();
        bPhoneConnected = false;
        NotificationsManager.cancelImmediateEvent(NotificationID, 0, this, null); //JHH 2009-02-18
    }
    public void callDisconnected(int callId) { // Invoked when a call is disconnected.
        vibeCount = -1;
        Alert.stopVibrate();
        bPhoneConnected = false;
        NotificationsManager.cancelImmediateEvent(NotificationID, 0, this, null); //JHH 2009-02-18
    }
    public void callEndedByUser(int callId) { // Invoked when the user ends the call.
        vibeCount = -1;
        Alert.stopVibrate();
        bPhoneConnected = false;
        NotificationsManager.cancelImmediateEvent(NotificationID, 0, this, null); //JHH 2009-02-18
    }
    public void callFailed(int callId, int reason) { // Invoked when a call fails.
        vibeCount = -1;
        Alert.stopVibrate();
        bPhoneConnected = false;
        NotificationsManager.cancelImmediateEvent(NotificationID, 0, this, null); //JHH 2009-02-18
    }
    public void callHeld(int callId) {} // Invoked when a call goes into the 'held' state.
    public void callIncoming(int callId) {
        bPhoneConnected = true;
        BBLightOptions options = BBLightOptions.load();
        if (options.phoneVibeCount > 0 && Alert.isVibrateSupported()) {
            vibeCount = options.phoneVibeCount - 1;
            System.out.println("*** phoneVibeCount = " + vibeCount);
            //2009-02-18 Alert.startVibrate(options.vibeDur);
            NotificationsManager.triggerImmediateEvent(NotificationID, 0, this, null); //JHH 2009-02-18
        }
    }
    public void callInitiated(int callid) { // Invoked when a call has been initiated by the device (outbound).
        bPhoneConnected = true;
    }
    public void callRemoved(int callId) {} // Invoked when a call gets removed from a conference call.
    public void callResumed(int callId) {} // Invoked when a call goes from 'held' to 'resumed' state.
    public void callWaiting(int callid) {} // Invoked when a call is waiting.
    public void conferenceCallDisconnected(int callId) {} // Invoked when a conference call is terminated (all members disconnected).

    public void vibrateDone (int reason) {
        System.out.println("*** vibrateDone = " + vibeCount);
        if (vibeCount > 0) {
            BBLightOptions options = BBLightOptions.load();
            final int vibeDur = options.vibeDur;
            final int vibeSleepDur = options.vibeSleepDur;
            vibeCount--;
            UiApplication.getUiApplication().invokeLater(new Runnable() {
                public void run() {
                    try {
                        Thread.sleep(vibeSleepDur);
                        if (vibeCount >= 0) //Check again, in case disconnecting call set vibeCount = 0
                            Alert.startVibrate(vibeDur);
                    } catch( InterruptedException e ) {
                        System.err.println(e.toString());
                    }
                }
            });
        }
    }

    public void audioDone( int reason ) {}
    public void buzzerDone( int reason ) {}
    //**

    private void init() {
        BBLightOptions options = BBLightOptions.load(); //JHH 2008-05-15

        addHolsterListener(this);
        addSystemListener(this);

        //JHH 2009-02-10
        if (options.phoneVibeCount > 0) {
            addAlertListener(this);
            Phone.addPhoneListener(this);
        }
        vibeCount = 0;
        //*JHH

        isActivated = true;

        //JHH 2008-05-15
        if (options.Monitor_Email) {
            System.out.println("*** new Email Monitor");
            try {
                ServiceBook sb = ServiceBook.getSB();
                ServiceRecord[] srs = sb.getRecords();

                //identify the service record associated with a mail message service via a CID of 'CMIME'
                for(int cnt = srs.length - 1; cnt >= 0; --cnt) {
                    if (srs[cnt].getCid().equals("CMIME")) {
                        ServiceConfiguration sc = new ServiceConfiguration(srs[cnt]);
                        Store store = Session.getInstance(sc).getStore();
                        store.addFolderListener(this);
                    }
                }
            } catch (Exception e) {
                System.out.println(e.toString());
            }
        }

        if (options.Monitor_SMS) {
            _listener = new ListeningThread();
            _listener.start();
        }
        //*JHH
    }

    private void deinit() {
        removeHolsterListener(this);
        removeSystemListener(this);
        removeAlertListener(this); //JHH 2009-02-10
        Phone.removePhoneListener(this); //JHH 2009-02-10
        vibeCount = 0; //JHH 2009-02-10
        isActivated = false;

        //JHH 2008-05-15
        BBLightOptions options = BBLightOptions.load();
        if (options.Monitor_Email) {
            try {
                ServiceBook sb = ServiceBook.getSB();
                ServiceRecord[] srs = sb.getRecords();

                //identify the service record associated with a mail message service via a CID of 'CMIME'
                for(int cnt = srs.length - 1; cnt >= 0; --cnt) {
                    if (srs[cnt].getCid().equals("CMIME")) {
                        ServiceConfiguration sc = new ServiceConfiguration(srs[cnt]);
                        Store store = Session.getInstance(sc).getStore();
                        store.removeFolderListener(this);
                    }
                }
            } catch (Exception e) {
                System.out.println(e.toString());
            }
        }

        if (_listener != null) {
            System.out.println("*** Close SMS Monitor");
            _listener.stop();
            _listener = null;
        }
        //*JHH
    }

    private void startWorker() {

        if (!isWorkerRunning) {
            // Check if options that require a thread to be running are being
            // used and if so, start the thread
            BBLightOptions options = BBLightOptions.load();
            if (options.isUserActivity || options.isExternalPower
                    || options.isTimeOfDay || options.isOutOfHolster) { //JHH
                System.out.println("*** Start worker thread");
                getWorkerThread().start();
            }
        }
    }

    private void stopWorker() {
        isWorkerRunning = false;
        try {
            getWorkerThread().interrupt();
        } catch (Exception e) {
        }
        workerThread = null;
    }

    private Thread getWorkerThread() {

        // Worker thread to monitor certain options
        if (workerThread == null) {
            workerThread = new Thread(new Runnable() {

                public void run() {
                    BBLightOptions options = BBLightOptions.load();
                    isWorkerRunning = true;
                    while (isWorkerRunning) {
                        if (turnBacklightOn())
                            BacklightController.getInstance().on();
                        try {
                            Thread.sleep(options.pollInterval);
                        } catch (InterruptedException e) {
                        }
                    }
                }
            });
        }

        return workerThread;
    }

    private boolean turnBacklightOn() {

        boolean status = false;

        //net.rim.blackberry.api.homescreen.HomeScreen. .SetName("Test");
        //HomeScreen.setName("test");

        BBLightOptions options = BBLightOptions.load();

        //JHH 2008-05-16
        // Make sure the backlight doesn't keep cycling on when device is locked
        if (ApplicationManager.getApplicationManager().isSystemLocked() && !options.isOnWhenLocked) {
            System.out.println("*** turnBacklightOn() SystemLocked");
            return false;
        }

        // Figure out, based on selected options, whether the backlight should
        // be turned on
        if (options.isExternalPower) {
            // Check if we are on external power
            boolean isExternalPower = ((DeviceInfo.getBatteryStatus() & DeviceInfo.BSTAT_IS_USING_EXTERNAL_POWER) == DeviceInfo.BSTAT_IS_USING_EXTERNAL_POWER)
                || ((DeviceInfo.getBatteryStatus() & DeviceInfo.BSTAT_CHARGING) == DeviceInfo.BSTAT_CHARGING); //JHH
            System.out.println("*** turnBacklightOn() isExternalPower="
                    + isExternalPower);
            status = isExternalPower;
        }

        if (!status) {
            if (options.isUserActivity) {
                // Check if there's been user activity
                long idleTime = DeviceInfo.getIdleTime();
                boolean isUserActivity = (idleTime < 2);
                System.out.println("*** turnBacklightOn() isUserActivity="
                        + isUserActivity + " idleTime=" + idleTime);
                status = isUserActivity;
            }

            if (!status) {
                //JHH, 2008-05-15
                // Keep backlight on if option is selected and device is out of holster
                if (options.isOutOfHolster) {
                    status = !isInHolster;
                }

                if (!status) {
                    if (options.isTimeOfDay) {
                        // Check if we have hit the specified time of day
                        long now = System.currentTimeMillis();
                        long start = DateTimeUtilities.getDate((int) options.startTime).getTime().getTime();
                        long end = start + options.duration * 60000;
                        boolean isTimeOfDay = false;
                        if ((now >= start) && (now <= end))
                            isTimeOfDay = true;
                        System.out.println("*** turnBacklightOn() isTimeOfDay="
                                + isTimeOfDay + " now=" + new Date(now) + " start="
                                + new Date(start) + " end=" + new Date(end));
                        status = isTimeOfDay;
                    }
                }
            }
        }

        System.out.println("*** turnBacklightOn() status=" + status);

        //JHH 2008-05-19
        /*Removed 2009-02-10 - Was meant to keep a BES device from autolocking, but didn't seem to work, and I can't really test it
        if (status && options.keepFromLocking) {
            int foregroundID = ApplicationManager.getApplicationManager().getForegroundProcessId();
            if (homeScreenID == foregroundID) {
                try {
                    long curIdleTime = DeviceInfo.getIdleTime();
                    //System.out.println("*** BBlight Inject ESCAPE key stroke, idle = " + curIdleTime);
                    //EventInjector.invokeEvent(new EventInjector.KeyEvent(KeyEvent.KEY_DOWN, Characters.ESCAPE, KeypadListener.STATUS_NOT_FROM_KEYPAD, 15));
                    EventInjector.invokeEvent(new EventInjector.KeyEvent(EventInjector.KeyEvent.KEY_DOWN, Characters.ESCAPE, 0, 100));
                    EventInjector.invokeEvent(new EventInjector.KeyEvent(EventInjector.KeyEvent.KEY_UP, Characters.ESCAPE,0, 100));
                    //EventInjector.KeyEvent inject = new EventInjector.KeyEvent(EventInjector.KeyEvent.KEY_DOWN, Characters.ESCAPE, 0, 50);
                    //inject.post();
                    System.out.println("*** BBlight Inject ESCAPE key stroke, idle = " + DeviceInfo.getIdleTime());
                    if (DeviceInfo.getIdleTime() < curIdleTime)
                        return false;
                } catch (Exception e) {
                    System.out.println("Exception : BBLight EventInjector " + e.getMessage());
                }
            } else {
                //System.out.println("*** BBlight homeScreenID, foregroundID = " + homeScreenID + " --- " + foregroundID);
            }
        }*/
        //*JHH

        return status;
    }

    public static void main(String[] args) {

        try {
            BBLight bblight = new BBLight();
            bblight.enterEventDispatcher();
        } catch (Exception e) {
            System.out.println("main() Exception=" + e.getMessage());
        }
    }
}
