/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bblight;

import java.util.TimeZone;

import net.rim.device.api.i18n.SimpleDateFormat;
import net.rim.device.api.system.Characters;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.CheckboxField;
import net.rim.device.api.ui.component.DateField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.NumericChoiceField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.component.LabelField; //JHH 2008-05-15
import net.rim.device.api.ui.container.MainScreen;

public class BBLightOptionScreen extends MainScreen {

    private static boolean isDirty = false;

    private FieldChangeListener ALL_FIELD_CHANGE_LISTENER = new AllFieldChangeListener();

    private static int POLL_RANGE_STEP = 2000; //JHH 2008-05-15, changed value

    private static int POLL_RANGE_NUM_STEP = 15; //JHH 2008-05-15, changed value

    private static SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");

    private BBLight bblight = null;

    private BBLightOptions options = null;

    private CheckboxField isActivateOnStartupField = null;

    private NumericChoiceField pollIntervalField = null;

    private CheckboxField isUserActivityField = null;

    private CheckboxField isOutOfHolsterField = null;

    private CheckboxField isExternalPowerField = null;

    private CheckboxField isTimeOfDayField = null;

    private DateField startTimeField = null;

    private NumericChoiceField durationField = null;

    private CheckboxField Monitor_SMS = null; //JHH 2008-05-15
    private CheckboxField Monitor_Email = null; //JHH 2008-05-15
    private CheckboxField isOnWhenLocked = null; //JHH 2008-05-17
    //2009-02-10 private CheckboxField keepFromLocking = null; //JHH 2008-05-19

    //JHH 2009-02-10
    //private NumericChoiceField emailVibeCountField = null;
    //private NumericChoiceField smsVibeCountField = null;
    private NumericChoiceField phoneVibeCountField = null;
    private NumericChoiceField vibeDurField = null;
    private NumericChoiceField vibeSleepDurField = null;
    private CheckboxField openMessageAppNeverField = null;
    private NumericChoiceField openMessageAppIdleField = null;
    private CheckboxField openMessageAppHomeField = null;
    private CheckboxField openMessageAppPhoneField = null;
    //*JHH

    public BBLightOptionScreen(BBLight bblight) {
        super(DEFAULT_MENU | DEFAULT_CLOSE);

        this.bblight = bblight;

        setupTitle();

        options = BBLightOptions.load();

        isActivateOnStartupField = new CheckboxField("Activate on Startup", false);
        isActivateOnStartupField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(isActivateOnStartupField);

        //JHH 2008-05-19
        /*2009-02-10 keepFromLocking = new CheckboxField("Keep From Locking", false);
        keepFromLocking.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(keepFromLocking);*/

        //2008-05-17
        isOnWhenLocked = new CheckboxField("Active When Device is Locked", false);
        isOnWhenLocked.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(isOnWhenLocked);
        //*JHH

        pollIntervalField = new NumericChoiceField("Poll Interval (ms): ",
                                                   POLL_RANGE_STEP,
                                                   POLL_RANGE_STEP
                                                           * POLL_RANGE_NUM_STEP,
                                                   POLL_RANGE_STEP);
        pollIntervalField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(pollIntervalField);

        add(new SeparatorField());

        add(new LabelField("Always On When:")); //JHH 2008-05-15

        isUserActivityField = new CheckboxField("User is Active", false);
        isUserActivityField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(isUserActivityField);

        isOutOfHolsterField = new CheckboxField("Out of Holster", false); //JHH 2008-05-15, changed value
        isOutOfHolsterField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(isOutOfHolsterField);

        isExternalPowerField = new CheckboxField("External Power/Charging", false); //JHH 2008-05-15, changed value
        isExternalPowerField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(isExternalPowerField);

        //JHH 2008-05-15
        add(new SeparatorField());
        add(new LabelField("Turn On:"));
        Monitor_SMS = new CheckboxField("Receive SMS", false);
        Monitor_SMS.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(Monitor_SMS);

        Monitor_Email = new CheckboxField("Receive Email", false);
        Monitor_Email.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(Monitor_Email);
        //*JHH

        isTimeOfDayField = new CheckboxField("At Time of Day", false);
        isTimeOfDayField.setChangeListener(new FieldChangeListener() {

            public void fieldChanged(Field field, int context) {
                if (((CheckboxField) field).getChecked()) {
                    startTimeField.setEditable(true);
                    durationField.setEditable(true);
                } else {
                    startTimeField.setEditable(false);
                    durationField.setEditable(false);
                }
                isDirty = true;
            }
        });
        add(isTimeOfDayField);

        startTimeField = new DateField("    From: ", //JHH 2008-05-15, changed value
                                       0L,
                                       timeFormat);
        startTimeField.setTimeZone(TimeZone.getTimeZone("GMT"));
        startTimeField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(startTimeField);

        durationField = new NumericChoiceField("    Duration (mins): ", //JHH 2008-05-15, changed value
                                               0,
                                               1440,
                                               1);
        durationField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(durationField);

        //JHH 2009-02-10
        add(new SeparatorField());
        add(new LabelField("Open Email Application:"));
        openMessageAppNeverField = new CheckboxField("    Never: ", false);
        openMessageAppNeverField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(openMessageAppNeverField);

        openMessageAppHomeField = new CheckboxField("    Only on Homescreen: ", false);
        openMessageAppHomeField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(openMessageAppHomeField);

        openMessageAppPhoneField = new CheckboxField("    Never on phone call: ", false);
        openMessageAppPhoneField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(openMessageAppPhoneField);

        openMessageAppIdleField = new NumericChoiceField("    If idle (secs): ", 0, 120, 5);
        openMessageAppIdleField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(openMessageAppIdleField);

        ////////////////////////////////////////////////////////////////
        add(new SeparatorField());
        add(new LabelField("Vibration:"));
        /*smsVibeCountField = new NumericChoiceField("    for SMS: ", 0, 10, 1);
        smsVibeCountField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(smsVibeCountField);

        emailVibeCountField = new NumericChoiceField("    for Email: ", 0, 10, 1);
        emailVibeCountField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(emailVibeCountField);*/

        phoneVibeCountField = new NumericChoiceField("    for Phone Calls: ", 0, 10, 1);
        phoneVibeCountField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(phoneVibeCountField);

        vibeDurField = new NumericChoiceField("    Vibration Duration (ms): ", 250, 5000, 250);
        vibeDurField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(vibeDurField);

        vibeSleepDurField = new NumericChoiceField("    Vibration Interval (ms): ", 250, 3000, 250);
        vibeSleepDurField.setChangeListener(ALL_FIELD_CHANGE_LISTENER);
        add(vibeSleepDurField);
        //*JHH
    }

    public void setupTitle() {
        setTitle("BBLight (" + (bblight.isActivated() ? "Active" : "Inactive")
                + ")");
    }

    protected void onVisibilityChange(boolean visible) {
        if (visible) {
            setupTitle();
            setInitialFieldValues();
        }
    }

    protected void makeMenu(Menu menu, int instance) {

        //JHH 2009-02-10
        /*MenuItem item = new MenuItem("Activate", 1, 100) {

            public void run() {
                bblight.doActivate();
            }
        };
        menu.add(item);
        item = new MenuItem("Deactivate", 2, 100) {

            public void run() {
                bblight.doDeactivate();
            }
        };*/
        MenuItem item;
        if (bblight.isActivated()) {
            item = new MenuItem("Deactivate", 1, 100) {
                public void run() {
                    bblight.doDeactivate();
                }
            };
        } else {
                item = new MenuItem("Activate", 1, 100) {
                public void run() {
                    bblight.doActivate();
                }
            };
        }
        //*JHH
        menu.add(item);
        menu.addSeparator();

        item = new MenuItem("Save", 900000000, 100) {

            public void run() {
                doSave();
            }
        };
        menu.add(item);
        menu.addSeparator();

        item = new MenuItem("Close", 909999999, 999) {

            public void run() {

                doClose();
            }

        };
        menu.add(item);

        //JHH 2008-05-15
        menu.addSeparator();
        item = new MenuItem("Exit", 999999999, 100) {

            public void run() {
                if (isDirty) {
                    if (Dialog.ask(Dialog.D_YES_NO, "Save Changes?") == Dialog.YES)
                        doSave();
                }
                bblight.doDeactivate();
                System.exit(0);
            }

        };
        menu.add(item);
        //*JHH
    }

    protected boolean keyDown(int keycode, int time) {

        switch (Keypad.map(keycode)) {
        case Characters.ESCAPE:
            doClose();
            return true;
        }

        return false;
    }

    private void setInitialFieldValues() {

        isActivateOnStartupField.setChecked(options.isActivateOnStartup);

        pollIntervalField.setSelectedValue(options.pollInterval);

        isUserActivityField.setChecked(options.isUserActivity);

        isOutOfHolsterField.setChecked(options.isOutOfHolster);

        isExternalPowerField.setChecked(options.isExternalPower);

        Monitor_SMS.setChecked(options.Monitor_SMS); //JHH 2008-05-15
        Monitor_Email.setChecked(options.Monitor_Email); //JHH 2008-05-15
        isOnWhenLocked.setChecked(options.isOnWhenLocked); //JHH 2008-05-17
        //2009-02-10 keepFromLocking.setChecked(options.keepFromLocking); //JHH 2008-05-19

        //JHH 2009-02-10
        //smsVibeCountField.setSelectedValue(options.smsVibeCount);
        //emailVibeCountField.setSelectedValue(options.emailVibeCount);
        phoneVibeCountField.setSelectedValue(options.phoneVibeCount);
        vibeDurField.setSelectedValue(options.vibeDur);
        vibeSleepDurField.setSelectedValue(options.vibeSleepDur);
        openMessageAppNeverField.setChecked(options.openMessageAppNever);
        openMessageAppIdleField.setSelectedValue(options.openMessageAppIdle);
        openMessageAppHomeField.setChecked(options.openMessageAppHome);
        openMessageAppPhoneField.setChecked(options.openMessageAppPhone);
        //*JHH


        isTimeOfDayField.setChecked(options.isTimeOfDay);

        startTimeField.setDate(options.startTime);

        durationField.setSelectedValue(options.duration);

        isDirty = false;
    }

    private void doSave() {

        System.out.println("*** Saving options");
        options.isActivateOnStartup = isActivateOnStartupField.getChecked();
        options.pollInterval = pollIntervalField.getSelectedValue();
        options.isUserActivity = isUserActivityField.getChecked();
        options.isOutOfHolster = isOutOfHolsterField.getChecked();
        options.isExternalPower = isExternalPowerField.getChecked();
        options.Monitor_SMS = Monitor_SMS.getChecked(); //JHH 2008-05-15
        options.Monitor_Email = Monitor_Email.getChecked(); //JHH 2008-05-15
        options.isOnWhenLocked = isOnWhenLocked.getChecked(); //JHH 2008-05-17
        //2009-02-10 options.keepFromLocking = keepFromLocking.getChecked(); //JHH 2008-05-19
        options.isTimeOfDay = isTimeOfDayField.getChecked();
        options.startTime = startTimeField.getDate();
        options.duration = durationField.getSelectedValue();

        //JHH 2009-02-10
        //options.smsVibeCount = smsVibeCountField.getSelectedValue();
        //options.emailVibeCount = emailVibeCountField.getSelectedValue();
        options.phoneVibeCount = phoneVibeCountField.getSelectedValue();
        options.vibeDur = vibeDurField.getSelectedValue();
        options.vibeSleepDur = vibeSleepDurField.getSelectedValue();
        options.openMessageAppNever = openMessageAppNeverField.getChecked();
        options.openMessageAppIdle = openMessageAppIdleField.getSelectedValue();
        options.openMessageAppHome = openMessageAppHomeField.getChecked();
        options.openMessageAppPhone = openMessageAppPhoneField.getChecked();
        //*JHH

        options.save();
        isDirty = false;

        bblight.doDeactivate();
        bblight.doActivate();
    }

    private void doClose() {
        if (isDirty) {
            if (Dialog.ask(Dialog.D_YES_NO, "Save Changes?") == Dialog.YES)
                doSave();
        }
        UiApplication.getUiApplication().popScreen(this);
        bblight.requestBackground();
    }

    private class AllFieldChangeListener implements FieldChangeListener {

        public void fieldChanged(Field field, int context) {
            isDirty = true;

            //JHH 2008-05-19, make sure only one of the Device locked options is selected at a time
            /*if (field == isOnWhenLocked) {
                //System.out.println("*** isOnWhenLocked");
                if (isOnWhenLocked.getChecked())
                    keepFromLocking.setChecked(false);
            } else if (field == keepFromLocking) {
                //System.out.println("*** keepFromLocking");
                if (keepFromLocking.getChecked())
                    isOnWhenLocked.setChecked(false);
            }*/

            //JHH 2009-02-10
            if (field == openMessageAppNeverField) {
                if (openMessageAppNeverField.getChecked()) {
                    openMessageAppIdleField.setEditable(false);
                    openMessageAppHomeField.setEditable(false);
                    openMessageAppPhoneField.setEditable(false);
                } else {
                    openMessageAppIdleField.setEditable(true);
                    openMessageAppHomeField.setEditable(true);
                    openMessageAppPhoneField.setEditable(true);
                }
            }
            //*JHH
        }
    }
}
