/*******************************************************************************
 * Copyright (C) 2005 Chris Miles
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 ******************************************************************************/
package org.bblight;

import net.rim.device.api.system.PersistentObject;
import net.rim.device.api.system.PersistentStore;
import net.rim.device.api.util.Persistable;

public class BBLightOptions {

    // org.bblight.BBLightOptions$BBLightOptionsData
    public static final long KEY = 0x5b2dd3da5d0b87a0L;

    public boolean isActivateOnStartup = false;

    public int pollInterval = 1000;

    public boolean isUserActivity = false;

    public boolean isOutOfHolster = false;

    public boolean isExternalPower = false;

    public boolean isTimeOfDay = false;

    public long startTime = 0;

    public int duration = 0;

    public boolean Monitor_SMS = false; //JHH 2008-05-15
    public boolean Monitor_Email = false; //JHH 2008-05-15
    public boolean isOnWhenLocked = false; //JHH 2008-05-17
    //2009-02-10 public boolean keepFromLocking = false; //JHH 2008-05-19

    //JHH 2009-02-10
    //public int emailVibeCount = 0;
    //public int smsVibeCount = 0;
    public int phoneVibeCount = 0;
    public int vibeDur = 2000;
    public int vibeSleepDur = 1000;
    public boolean openMessageAppNever = true;
    public int openMessageAppIdle = 15;
    public boolean openMessageAppHome = true;
    public boolean openMessageAppPhone = true;

    public void save() {

        try {
            PersistentObject record = PersistentStore.getPersistentObject(KEY);
            BBLightOptionsData data = new BBLightOptionsData();
            data.isActivateOnStartup = isActivateOnStartup;
            data.pollInterval = pollInterval;
            data.isUserActivity = isUserActivity;
            data.isOutOfHolster = isOutOfHolster;
            data.isExternalPower = isExternalPower;
            data.isTimeOfDay = isTimeOfDay;
            data.startTime = startTime;
            data.duration = duration;
            data.Monitor_SMS = Monitor_SMS; //JHH 2008-05-15
            data.Monitor_Email = Monitor_Email; //JHH 2008-05-15
            data.isOnWhenLocked = isOnWhenLocked; //JHH 2008-05-17
            //2009-02-10 data.keepFromLocking = keepFromLocking; //JHH 2008-05-19

            //JHH 2009-02-10
            //data.emailVibeCount = emailVibeCount;
            //data.smsVibeCount = smsVibeCount;
            data.phoneVibeCount = phoneVibeCount;
            data.vibeDur = vibeDur;
            data.vibeSleepDur = vibeSleepDur;
            data.openMessageAppNever = openMessageAppNever;
            data.openMessageAppIdle = openMessageAppIdle;
            data.openMessageAppHome = openMessageAppHome;
            data.openMessageAppPhone = openMessageAppPhone;
            //*JHH

            record.setContents(data);
            record.commit();
        } catch (Exception e) {
            System.out.println("*** Exception saving options: "
                    + e.getMessage());
        }
    }

    public static BBLightOptions load() {

        BBLightOptions options = new BBLightOptions();
        try {
            PersistentObject record = PersistentStore.getPersistentObject(KEY);
            BBLightOptionsData data = (BBLightOptionsData) record.getContents();
            if (data != null) {
                options.isActivateOnStartup = data.isActivateOnStartup;
                options.pollInterval = data.pollInterval;
                options.isUserActivity = data.isUserActivity;
                options.isOutOfHolster = data.isOutOfHolster;
                options.isExternalPower = data.isExternalPower;
                options.isTimeOfDay = data.isTimeOfDay;
                options.startTime = data.startTime;
                options.duration = data.duration;
                options.Monitor_SMS = data.Monitor_SMS;
                options.Monitor_Email = data.Monitor_Email; //JHH 2008-05-15
                options.isOnWhenLocked = data.isOnWhenLocked; //JHH 2008-05-17
                //2009-02-10 options.keepFromLocking = data.keepFromLocking; //JHH 2008-05-19

                //JHH 2009-02-10
                //options.emailVibeCount = data.emailVibeCount;
                //options.smsVibeCount = data.smsVibeCount;
                options.phoneVibeCount = data.phoneVibeCount;
                options.vibeDur = data.vibeDur;
                options.vibeSleepDur = data.vibeSleepDur;
                options.openMessageAppNever = data.openMessageAppNever;
                options.openMessageAppIdle = data.openMessageAppIdle;
                options.openMessageAppHome = data.openMessageAppHome;
                options.openMessageAppPhone = data.openMessageAppPhone;
                //*JHH
            }
        } catch (Exception e) {
            System.out.println("*** Exception loading options: "
                    + e.getMessage());
        }

        return options;
    }

    private static class BBLightOptionsData implements Persistable {

        public int VERSION = 1;

        public boolean isActivateOnStartup;

        public int pollInterval;

        public boolean isUserActivity;

        public boolean isOutOfHolster;

        public boolean isExternalPower;

        public boolean isTimeOfDay;

        public long startTime;

        public int duration;

        public boolean Monitor_SMS; //JHH 2008-05-15
        public boolean Monitor_Email; //JHH 2008-05-15
        public boolean isOnWhenLocked; //JHH 2008-05-17
        //2009-02-10 public boolean keepFromLocking; //JHH 2008-05-19

        //JHH 2009-02-10
        //public int emailVibeCount;
        //public int smsVibeCount;
        public int phoneVibeCount;
        public int vibeDur;
        public int vibeSleepDur;
        public boolean openMessageAppNever;
        public int openMessageAppIdle;
        public boolean openMessageAppHome;
        public boolean openMessageAppPhone;
    }
}
