//	Quicktime Import Plugin for VirtualDub
//	Copyright (C) 2007 Josh Harris (tateu)
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "QTMovieDec.h"

OSErr CQTMovieDec::InitDecodeMTask()
{
	return noErr;
}

int CQTMovieDec::FrameDecodeMTask(TimeValue frameNumTime, byte *pData, int dst_pitch, int *rawSize)
{
	int i, j;

	SetMovieTimeValue(m_Movie, frameNumTime);
	MoviesTask(m_Movie, 0L);

	// 2007-07-17
	if (m_pixelFormat == k32BGRAPixelFormat || m_pixelFormat == k24BGRPixelFormat) {
		if (m_iRowOrder == 0) {
			for (i = m_vTrackFrame.bottom - 1, j = 0; i >= 0; i--, j++) {
				memcpy(&pData[j * dst_pitch], &GWorldDataPtr[i * m_iModRowsize], m_iRowsize);
			}
		} else {
			for (i = 0; i < m_vTrackFrame.bottom; i++) {
				memcpy(&pData[i * dst_pitch], &GWorldDataPtr[i * m_iModRowsize], m_iRowsize);
			}
		}
	} else {
		for (i = 0; i < m_vTrackFrame.bottom; i++) {
			memcpy(&pData[i * dst_pitch], &GWorldDataPtr[i * m_iModRowsize], m_iRowsize);
		}
	}

	*rawSize = m_iRowsize * m_vTrackFrame.bottom;
	
	return m_iRowsize * m_vTrackFrame.bottom;
}