//	Quicktime Import Plugin for VirtualDub
//	Copyright (C) 2007 Josh Harris (tateu)
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "QTMovieDec.h"

OSErr CQTMovieDec::InitDecodeRaw()
{
	OSErr err;

	long numberOfSamples = 0;
	err = GetMediaSample (
			m_vMedia,
			m_compressedData,
			maxCompressedSize,
			&m_lRawFrameSize,
			0,
			NULL,
			NULL,
			NULL, //sampleDescriptionH,
			NULL,
			1, //maxNumberOfSamples
			&numberOfSamples,
			NULL);

	long m_lRequestedFrameSize;
	if (m_iRaw == QTMOVIE_RAW_MODE_V210)
		m_lRequestedFrameSize = m_vTrackFrame.right * m_vTrackFrame.bottom * 8.0/3.0;
	else if (m_iRaw == QTMOVIE_RAW_MODE_RGB)
		m_lRequestedFrameSize = m_vTrackFrame.right * m_vTrackFrame.bottom * 3;
	else if (m_iRaw == QTMOVIE_RAW_MODE_ARGB)
		m_lRequestedFrameSize = m_vTrackFrame.right * m_vTrackFrame.bottom * 4;
	else
		m_lRequestedFrameSize = m_vTrackFrame.right * m_vTrackFrame.bottom * 2;

	if (m_iRaw < QTMOVIE_RAW_MODE_YUV2) {
		if (m_lRawFrameSize < m_lRequestedFrameSize) {
			//Cannot decode raw
			sprintf(strStatus, "\nError retrieving uncompressed data.\n"
				"Does not appear to be in %s format\n"
				"Requested frame size is: %d\n"
				"Actual Frame size is: %d\n",
				( m_iRaw == QTMOVIE_RAW_MODE_RGB ? "RGB" :
				( m_iRaw == QTMOVIE_RAW_MODE_ARGB ? "RGBA" :
				( m_iRaw == QTMOVIE_RAW_MODE_UYVY ? "UYVY" :
				( m_iRaw == QTMOVIE_RAW_MODE_V210 ? "V210" :
				( m_iRaw == QTMOVIE_RAW_MODE_YUYV ? "YUYV" :
				( m_iRaw == QTMOVIE_RAW_MODE_YVYU ? "YVYU" :
				( m_iRaw == QTMOVIE_RAW_MODE_VYUY ? "VYUY" : "YUV2" ))))))),
				m_lRequestedFrameSize,
				m_lRawFrameSize);
			return -1;
		} else if (m_lRawFrameSize > (m_lRequestedFrameSize * 1.33)) {
			// 2005-01-09, changed max value for allowed raw frame size from
			// (width * height * 3) to (m_lRequestedFrameSize * 1.33)
			// this should allow room for 10bit video
			// Cannot decode raw
			sprintf(strStatus, "\nError retrieving uncompressed data.\n"
				"Does not appear to be in %s format\n"
				"Requested frame size is: %d\n"
				"Actual Frame size is: %d\n",
				( m_iRaw == QTMOVIE_RAW_MODE_RGB ? "RGB" :
				( m_iRaw == QTMOVIE_RAW_MODE_ARGB ? "RGBA" :
				( m_iRaw == QTMOVIE_RAW_MODE_UYVY ? "UYVY" :
				( m_iRaw == QTMOVIE_RAW_MODE_V210 ? "V210" :
				( m_iRaw == QTMOVIE_RAW_MODE_YUYV ? "YUYV" :
				( m_iRaw == QTMOVIE_RAW_MODE_YVYU ? "YVYU" :
				( m_iRaw == QTMOVIE_RAW_MODE_VYUY ? "VYUY" : "YUV2" ))))))),
				m_lRequestedFrameSize,
				m_lRawFrameSize);
			return -1;
		}
#ifdef YUV_ALPHA
		else {
			// AYUV AND YUVA
			if (m_lRawFrameSize < (m_vTrackFrame.right * m_vTrackFrame.bottom * 4)) {
				sprintf(strStatus, "\nError retrieving uncompressed data.\n"
					"Does not appear to be in %s format\n"
					"Requested frame size is: %d\n"
					"Actual Frame size is: %d\n",
					( m_iRaw == 5 ? "AYUV" :
					( m_iRaw == 6 ? "YUVA" : "???" ) ),
					(m_vTrackFrame.right * m_vTrackFrame.bottom * 4),
					m_lRawFrameSize);
				goto TerminateQuickTime;
			} else if (m_lRawFrameSize > (m_vTrackFrame.right * m_vTrackFrame.bottom * 4.5)) {
				sprintf(strStatus, "\nError retrieving uncompressed data.\n"
					"Does not appear to be in %s format\n"
					"Requested frame size is: %d\n"
					"Actual Frame size is: %d\n",
					( m_iRaw == 5 ? "AYUV" :
					( m_iRaw == 6 ? "YUVA" : "???" ) ),
					(m_vTrackFrame.right * m_vTrackFrame.bottom * 4),
					m_lRawFrameSize);
				goto TerminateQuickTime;
			}
		}
#endif
	}

	return noErr;
}