//	Quicktime Import Plugin for VirtualDub
//	Copyright (C) 2007 Josh Harris (tateu)
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "QTMovieDec.h"

extern frameDataStruct				frameData;
extern myFrameBuffer				m_sFrameBuffer;
extern vector<myFrameBuffer>		m_vFrameBuffer;

OSErr CQTMovieDec::InitDecodeShared()
{
	// Used in mode 0, 1, 2, 4
	OSErr err;

	// variables that hold quicktime frame data
	GWorldDataPtr = (byte *)malloc(m_vTrackFrame.bottom * m_iModRowsize * 4.5);
	pDataCompressed = (byte *)malloc(m_vTrackFrame.bottom  * m_iModRowsize * 4.5);

	//if (m_iMode == 4)
	//	return noErr;

	err = QTNewGWorldFromPtr(
		&m_GWorld,
		m_pixelFormat,
		&m_vTrackFrame,
		NULL,					//CTabHandle cTable,
		NULL,					//GDHandle aGDevice,
		0,						//GWorldFlags flags noNewDevice
		(void*)GWorldDataPtr,	//void *baseAddr,
		m_iModRowsize);

	if (err != noErr) {
		sprintf(strStatus, "QTNewGWorldFromPtr Error: %d", err);
		return 0;
	}

	m_PixMap = GetGWorldPixMap(m_GWorld);

	// Modify the gamma display values
	// Only works on YUV
	if (m_pixelFormat == kYUVSPixelFormat) {
		Fixed pixGammaRequest = QTGetPixMapHandleRequestedGammaLevel(m_PixMap);
		Fixed pixGamma = QTGetPixMapHandleGammaLevel(m_PixMap);

		if (m_fGamma == 0)
			m_fGamma = FixedToFloat(pixGamma);

		if (m_fGamma > 0) {
			QTSetPixMapHandleRequestedGammaLevel(m_PixMap, FloatToFixed(m_fGamma));
		}
	}

	if (err != noErr) {
		sprintf(strStatus, "Unable to Create New GWorld, error: %d, width=%d, height=%d, rowsize=%d",
			err, m_vTrackFrame.right, m_vTrackFrame.bottom, m_iRowsize);
		return err;
		//goto TerminateQuickTime;
	} else {
		// call LockPixels to prevent the base address for
		// an offscreen pixel image from being moved while you
		// draw into or copy from its pixel map
		if (! LockPixels(m_PixMap)) {
			sprintf(strStatus, "Unable to lock PixMap");
			return -1;
			//goto TerminateQuickTime;
		}
	}

	// Put the movie into the new GWorld
	SetMovieGWorld(m_Movie, m_GWorld, nil);

	return noErr;
}

OSErr CQTMovieDec::InitDecodeFindCodec(CompressorComponent &compressor,
								 DecompressorComponent &decompressor)
{
	// Used in mode 0, 1, 2, 4
	OSErr err;

	// Get codec info
	// search quicktime for the codec, based on 
	err = FindCodec(m_CodecInfo.m_iFourCC, anyCodec, &compressor, &decompressor);
	if (err != noErr) {
		if (m_iMode == QTMOVIE_MODE_VFW || m_iMode == QTMOVIE_MODE_RAW)
			return noErr;

		sprintf(strStatus, "InitDecodeFindCodec: %d\n%c%c%c%c,%s", err,
			(m_CodecInfo.m_iFourCC & 0xFF000000) >> 24,
			(m_CodecInfo.m_iFourCC & 0x00FF0000) >> 16,
			(m_CodecInfo.m_iFourCC & 0x0000FF00) >> 8,
			(m_CodecInfo.m_iFourCC & 0x000000FF),
			m_CodecInfo.strFourCC);			
		return err;
	}

	memset(m_DecoderCodecInfo.CodecName, 0, sizeof(m_DecoderCodecInfo.CodecName));
	memset(m_DecoderCodecInfo.strFourCC, 0, sizeof(m_DecoderCodecInfo.strFourCC));
	m_DecoderCodecInfo.m_iFourCC = m_CodecInfo.m_iFourCC;

	if (decompressor && m_CodecInfo.m_iFourCC != FOUR_CHAR_CODE('raw ')) {
		CodecInfo info;
		err = GetCodecInfo(&info, m_CodecInfo.m_iFourCC, decompressor);
		if (err != noErr)
			return noErr;

		memcpy(m_DecoderCodecInfo.CodecName, &info.typeName[1], info.typeName[0]);

		CodecNameSpecListPtr list;
		err = GetCodecNameList(&list, 1);
		if (err != noErr)
			return noErr;

		for (int i = 0; i < list->count; i++) {
			char name[32];
			memset(name, 0, sizeof(name));
			memcpy(name,
					&(list->list[i].typeName[1]), list->list[i].typeName[0]);
			if (strcmp(m_DecoderCodecInfo.CodecName, name) == 0) {
					m_DecoderCodecInfo.m_iFourCC = list->list[i].cType;
				break;
			}
		}
	}

	return noErr;
}

OSErr CQTMovieDec::InitDecodeDataPointers()
{
	// Used in mode 1, 2
	m_compressedData = NewHandle(maxCompressedSize);
	if (m_compressedData == NULL) {
		sprintf(strStatus, "InitDecodeDataPointers Unable to Allocate Memory");
		return -1;
	}

	MoveHHi(m_compressedData);
	HLock(m_compressedData);
	m_compressedDataPtr = StripAddress(*m_compressedData);

	m_lRowBytes = QTGetPixMapHandleRowBytes(m_PixMap);
	m_decompressedDataPtr = GetPixBaseAddr(m_PixMap);

	return noErr;
}

bool CQTMovieDec::UpdateFrameBuffer(byte *pBuffer, long frame, bool bForward)
{
	// Used in mode 2, 4
	if (m_vFrameBuffer.size() > 7) {
		if (bForward) {
			delete [] m_vFrameBuffer.begin()->data;
			m_vFrameBuffer.erase(m_vFrameBuffer.begin());
		} else {
			delete [] m_vFrameBuffer.end()->data;
			m_vFrameBuffer.erase(m_vFrameBuffer.end());
		}
	}

	/*sprintf(strStatus,
		//"F:/_Programming/C_Plus_Commercial/AviSynth Plugins/QTSource/Release/"
		//"___X264/UpdateFrameBuffer_i_05d_req_05d_buf%05d.raw",
		"UpdateFrameBuffer_i_05d_req_05d_buf%05d.raw",
		/*i, frame,* frame);*/

	//m_vFrameBuffer.push_back(frameBuffer);

	m_vFrameBuffer.resize(m_vFrameBuffer.size() + 1);
	m_vFrameBuffer[m_vFrameBuffer.size()-1].data = new byte[m_vTrackFrame.bottom*m_iRowsize];
	memcpy(m_vFrameBuffer[m_vFrameBuffer.size()-1].data, pBuffer, m_vTrackFrame.bottom*m_iRowsize);
	m_vFrameBuffer[m_vFrameBuffer.size()-1].frame = frame;

	/*myFrameBuffer frameBuffer;
	frameBuffer.data = new byte[m_vTrackFrame.bottom*m_iRowsize];
	memcpy(frameBuffer.data, pBuffer, m_vTrackFrame.bottom*m_iRowsize);
	frameBuffer.frame = frame;
	m_vFrameBuffer.push_back(frameBuffer);*/

	/*sprintf(strStatus,
		"Add Buffer # %d, size=%d, end=%d\n",
		frame, m_vFrameBuffer.size(), m_vFrameBuffer.end());*/

	return true;
}

int CQTMovieDec::IsFrameInBuffer(long frame)
{
	int i;
	// Used in mode 2, 4
	for (i = 0; i < m_vFrameBuffer.size(); i++) {
		/*sprintf(strStatus,
			"Check Buffer #%d, %d=%d\n",
			i, frame, m_vFrameBuffer[i].frame);*/

		if (m_vFrameBuffer[i].frame == frame) {
			return i;
		}
	}
	return -1;
}